/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.model;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.linkki.tooling.apt.model.AptAspectSubject;
import org.linkki.tooling.apt.model.AptAttribute;
import org.linkki.tooling.apt.model.AptModelAttribute;
import org.linkki.tooling.apt.model.AptModelObject;
import org.linkki.tooling.apt.util.MethodNameUtils;
import org.linkki.tooling.apt.util.PositionUtil;

public class AptComponentDeclaration
implements AptAspectSubject {
    private final List<AptAttribute> attributes;
    private final Optional<AptModelObject> modelObject;
    private final Optional<AptModelAttribute> modelAttribute;
    private final ExecutableElement element;
    private final AnnotationMirror annotationMirror;

    public AptComponentDeclaration(List<AptAttribute> attributes, Optional<AptModelObject> modelObject, Optional<AptModelAttribute> modelAttribute, ExecutableElement element, AnnotationMirror annotationMirror) {
        this.attributes = attributes;
        this.modelObject = modelObject;
        this.modelAttribute = modelAttribute;
        this.element = element;
        this.annotationMirror = annotationMirror;
    }

    public int getPosition() {
        return PositionUtil.findPositionAttribute(this.getAttributes()).map(AptAttribute::getValue).map(Integer.class::cast).orElseThrow(() -> new IllegalStateException("expected position to be an int"));
    }

    public Optional<String> getLabel() {
        return AptAttribute.findByName(this.getAttributes(), "label").map(AptAttribute::getValue).map(String.class::cast);
    }

    @NonNull
    public Optional<String> getCaption() {
        return AptAttribute.findByName(this.getAttributes(), "caption").map(AptAttribute::getValue).map(String.class::cast);
    }

    public String getPropertyName() {
        return MethodNameUtils.getPropertyName(this.element);
    }

    public boolean isDirectModelBinding() {
        return this.element.getReturnType().getKind() == TypeKind.VOID;
    }

    public List<AptAttribute> getAttributes() {
        return this.attributes;
    }

    public Optional<AptModelObject> getModelObject() {
        return this.modelObject;
    }

    public Optional<AptModelAttribute> getModelAttribute() {
        return this.modelAttribute;
    }

    @Override
    public ExecutableElement getElement() {
        return this.element;
    }

    @Override
    public AnnotationMirror getAnnotationMirror() {
        return this.annotationMirror;
    }

    public boolean isUsingStandardModelBindingAttributes() {
        return AptAttribute.findByName(this.getAttributes(), "modelObject").isPresent() && AptAttribute.findByName(this.getAttributes(), "modelAttribute").isPresent();
    }
}

