/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.validator;

import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.Messager;
import javax.lang.model.element.ExecutableElement;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.linkki.tooling.apt.model.AptAttribute;
import org.linkki.tooling.apt.model.AptComponent;
import org.linkki.tooling.apt.model.AptComponentDeclaration;
import org.linkki.tooling.apt.model.AptPmo;
import org.linkki.tooling.apt.util.ElementUtils;
import org.linkki.tooling.apt.util.PositionUtil;
import org.linkki.tooling.apt.util.SuppressedWarningsUtils;
import org.linkki.tooling.apt.validator.MessageCodes;
import org.linkki.tooling.apt.validator.Messages;
import org.linkki.tooling.apt.validator.Severity;
import org.linkki.tooling.apt.validator.Validator;

@MessageCodes(value={"MISSING_METHOD", "DYNAMIC_FIELD_MISMATCH"})
public class DynamicFieldValidator
implements Validator {
    public static final String MISSING_METHOD = "MISSING_METHOD";
    public static final String DYNAMIC_FIELD_MISMATCH = "DYNAMIC_FIELD_MISMATCH";
    private final Diagnostic.Kind missingMethodSeverity;
    private final Diagnostic.Kind positionMismatchSeverity;
    private final ElementUtils elementUtils;

    public DynamicFieldValidator(Map<String, String> options, ElementUtils elementUtils) {
        this.elementUtils = elementUtils;
        this.missingMethodSeverity = Severity.of(options, MISSING_METHOD, Diagnostic.Kind.ERROR);
        this.positionMismatchSeverity = Severity.of(options, DYNAMIC_FIELD_MISMATCH, Diagnostic.Kind.ERROR);
    }

    @Override
    public void validate(AptPmo pmo, Messager messager) {
        if (this.missingMethodSeverity != Diagnostic.Kind.OTHER && !SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.missingMethodSeverity)) {
            this.checkComponentTypeMethod(messager, pmo);
        }
        if (this.positionMismatchSeverity != Diagnostic.Kind.OTHER && !SuppressedWarningsUtils.isSuppressed(pmo.getElement(), this.positionMismatchSeverity)) {
            this.checkPositionMismatch(messager, pmo);
        }
    }

    private void checkComponentTypeMethod(Messager messager, AptPmo pmo) {
        Set<ExecutableElement> allMethods = this.elementUtils.getAllMethods(pmo.getElement());
        Set componentTypeMethods = allMethods.stream().map(it -> it.getSimpleName().toString()).filter(it -> it.startsWith("get") && it.endsWith("ComponentType")).collect(Collectors.toSet());
        pmo.getComponents().stream().filter(AptComponent::isDynamicField).filter(it -> !componentTypeMethods.contains(this.getExpectedName((AptComponent)it))).flatMap(it -> it.getComponentDeclarations().stream()).filter(it -> !SuppressedWarningsUtils.isSuppressed(it.getElement(), this.missingMethodSeverity)).forEach(it -> {
            String message = Messages.format(MISSING_METHOD, it.getAnnotationMirror(), this.getExpectedName((AptComponentDeclaration)it), it.getPropertyName());
            messager.printMessage(this.missingMethodSeverity, message, it.getElement(), it.getAnnotationMirror());
        });
    }

    private void checkPositionMismatch(Messager messager, AptPmo pmo) {
        pmo.getComponents().stream().filter(AptComponent::isDynamicField).filter(it -> !this.hasSamePositions((AptComponent)it)).flatMap(it -> it.getComponentDeclarations().stream()).filter(it -> !SuppressedWarningsUtils.isSuppressed(it.getElement(), this.positionMismatchSeverity)).forEach(it -> {
            String message = Messages.format(DYNAMIC_FIELD_MISMATCH, it.getAnnotationMirror(), it.getPropertyName());
            Optional<AptAttribute> positionAttribute = PositionUtil.findPositionAttribute(it.getAttributes());
            if (positionAttribute.isPresent()) {
                messager.printMessage(this.positionMismatchSeverity, message, it.getElement(), it.getAnnotationMirror(), positionAttribute.get().getAnnotationValue());
            } else {
                messager.printMessage(this.positionMismatchSeverity, message, it.getElement(), it.getAnnotationMirror());
            }
        });
    }

    private boolean hasSamePositions(AptComponent component) {
        return component.getComponentDeclarations().stream().mapToInt(AptComponentDeclaration::getPosition).allMatch(it -> component.getPosition() == it);
    }

    private String getExpectedName(AptComponentDeclaration componentDeclaration) {
        return this.getExpectedName(componentDeclaration.getPropertyName());
    }

    private String getExpectedName(AptComponent component) {
        return this.getExpectedName(component.getPropertyName());
    }

    private String getExpectedName(String propertyName) {
        return "get" + StringUtils.capitalize((String)propertyName) + "ComponentType";
    }
}

