/*
 * Decompiled with CFR 0.152.
 */
package org.linkki.tooling.apt.util;

import java.lang.reflect.Type;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeKind;
import org.apache.commons.lang3.StringUtils;
import org.linkki.util.BeanUtils;

public class MethodNameUtils {
    private MethodNameUtils() {
    }

    public static String toPropertyName(Type returnType, String methodName) {
        return BeanUtils.getPropertyName((Type)returnType, (String)methodName);
    }

    public static boolean isGetter(String methodName) {
        return methodName.startsWith("get") || methodName.startsWith("is");
    }

    public static String getPropertyName(ExecutableElement method) {
        return MethodNameUtils.toPropertyName(method.getReturnType().getKind(), method.getSimpleName().toString());
    }

    public static String getAspectMethodRegex(String propertyName, String aspectName) {
        return "(is|get)" + StringUtils.capitalize((String)propertyName) + StringUtils.capitalize((String)aspectName);
    }

    public static String toPropertyName(TypeKind kind, String methodName) {
        if (TypeKind.VOID.equals((Object)kind)) {
            return MethodNameUtils.toPropertyName(Void.TYPE, methodName);
        }
        return MethodNameUtils.toPropertyName(Object.class, methodName);
    }
}

