/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.changelog;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.changelog.StandardChangeLogHistoryService;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.ExecutorService;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;

public class CassandraChangeLogHistoryService
extends StandardChangeLogHistoryService {
    public int getPriority() {
        return 5;
    }

    public boolean supports(Database database) {
        return database instanceof CassandraDatabase;
    }

    public boolean hasDatabaseChangeLogTable() {
        return ((CassandraDatabase)this.getDatabase()).hasDatabaseChangeLogLockTable();
    }

    public int getNextSequenceValue() {
        int next = 0;
        try {
            Statement statement = ((CassandraDatabase)this.getDatabase()).getStatement();
            ResultSet rs = statement.executeQuery("SELECT ID, AUTHOR, ORDEREXECUTED FROM " + this.getDatabase().getDefaultCatalogName() + ".DATABASECHANGELOG");
            while (rs.next()) {
                int order = rs.getInt("ORDEREXECUTED");
                next = Math.max(order, next);
            }
            statement.close();
        }
        catch (SQLException | DatabaseException e) {
            e.printStackTrace();
        }
        return next + 1;
    }

    public List<Map<String, ?>> queryDatabaseChangeLogTable(Database database) throws DatabaseException {
        RawSqlStatement select = new RawSqlStatement("SELECT * FROM " + database.getDefaultCatalogName() + ".DATABASECHANGELOG");
        List returnList = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)select);
        returnList.sort(Comparator.comparing(o -> (Date)o.get("DATEEXECUTED")).thenComparingInt(o -> (Integer)o.get("ORDEREXECUTED")));
        return returnList;
    }
}

