/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.database;

import com.simba.cassandra.cassandra.core.CDBJDBCConnection;
import com.simba.cassandra.jdbc.jdbc42.S42Connection;
import java.sql.SQLException;
import java.sql.Statement;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.DatabaseConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;

public class CassandraDatabase
extends AbstractJdbcDatabase {
    public static final String PRODUCT_NAME = "Cassandra";
    private String keyspace;

    public String getShortName() {
        return "cassandra";
    }

    public int getPriority() {
        return 1;
    }

    protected String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public Integer getDefaultPort() {
        return 9160;
    }

    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    public boolean supportsSequences() {
        return false;
    }

    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        String databaseProductName = conn.getDatabaseProductName();
        return PRODUCT_NAME.equalsIgnoreCase(databaseProductName);
    }

    public String getDefaultDriver(String url) {
        return "com.simba.cassandra.jdbc42.Driver";
    }

    public boolean supportsTablespaces() {
        return false;
    }

    public boolean supportsRestrictForeignKeys() {
        return false;
    }

    public boolean supportsDropTableCascadeConstraints() {
        return false;
    }

    public boolean isAutoCommit() {
        return true;
    }

    public void setAutoCommit(boolean b) {
    }

    public boolean isCaseSensitive() {
        return true;
    }

    public String getCurrentDateTimeFunction() {
        return String.valueOf(System.currentTimeMillis());
    }

    public String getKeyspace() {
        if (this.keyspace == null) {
            try {
                if (this.getConnection() instanceof JdbcConnection) {
                    this.keyspace = ((CDBJDBCConnection)((S42Connection)((JdbcConnection)this.getConnection()).getUnderlyingConnection()).getConnection()).getSession().getLoggedKeyspace();
                }
            }
            catch (Exception e) {
                Scope.getCurrentScope().getLog(CassandraDatabase.class).severe("Could not get keyspace from connection", (Throwable)e);
            }
        }
        return this.keyspace;
    }

    public boolean supportsSchemas() {
        return false;
    }

    public String getDefaultCatalogName() {
        return this.getKeyspace();
    }

    public Statement getStatement() throws DatabaseException {
        return ((JdbcConnection)super.getConnection()).createStatement();
    }

    public boolean hasDatabaseChangeLogLockTable() {
        boolean hasChangeLogLockTable;
        try {
            Statement statement = this.getStatement();
            statement.executeQuery("SELECT ID from " + this.getDefaultCatalogName() + ".DATABASECHANGELOGLOCK");
            statement.close();
            hasChangeLogLockTable = true;
        }
        catch (SQLException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No DATABASECHANGELOGLOCK available in cassandra.");
            hasChangeLogLockTable = false;
        }
        catch (DatabaseException e) {
            e.printStackTrace();
            hasChangeLogLockTable = false;
        }
        return hasChangeLogLockTable;
    }

    public boolean jdbcCallsCatalogsSchemas() {
        return true;
    }

    public boolean supportsNotNullConstraintNames() {
        return false;
    }

    public boolean supportsPrimaryKeyNames() {
        return false;
    }
}

