/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.snapshot;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.jvm.ColumnSnapshotGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Relation;
import liquibase.util.StringUtil;

public class ColumnSnapshotGeneratorCassandra
extends ColumnSnapshotGenerator {
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (database instanceof CassandraDatabase) {
            int priority = super.getPriority(objectType, database);
            return priority == 0 ? priority : priority + 5;
        }
        return -1;
    }

    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException {
        if (!snapshot.getSnapshotControl().shouldInclude(Column.class)) {
            return;
        }
        if (foundObject instanceof Relation) {
            Database database = snapshot.getDatabase();
            Relation relation = (Relation)foundObject;
            String query = String.format("SELECT KEYSPACE_NAME, COLUMN_NAME, TYPE, KIND FROM system_schema.columns WHERE KEYSPACE_NAME = '%s' AND table_name='%s';", database.getDefaultCatalogName(), relation.getName());
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
            List returnList = executor.queryForList((SqlStatement)new RawSqlStatement(query));
            for (Map columnPropertiesMap : returnList) {
                relation.getColumns().add(this.readColumn(columnPropertiesMap, relation));
            }
        }
    }

    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException {
        Database database = snapshot.getDatabase();
        Relation relation = ((Column)example).getRelation();
        String query = String.format("SELECT KEYSPACE_NAME, COLUMN_NAME, TYPE, KIND FROM system_schema.columns WHERE keyspace_name = '%s' AND table_name='%s';", database.getDefaultCatalogName(), relation);
        List returnList = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database).queryForList((SqlStatement)new RawSqlStatement(query));
        if ((returnList = returnList.stream().filter(stringMap -> ((String)stringMap.get("COLUMN_NAME")).equalsIgnoreCase(example.getName())).collect(Collectors.toList())).size() != 1) {
            Scope.getCurrentScope().getLog(ColumnSnapshotGeneratorCassandra.class).warning(String.format("expecting exactly 1 column with name %s, got %s", example.getName(), returnList.size()));
            return null;
        }
        return this.readColumn((Map)returnList.get(0), relation);
    }

    protected Column readColumn(Map<String, ?> tableMap, Relation table) {
        String rawColumnName = StringUtil.trimToNull((String)((String)tableMap.get("COLUMN_NAME")));
        String rawColumnType = StringUtil.trimToNull((String)((String)tableMap.get("TYPE")));
        String rawColumnKind = StringUtil.trimToNull((String)((String)tableMap.get("KIND")));
        Column column = new Column();
        column.setName(rawColumnName);
        column.setRelation(table);
        column.setNullable(Boolean.valueOf(!"partition_key".equalsIgnoreCase(rawColumnKind)));
        column.setType(new DataType(rawColumnType));
        return column;
    }
}

