/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DeleteGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DeleteStatement;
import liquibase.structure.DatabaseObject;

public class DeleteGeneratorCassandra
extends DeleteGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(DeleteStatement statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(DeleteStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (statement.getWhere() == null) {
            String sql = "TRUNCATE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName());
            return new Sql[]{new UnparsedSql(sql, new DatabaseObject[]{this.getAffectedTable(statement)})};
        }
        return super.generateSql(statement, database, sqlGeneratorChain);
    }
}

