/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import java.util.ArrayList;
import java.util.List;
import liquibase.database.Database;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.DropColumnGenerator;
import liquibase.statement.core.DropColumnStatement;
import liquibase.structure.DatabaseObject;

public class DropColumnGeneratorCassandra
extends DropColumnGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(DropColumnStatement statement, Database database) {
        return database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(DropColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (statement.isMultiple()) {
            return this.generateMultipleColumnSql(statement.getColumns(), database);
        }
        return this.generateSingleColumnSql(statement, database);
    }

    private Sql[] generateMultipleColumnSql(List<DropColumnStatement> columns, Database database) {
        ArrayList<Sql> result = new ArrayList<Sql>();
        for (DropColumnStatement column : columns) {
            result.add(this.generateSingleColumnSql(column, database)[0]);
        }
        return result.toArray(new Sql[result.size()]);
    }

    private Sql[] generateSingleColumnSql(DropColumnStatement statement, Database database) {
        return new Sql[]{new UnparsedSql("ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " DROP " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()), new DatabaseObject[]{this.getAffectedColumn(statement)})};
    }
}

