/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.cassandra.sqlgenerator;

import liquibase.database.Database;
import liquibase.ext.cassandra.database.CassandraDatabase;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.sqlgenerator.core.LockDatabaseChangeLogGenerator;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.LockDatabaseChangeLogStatement;
import liquibase.statement.core.RawSqlStatement;

public class LockDatabaseChangeLogGeneratorCassandra
extends LockDatabaseChangeLogGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(LockDatabaseChangeLogStatement statement, Database database) {
        return super.supports((SqlStatement)statement, database) && database instanceof CassandraDatabase;
    }

    public Sql[] generateSql(LockDatabaseChangeLogStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        RawSqlStatement updateStatement = new RawSqlStatement("UPDATE " + database.escapeTableName(database.getLiquibaseCatalogName(), database.getLiquibaseSchemaName(), "databasechangeloglock") + " SET LOCKED = TRUE, LOCKEDBY = '" + hostname + " (" + hostaddress + ")', LOCKGRANTED = " + System.currentTimeMillis() + " WHERE ID = 1");
        return SqlGeneratorFactory.getInstance().generateSql((SqlStatement)updateStatement, database);
    }
}

