/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.creatematerializedview;

import liquibase.change.AbstractChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.ora.creatematerializedview.CreateMaterializedViewStatement;
import liquibase.ext.ora.dropmaterializedview.DropMaterializedViewChange;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createMaterializedView", description="Create materialized view", priority=201)
public class CreateMaterializedViewChange
extends AbstractChange {
    private String schemaName;
    private String viewName;
    private String columnAliases;
    private String objectType;
    private Boolean reducedPrecision;
    private Boolean usingIndex;
    private String tableSpace;
    private Boolean forUpdate;
    private String queryRewrite;
    private String subquery;

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public void setViewName(String viewName) {
        this.viewName = viewName;
    }

    public String getColumnAliases() {
        return this.columnAliases;
    }

    public void setColumnAliases(String columnAliases) {
        this.columnAliases = columnAliases;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public Boolean getReducedPrecision() {
        return this.reducedPrecision;
    }

    public void setReducedPrecision(Boolean reducedPrecision) {
        this.reducedPrecision = reducedPrecision;
    }

    public Boolean getUsingIndex() {
        return this.usingIndex;
    }

    public void setUsingIndex(Boolean usingIndex) {
        this.usingIndex = usingIndex;
    }

    public String getTableSpace() {
        return this.tableSpace;
    }

    public void setTableSpace(String tableSpace) {
        this.tableSpace = tableSpace;
    }

    public Boolean getForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(Boolean forUpdate) {
        this.forUpdate = forUpdate;
    }

    public String getQueryRewrite() {
        return this.queryRewrite;
    }

    public void setQueryRewrite(String queryRewrite) {
        this.queryRewrite = queryRewrite;
    }

    public String getSubquery() {
        return this.subquery;
    }

    public void setSubquery(String subquery) {
        this.subquery = subquery;
    }

    public String getConfirmationMessage() {
        return "Materialized view " + this.getViewName() + " has been created";
    }

    protected Change[] createInverses() {
        DropMaterializedViewChange inverse = new DropMaterializedViewChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setViewName(this.getViewName());
        return new Change[]{inverse};
    }

    public SqlStatement[] generateStatements(Database database) {
        CreateMaterializedViewStatement statement = new CreateMaterializedViewStatement(this.getViewName(), this.getSubquery());
        statement.setSchemaName(this.getSchemaName());
        statement.setColumnAliases(this.getColumnAliases());
        statement.setObjectType(this.getObjectType());
        statement.setReducedPrecision(this.getReducedPrecision());
        statement.setUsingIndex(this.getUsingIndex());
        statement.setTableSpace(this.getTableSpace());
        statement.setForUpdate(this.getForUpdate());
        statement.setQueryRewrite(this.getQueryRewrite());
        return new SqlStatement[]{statement};
    }
}

