/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.grant;

import java.util.ArrayList;
import liquibase.exception.ValidationErrors;
import liquibase.statement.AbstractSqlStatement;
import liquibase.util.StringUtils;

public abstract class AbstractObjectPermissionStatement
extends AbstractSqlStatement {
    protected String schemaName;
    protected String objectName;
    protected String recipientList;
    private Boolean select = Boolean.FALSE;
    private Boolean update = Boolean.FALSE;
    private Boolean insert = Boolean.FALSE;
    private Boolean delete = Boolean.FALSE;
    private Boolean execute = Boolean.FALSE;
    private Boolean references = Boolean.FALSE;
    private Boolean index = Boolean.FALSE;

    public AbstractObjectPermissionStatement() {
    }

    public AbstractObjectPermissionStatement(String schemaName, String objectName, String recipientList) {
        this();
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.recipientList = recipientList;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getRecipientList() {
        return this.recipientList;
    }

    public void setRecipientList(String recipientList) {
        this.recipientList = recipientList;
    }

    public Boolean getSelect() {
        if (this.select == null) {
            return false;
        }
        return this.select;
    }

    public void setSelect(Boolean select) {
        this.select = select;
    }

    public Boolean getUpdate() {
        if (this.update == null) {
            return false;
        }
        return this.update;
    }

    public void setUpdate(Boolean update) {
        this.update = update;
    }

    public Boolean getInsert() {
        if (this.insert == null) {
            return false;
        }
        return this.insert;
    }

    public void setInsert(Boolean insert) {
        this.insert = insert;
    }

    public Boolean getDelete() {
        if (this.delete == null) {
            return false;
        }
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }

    public Boolean getExecute() {
        if (this.execute == null) {
            return false;
        }
        return this.execute;
    }

    public void setExecute(Boolean execute) {
        this.execute = execute;
    }

    public Boolean getReferences() {
        if (this.references == null) {
            return false;
        }
        return this.references;
    }

    public void setReferences(Boolean references) {
        this.references = references;
    }

    public Boolean getIndex() {
        if (this.index == null) {
            return false;
        }
        return this.index;
    }

    public void setIndex(Boolean index) {
        this.index = index;
    }

    public String getPermissionList() {
        ArrayList<String> permissions = new ArrayList<String>(7);
        if (this.getSelect().booleanValue()) {
            permissions.add("SELECT");
        }
        if (this.getUpdate().booleanValue()) {
            permissions.add("UPDATE");
        }
        if (this.getInsert().booleanValue()) {
            permissions.add("INSERT");
        }
        if (this.getDelete().booleanValue()) {
            permissions.add("DELETE");
        }
        if (this.getExecute().booleanValue()) {
            permissions.add("EXECUTE");
        }
        if (this.getReferences().booleanValue()) {
            permissions.add("REFERENCES");
        }
        if (this.getIndex().booleanValue()) {
            permissions.add("INDEX");
        }
        return StringUtils.join(permissions, (String)",");
    }

    public ValidationErrors validate() {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)this.getObjectName());
        validationErrors.checkRequiredField("recipientList", (Object)this.getRecipientList());
        if (!(this.getSelect().booleanValue() || this.getUpdate().booleanValue() || this.getInsert().booleanValue() || this.getDelete().booleanValue() || this.getExecute().booleanValue() || this.getIndex().booleanValue() || this.getReferences().booleanValue())) {
            validationErrors.addError("You must specify at least one permission.");
        }
        return validationErrors;
    }
}

