/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.CreateSynonymChange;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymChange;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import liquibase.change.Change;
import liquibase.change.core.OutputChange;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.ChangedObjectChangeGenerator;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class ChangedSynonymChangeGenerator
extends LicenseCheckingChangeGenerator
implements ChangedObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Synonym.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return null;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return null;
    }

    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences object, DiffOutputControl diffOutputControl, Database database, Database object2, ChangeGeneratorChain object3) {
        object = (Synonym)databaseObject;
        object2 = new DropSynonymChange();
        ((DropSynonymChange)((Object)object2)).setSynonymName(((Synonym)((Object)object)).getName());
        ((DropSynonymChange)((Object)object2)).setObjectType(((Synonym)((Object)object)).getObjectType());
        if (!(database instanceof MSSQLDatabase)) {
            ((DropSynonymChange)((Object)object2)).setPrivate(((Synonym)((Object)object)).isPrivate());
        }
        if (diffOutputControl.getIncludeCatalog()) {
            ((DropSynonymChange)((Object)object2)).setSynonymCatalogName(((Synonym)((Object)object)).getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            ((DropSynonymChange)((Object)object2)).setSynonymSchemaName(((Synonym)((Object)object)).getSchema().getName());
        }
        object3 = new CreateSynonymChange();
        ((CreateSynonymChange)((Object)object3)).setSynonymName(((Synonym)((Object)object)).getName());
        ((CreateSynonymChange)((Object)object3)).setObjectName(((Synonym)((Object)object)).getObjectName());
        boolean bl2 = ((Synonym)((Object)object)).isPrivate();
        if (database instanceof MSSQLDatabase) {
            bl2 = false;
        }
        ((CreateSynonymChange)((Object)object3)).setPrivate(bl2);
        ((CreateSynonymChange)((Object)object3)).setObjectType(((Synonym)((Object)object)).getObjectType());
        if (bl2 && ((Synonym)((Object)object)).getSchema() != null) {
            if (diffOutputControl.getIncludeCatalog()) {
                ((CreateSynonymChange)((Object)object3)).setSynonymCatalogName(((Synonym)((Object)object)).getSchema().getCatalogName());
            }
            if (diffOutputControl.getIncludeSchema()) {
                ((CreateSynonymChange)((Object)object3)).setSynonymSchemaName(((Synonym)((Object)object)).getSchema().getName());
            }
        }
        if (((Synonym)((Object)object)).getObjectSchema() != null) {
            boolean bl3;
            bl2 = !StringUtil.trimToEmpty((String)((Synonym)((Object)object)).getObjectSchema().getCatalogName()).equalsIgnoreCase(StringUtil.trimToEmpty((String)database.getDefaultCatalogName()));
            boolean bl4 = bl3 = !StringUtil.trimToEmpty((String)((Synonym)((Object)object)).getObjectSchema().getName()).equalsIgnoreCase(StringUtil.trimToEmpty((String)database.getDefaultSchemaName()));
            if (bl2 || diffOutputControl.getIncludeCatalog()) {
                ((CreateSynonymChange)((Object)object3)).setObjectCatalogName(((Synonym)((Object)object)).getObjectSchema().getCatalogName());
            }
            if (bl3 || diffOutputControl.getIncludeSchema()) {
                ((CreateSynonymChange)((Object)object3)).setObjectSchemaName(((Synonym)((Object)object)).getObjectSchema().getName());
            }
        }
        if (database instanceof OracleDatabase && ((CreateSynonymChange)((Object)object3)).getSynonymCatalogName() != null && ((CreateSynonymChange)((Object)object3)).getSynonymSchemaName() == null) {
            Object object4 = object3;
            ((CreateSynonymChange)((Object)object4)).setSynonymSchemaName(((CreateSynonymChange)((Object)object4)).getSynonymCatalogName());
            ((CreateSynonymChange)((Object)object3)).setSynonymCatalogName(null);
        }
        if (database instanceof OracleDatabase && ((CreateSynonymChange)((Object)object3)).getObjectCatalogName() != null && ((CreateSynonymChange)((Object)object3)).getObjectSchemaName() == null) {
            Object object5 = object3;
            ((CreateSynonymChange)((Object)object5)).setObjectSchemaName(((CreateSynonymChange)((Object)object5)).getObjectCatalogName());
            ((CreateSynonymChange)((Object)object3)).setObjectCatalogName(null);
        }
        if (database instanceof OracleDatabase && ((Boolean)databaseObject.getAttribute("missingSchema", (Object)Boolean.FALSE)).booleanValue()) {
            OutputChange outputChange = new OutputChange();
            outputChange.setMessage("No schema found for the object pointed to by this synonym. This may mean it references an object across database link. Please ensure the synonym is being created correctly.");
            return new Change[]{outputChange, object2, object3};
        }
        return new Change[]{object2, object3};
    }
}

