/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.synonym.change;

import com.datical.liquibase.ext.appdba.synonym.Synonym;
import com.datical.liquibase.ext.appdba.synonym.change.DropSynonymStatement;
import java.util.ArrayList;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.DB2Database;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public class DropSynonymGenerator
extends AbstractSqlGenerator<DropSynonymStatement> {
    public boolean supports(DropSynonymStatement dropSynonymStatement, Database database) {
        return (database instanceof OracleDatabase || database instanceof AbstractDb2Database || database instanceof MSSQLDatabase || database instanceof EnterpriseDBDatabase) && super.supports((SqlStatement)dropSynonymStatement, database);
    }

    public ValidationErrors validate(DropSynonymStatement dropSynonymStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = new ValidationErrors();
        sqlGeneratorChain.checkRequiredField("synonymName", (Object)dropSynonymStatement.getSynonymName());
        sqlGeneratorChain.checkDisallowedField("synonymCatalogName", (Object)dropSynonymStatement.getSynonymCatalogName(), database, new Class[]{MSSQLDatabase.class});
        if (!(dropSynonymStatement.isPrivate() != null && dropSynonymStatement.isPrivate().booleanValue() || database instanceof MSSQLDatabase || dropSynonymStatement.getSynonymCatalogName() == null && dropSynonymStatement.getSynonymSchemaName() == null)) {
            sqlGeneratorChain.addError("Cannot specify schema name for non-private synonyms");
        }
        if (database instanceof DB2Database) {
            sqlGeneratorChain.checkRequiredField("objectType", (Object)dropSynonymStatement.getObjectType());
        }
        return sqlGeneratorChain;
    }

    public Warnings warn(DropSynonymStatement dropSynonymStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = super.warn((SqlStatement)dropSynonymStatement, database, sqlGeneratorChain);
        if (database instanceof MSSQLDatabase && dropSynonymStatement.isPrivate() != null && dropSynonymStatement.isPrivate().booleanValue()) {
            sqlGeneratorChain.addWarning("MSSQL does not support public synonyms. Dropping private synonym " + dropSynonymStatement.getSynonymName());
        }
        return sqlGeneratorChain;
    }

    public Sql[] generateSql(DropSynonymStatement object, Database sqlArray, SqlGeneratorChain object2) {
        object2 = sqlArray instanceof MSSQLDatabase ? sqlArray.escapeObjectName(null, ((DropSynonymStatement)((Object)object)).getSynonymSchemaName(), ((DropSynonymStatement)((Object)object)).getSynonymName(), Synonym.class) : (((DropSynonymStatement)((Object)object)).isPrivate() == null || ((DropSynonymStatement)((Object)object)).isPrivate() == false ? sqlArray.escapeObjectName(((DropSynonymStatement)((Object)object)).getSynonymName(), Synonym.class) : sqlArray.escapeObjectName(((DropSynonymStatement)((Object)object)).getSynonymCatalogName(), ((DropSynonymStatement)((Object)object)).getSynonymSchemaName(), ((DropSynonymStatement)((Object)object)).getSynonymName(), Synonym.class));
        StringBuilder stringBuilder = new StringBuilder("DROP ");
        if (!(!(sqlArray instanceof OracleDatabase) && !(sqlArray instanceof AbstractDb2Database) || ((DropSynonymStatement)((Object)object)).isPrivate() != null && ((DropSynonymStatement)((Object)object)).isPrivate().booleanValue())) {
            stringBuilder.append("PUBLIC ");
        }
        if (sqlArray instanceof AbstractDb2Database) {
            stringBuilder.append("ALIAS ");
        } else {
            stringBuilder.append("SYNONYM ");
        }
        stringBuilder.append((String)object2);
        object = new ArrayList<UnparsedSql>();
        object.add(new UnparsedSql(stringBuilder.toString(), new DatabaseObject[0]));
        sqlArray = new Sql[object.size()];
        return object.toArray(sqlArray);
    }
}

