/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.changelog.filter;

import java.util.List;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.exception.LiquibaseException;
import liquibase.logging.Logger;

public class SingleRanChangeSetFilter
implements ChangeSetFilter {
    private String id;
    private String author;
    private String filePath;
    private RanChangeSet matchingIdChangeSet = null;
    private ChangeSet changeSet;

    public SingleRanChangeSetFilter(String string, String string2, String string3, List<RanChangeSet> object, DatabaseChangeLog databaseChangeLog) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        object = object.iterator();
        while (object.hasNext()) {
            RanChangeSet ranChangeSet = (RanChangeSet)object.next();
            if (string.equalsIgnoreCase(ranChangeSet.getId()) && string2.equalsIgnoreCase(ranChangeSet.getAuthor()) && string3.equalsIgnoreCase(ranChangeSet.getChangeLog())) {
                this.changeSet = databaseChangeLog.getChangeSet(string3, string2, string);
                if (this.changeSet == null) {
                    logger.warning("Unable to locate the change for " + string + "::" + string2 + "::" + string3);
                    string = this.createNotFoundErrorMessage(databaseChangeLog, string, string2, string3);
                    throw new LiquibaseException(string);
                }
                logger.fine("FOUND the change for " + string + "::" + string2 + "::" + string3);
                this.id = string;
                this.author = string2;
                this.filePath = string3;
                return;
            }
            if (string.equalsIgnoreCase(ranChangeSet.getId())) {
                this.matchingIdChangeSet = ranChangeSet;
            } else {
                logger.fine("ID '" + string + "' did not match '" + ranChangeSet.getId() + "'");
            }
            if (!string2.equalsIgnoreCase(ranChangeSet.getAuthor())) {
                logger.fine("Author '" + string2 + "' did not match '" + ranChangeSet.getAuthor() + "'");
                continue;
            }
            if (string3.equalsIgnoreCase(ranChangeSet.getChangeLog())) continue;
            logger.fine("Path '" + string3 + "' did not match '" + ranChangeSet.getChangeLog() + "'");
            logger.fine("Path length: " + string3.length() + " changelog length: " + ranChangeSet.getChangeLog().length());
        }
    }

    public RanChangeSet getMatchingIdChangeSet() {
        return this.matchingIdChangeSet;
    }

    public ChangeSet getMatchingChangeSet() {
        return this.changeSet;
    }

    public boolean isEmpty() {
        return this.id == null || this.author == null || this.filePath == null;
    }

    private String createNotFoundErrorMessage(DatabaseChangeLog object, String string, String string2, String string3) {
        Object object2 = object.getChangeSets();
        String string4 = "\nThe command 'rollbackOneChangeSet' failed because the changeset targeted by '" + string + "::" + string2 + "::" + string3 + "'\ncannot be located.  ";
        object2 = object2.iterator();
        while (object2.hasNext()) {
            ChangeSet changeSet = (ChangeSet)object2.next();
            if (!DatabaseChangeLog.normalizePath((String)changeSet.getFilePath()).equalsIgnoreCase(DatabaseChangeLog.normalizePath((String)string3))) {
                return string4 + "The path '" + changeSet.getFilePath() + "' does not resolve to the desired changelog. One solution may be to control the lookup path of\nyour changeLogFile by adding it's base directory to the --classpath flag  and removing any relative path information from the --changeLogFile flag.";
            }
            if (!changeSet.getAuthor().equalsIgnoreCase(string2)) {
                return string4 + "The changelog author '" + changeSet.getAuthor() + "' does not match the changeset author '" + string2 + "'";
            }
            if (!changeSet.getId().equalsIgnoreCase(string)) {
                return string4 + "The changelog ID '" + changeSet.getId() + "' does not match the changeset ID '" + string + "'";
            }
            if (object.isDbmsMatch(changeSet.getDbmsSet())) continue;
            object = object.getChangeLogParameters().getValue("database.typeName", object).toString();
            return string4 + "The changelog DBMS: '" + (String)object + "'  does not match the changeset DBMS '" + changeSet.getDbmsSet().toString() + "'";
        }
        return "";
    }

    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
        String string = changeSet.toString();
        if (this.id.equalsIgnoreCase(changeSet.getId()) && this.author.equalsIgnoreCase(changeSet.getAuthor()) && this.filePath.equals(changeSet.getFilePath())) {
            return new ChangeSetFilterResult(true, "Changeset to rollback is ".concat(String.valueOf(string)), this.getClass());
        }
        return new ChangeSetFilterResult(false, "Changeset " + string + " will not rollback", this.getClass());
    }
}

