/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.rules.api.ScopeEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;

public enum ChecksTableColumns {
    ID("ID", 40),
    CHECKNAME("Check Name", 30),
    SHORTNAME("Short Name", 64),
    SCOPE("Scope", Arrays.stream(ScopeEnum.values()).map(scopeEnum -> scopeEnum.toString().length()).max(Integer::compareTo).orElse(4) + 1),
    CHANGESET_TYPE("Type", 6),
    ENABLED("Enabled", 8),
    PRIORITY("Priority", 12),
    SEVERITY("Severity", 9),
    CUSTOMIZATION("Customization", 30),
    DESCRIPTION("Description", 30);

    public static final String DEFAULT_COLUMNS_ARG;
    public static final String EVERY_COLUMN_ARG;
    private final String name;
    private final int width;

    private ChecksTableColumns(String string2, int n3) {
        this.name = string2;
        this.width = n3;
    }

    public final int getWidth() {
        return this.width;
    }

    public final String getName() {
        return this.name;
    }

    public final String getNameArgumentCase() {
        return ChecksTableColumns.toArgumentCase(this.name);
    }

    public final String toString() {
        return this.getNameArgumentCase();
    }

    public static List<String> getColumnNamesList(Collection<ChecksTableColumns> collection) {
        return collection.stream().map(ChecksTableColumns::getName).collect(Collectors.toList());
    }

    public static List<Integer> getColumnWidthsList(Collection<ChecksTableColumns> collection) {
        return collection.stream().map(ChecksTableColumns::getWidth).collect(Collectors.toList());
    }

    private static String toArgumentCase(String string) {
        return StringUtil.toLowerWithoutWhitespaces((String)string);
    }

    static {
        DEFAULT_COLUMNS_ARG = ChecksTableColumns.toArgumentCase(String.format("%s,%s,%s,%s,%s,%s", new Object[]{SHORTNAME, SCOPE, ENABLED, SEVERITY, CUSTOMIZATION, DESCRIPTION}));
        EVERY_COLUMN_ARG = ChecksTableColumns.toArgumentCase(String.format("%s,%s,%s,%s,%s", new Object[]{ID, CHECKNAME, CHANGESET_TYPE, PRIORITY, DEFAULT_COLUMNS_ARG}));
    }
}

