/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.InvalidExampleException;
import liquibase.sql.Sql;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.structure.DatabaseObject;

public abstract class AbstractLiquibaseDynamicRule
extends AbstractLiquibaseRule {
    private Map<String, String> generatedSqlCache = new HashMap<String, String>();

    @Override
    public final boolean evaluate(Facts facts) {
        Database database;
        Object object = this.getChangeSetFromFacts(facts);
        LazyDatabaseSnapshot lazyDatabaseSnapshot = this.getSnapshotFromFacts(facts);
        Database database2 = this.getDatabaseFromFacts(facts);
        if (object == null && lazyDatabaseSnapshot == null) {
            return this.putResultSuccessful((ChangeSet)null, false, null);
        }
        DynamicRule dynamicRule = (DynamicRule)this.getAbstractConfigurableRuleFromFacts(facts);
        if (!this.validateParameters(dynamicRule)) {
            return this.putResultUnsuccessful((ChangeSet)null, "Validation failed on the parameters for this rule.", dynamicRule);
        }
        boolean bl2 = false;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                database = (ChangeSet)object.next();
                if (!this.shouldBeEvaluated((ChangeSet)database)) continue;
                boolean bl3 = this.internalEvaluate((ChangeSet)database, database2, dynamicRule);
                if (!bl2) {
                    bl2 = bl3;
                }
                if (!Boolean.TRUE.equals(this.getShouldCheckRollbackFromFacts(facts))) continue;
                Database database3 = database;
                this.internalRollbackEvaluate((ChangeSet)database3, database3.getRollback().getChanges(), database2, dynamicRule);
            }
        }
        if (lazyDatabaseSnapshot != null) {
            try {
                object = lazyDatabaseSnapshot.createDiffResult();
                database = lazyDatabaseSnapshot.getDatabase();
                for (DatabaseObject databaseObject : object.getMissingObjects()) {
                    if (database.isLiquibaseObject(databaseObject) || !this.shouldBeEvaluated(databaseObject)) continue;
                    boolean bl4 = this.internalEvaluate(databaseObject, dynamicRule);
                    if (bl2) continue;
                    bl2 = bl4;
                }
            }
            catch (CommandExecutionException | DatabaseException | InvalidExampleException throwable) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to generate diff from database snapshot, and thus failed to run the database checks.", throwable);
                this.putResultUnsuccessful((DatabaseObject)null, "Failed to generate diff from database snapshot", dynamicRule);
            }
        }
        return bl2;
    }

    public String generateSqlFromChange(Change sqlStatementArray, Database database) {
        String string = this.generateKey((Change)sqlStatementArray);
        if (this.generatedSqlCache.containsKey(string)) {
            return this.generatedSqlCache.get(string);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (SqlStatement sqlStatement : sqlStatementArray.generateStatements(database)) {
            for (Sql sql : SqlGeneratorFactory.getInstance().generateSql(sqlStatement, database)) {
                stringBuilder.append(sql.toSql());
                stringBuilder.append("\n");
            }
        }
        this.generatedSqlCache.put(string, stringBuilder.toString());
        return stringBuilder.toString();
    }

    private String generateKey(Change change) {
        return change.generateCheckSum().toString();
    }

    private boolean validateParameters(DynamicRule object) {
        List<DynamicRuleParameter> list = ((DynamicRule)object).getParameters();
        if (list == null || list.isEmpty()) {
            object = String.format("Rule instance %s has no value parameters.  No check performed", ((DynamicRule)object).getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning((String)object);
            return false;
        }
        if ((long)list.size() < this.getParameters().stream().filter(ruleParameter -> ruleParameter.getShouldPrompt() == null).count()) {
            object = String.format("Rule instance %s has some missing value parameters.  No check performed.%nRun checks customize to supply values for the missing parameters.", ((DynamicRule)object).getName());
            Scope.getCurrentScope().getLog(this.getClass()).warning((String)object);
            return false;
        }
        return true;
    }

    public abstract boolean internalEvaluate(ChangeSet var1, DynamicRule var2);

    public abstract boolean internalEvaluate(DatabaseObject var1, DynamicRule var2);

    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        return this.internalEvaluate(changeSet, dynamicRule);
    }

    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> list, Database database, DynamicRule dynamicRule) {
        return false;
    }
}

