/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function;

import com.datical.liquibase.ext.storedlogic.AbstractMissingStoredLogicChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionChange;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.structure.DatabaseObject;

public class MissingFunctionChangeGenerator
extends AbstractMissingStoredLogicChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (Function.class.isAssignableFrom(clazz)) {
            return 101;
        }
        return -1;
    }

    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl diffOutputControl, Database database, Database object, ChangeGeneratorChain changeGeneratorChain) {
        object = new CreateFunctionChange();
        if (diffOutputControl.getIncludeCatalog()) {
            object.setCatalogName(databaseObject.getSchema().getCatalogName());
        }
        if (diffOutputControl.getIncludeSchema()) {
            object.setSchemaName(databaseObject.getSchema().getName());
        }
        ((CreateFunctionChange)((Object)object)).setFunctionName(Function.getFunctionName(databaseObject));
        ((CreateFunctionChange)((Object)object)).setFunctionBody(((Function)databaseObject).getBody());
        if (database instanceof MSSQLDatabase && !((CreateFunctionChange)((Object)object)).getFunctionBody().toUpperCase().contains("AS EXTERNAL NAME")) {
            object.setReplaceIfExists(Boolean.TRUE);
        }
        return MissingFunctionChangeGenerator.wrapWithQuotedIdentifier(databaseObject, database, new Change[]{object});
    }
}

