/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.DisableTriggerStatement;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DisableTriggerGenerator
extends AbstractSqlGenerator<DisableTriggerStatement> {
    public boolean supports(DisableTriggerStatement disableTriggerStatement, Database database) {
        return database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase);
    }

    public ValidationErrors validate(DisableTriggerStatement disableTriggerStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        sqlGeneratorChain = new ValidationErrors();
        sqlGeneratorChain.checkDisallowedField("catalogName", (Object)disableTriggerStatement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        sqlGeneratorChain.checkRequiredField("triggerName", (Object)disableTriggerStatement.getTriggerName());
        if (database instanceof MSSQLDatabase) {
            if (disableTriggerStatement.getScope() != null && !disableTriggerStatement.getScope().equalsIgnoreCase("CATALOG") && !disableTriggerStatement.getScope().equalsIgnoreCase("TABLE")) {
                sqlGeneratorChain.addError("Invalid disableTrigger scope: " + disableTriggerStatement.getScope());
                if (disableTriggerStatement.getTableName() != null && disableTriggerStatement.getScope().equalsIgnoreCase("CATALOG")) {
                    sqlGeneratorChain.addError("Cannot specify tableName and scope != TABLE");
                }
            }
            if ((disableTriggerStatement.getScope() == null || disableTriggerStatement.getScope().equals("TABLE")) && disableTriggerStatement.getTableName() == null) {
                sqlGeneratorChain.addError("tableName is required if scope is TABLE or not set");
            }
        }
        if (database instanceof PostgresDatabase) {
            sqlGeneratorChain.checkRequiredField("tableName", (Object)disableTriggerStatement.getTriggerName());
        }
        return sqlGeneratorChain;
    }

    public Sql[] generateSql(DisableTriggerStatement disableTriggerStatement, Database database, SqlGeneratorChain object) {
        object = new StringBuilder();
        if (database instanceof OracleDatabase) {
            ((StringBuilder)object).append("ALTER TRIGGER ");
            if (disableTriggerStatement.getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            ((StringBuilder)object).append(database.escapeObjectName(null, disableTriggerStatement.getSchemaName(), disableTriggerStatement.getTriggerName(), Trigger.class)).append(" ");
            ((StringBuilder)object).append("DISABLE");
        } else if (database instanceof MSSQLDatabase) {
            boolean bl2 = "CATALOG".equalsIgnoreCase(disableTriggerStatement.getScope());
            ((StringBuilder)object).append("DISABLE TRIGGER ");
            if (disableTriggerStatement.getTriggerName() == null) {
                throw new IllegalStateException("Sorry but triggerName must be set");
            }
            if (bl2) {
                ((StringBuilder)object).append(database.escapeObjectName(disableTriggerStatement.getTriggerName(), Trigger.class));
            } else {
                ((StringBuilder)object).append(database.escapeObjectName(null, disableTriggerStatement.getSchemaName(), disableTriggerStatement.getTriggerName(), Trigger.class));
            }
            ((StringBuilder)object).append(" ");
            ((StringBuilder)object).append(" ON ");
            if (disableTriggerStatement.getScope() != null && bl2) {
                ((StringBuilder)object).append("DATABASE");
            } else {
                ((StringBuilder)object).append(database.escapeTableName(disableTriggerStatement.getCatalogName(), disableTriggerStatement.getSchemaName(), disableTriggerStatement.getTableName()));
            }
        } else if (database instanceof PostgresDatabase) {
            ((StringBuilder)object).append("ALTER TABLE ");
            ((StringBuilder)object).append(database.escapeObjectName(null, disableTriggerStatement.getSchemaName(), disableTriggerStatement.getTableName(), Trigger.class)).append(" ");
            ((StringBuilder)object).append(" DISABLE TRIGGER ");
            ((StringBuilder)object).append(disableTriggerStatement.getTriggerName());
        } else {
            throw new UnexpectedLiquibaseException("Unsupported database type " + database.getShortName());
        }
        UnparsedSql unparsedSql = new UnparsedSql(((StringBuilder)object).toString(), new DatabaseObject[0]);
        return new Sql[]{unparsedSql};
    }
}

