/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.postgres;

import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.TriggerSnapshotGenerator;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.Schema;

public class PostgresTriggerSnapshotGenerator
extends TriggerSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        return -1;
    }

    @Override
    public String getAddToSql(Schema object, Database database) {
        if ((object = ((PostgresDatabase)database).getJdbcSchemaName(object.toCatalogAndSchema())) == null) {
            object = database.getDefaultSchemaName();
        }
        return String.format("select trg.tgname as OBJECT_NAME FROM pg_trigger trg\n JOIN pg_class tbl on trg.tgrelid = tbl.oid\n JOIN pg_namespace ns on ns.oid = tbl.relnamespace  \n  and trg.tgisinternal=false and ns.nspname = '%s'\n", object);
    }

    @Override
    public String getSnapshotObjectSql(DatabaseObject object, Database database) {
        String string = "select trg.tgname as OBJECT_NAME,   case     when trg.tgenabled='O' then 'ENABLED'     else 'DISABLED'     end as TRIGGER_STATUS, 'VALID' as status,   pg_get_triggerdef(trg.oid) as OBJECT_BODY,  ns.nspname as SCHEMA_NAME, tbl.relname as TABLE_NAME   FROM pg_trigger trg    JOIN pg_class tbl on trg.tgrelid = tbl.oid    JOIN pg_namespace ns ON ns.oid = tbl.relnamespace  and trg.tgisinternal=false ";
        if (object instanceof Catalog) {
            return null;
        }
        if (object instanceof Schema) {
            if ((object = ((PostgresDatabase)database).getJdbcSchemaName(object.getSchema().toCatalogAndSchema())) == null) {
                object = database.getDefaultSchemaName();
            }
            return string + String.format(" where ns.nspname = '%s' ", object);
        }
        if (object instanceof Trigger) {
            string = string + String.format(" WHERE trg.tgname = '%s' and ns.nspname = '%s' ", database.correctObjectName(object.getName(), Trigger.class), object.getSchema().getName());
        }
        return string;
    }
}

