/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import liquibase.repackaged.net.sf.jsqlparser.expression.OracleHint;
import liquibase.repackaged.net.sf.jsqlparser.parser.ASTNodeAccessImpl;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Distinct;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Fetch;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.First;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.GroupByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.KSQLWindow;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Limit;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.MySqlSqlCacheFlags;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Offset;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OptimizeFor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.OrderByElement;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectBody;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Skip;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Top;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Wait;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithIsolation;

public class PlainSelect
extends ASTNodeAccessImpl
implements SelectBody {
    private Distinct distinct = null;
    private List<SelectItem> selectItems;
    private List<Table> intoTables;
    private FromItem fromItem;
    private List<Join> joins;
    private Expression where;
    private GroupByElement groupBy;
    private List<OrderByElement> orderByElements;
    private Expression having;
    private Limit limit;
    private Offset offset;
    private Fetch fetch;
    private OptimizeFor optimizeFor;
    private Skip skip;
    private boolean mySqlHintStraightJoin;
    private First first;
    private Top top;
    private OracleHierarchicalExpression oracleHierarchical = null;
    private OracleHint oracleHint = null;
    private boolean oracleSiblings = false;
    private boolean forUpdate = false;
    private Table forUpdateTable = null;
    private boolean useBrackets = false;
    private Wait wait;
    private boolean mySqlSqlCalcFoundRows = false;
    private MySqlSqlCacheFlags mySqlCacheFlag = null;
    private String forXmlPath;
    private KSQLWindow ksqlWindow = null;
    private boolean noWait = false;
    private boolean emitChanges = false;
    private WithIsolation withIsolation;

    public boolean isUseBrackets() {
        return this.useBrackets;
    }

    public void setUseBrackets(boolean bl2) {
        this.useBrackets = bl2;
    }

    public FromItem getFromItem() {
        return this.fromItem;
    }

    public List<Table> getIntoTables() {
        return this.intoTables;
    }

    public List<SelectItem> getSelectItems() {
        return this.selectItems;
    }

    public Expression getWhere() {
        return this.where;
    }

    public PlainSelect withFromItem(FromItem fromItem) {
        this.setFromItem(fromItem);
        return this;
    }

    public void setFromItem(FromItem fromItem) {
        this.fromItem = fromItem;
    }

    public void setIntoTables(List<Table> list) {
        this.intoTables = list;
    }

    public PlainSelect withSelectItems(List<SelectItem> list) {
        this.setSelectItems(list);
        return this;
    }

    public void setSelectItems(List<SelectItem> list) {
        this.selectItems = list;
    }

    public PlainSelect addSelectItems(SelectItem ... selectItemArray) {
        List list = Optional.ofNullable(this.getSelectItems()).orElseGet(ArrayList::new);
        Collections.addAll(list, selectItemArray);
        return this.withSelectItems(list);
    }

    public void setWhere(Expression expression) {
        this.where = expression;
    }

    public List<Join> getJoins() {
        return this.joins;
    }

    public PlainSelect addJoins(Join ... joinArray) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        Collections.addAll(list, joinArray);
        return this.withJoins(list);
    }

    public PlainSelect withJoins(List<Join> list) {
        this.setJoins(list);
        return this;
    }

    public void setJoins(List<Join> list) {
        this.joins = list;
    }

    @Override
    public void accept(SelectVisitor selectVisitor) {
        selectVisitor.visit(this);
    }

    public List<OrderByElement> getOrderByElements() {
        return this.orderByElements;
    }

    public void setOrderByElements(List<OrderByElement> list) {
        this.orderByElements = list;
    }

    public Limit getLimit() {
        return this.limit;
    }

    public void setLimit(Limit limit) {
        this.limit = limit;
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    public Fetch getFetch() {
        return this.fetch;
    }

    public void setFetch(Fetch fetch) {
        this.fetch = fetch;
    }

    public OptimizeFor getOptimizeFor() {
        return this.optimizeFor;
    }

    public void setOptimizeFor(OptimizeFor optimizeFor) {
        this.optimizeFor = optimizeFor;
    }

    public Top getTop() {
        return this.top;
    }

    public void setTop(Top top) {
        this.top = top;
    }

    public Skip getSkip() {
        return this.skip;
    }

    public void setSkip(Skip skip) {
        this.skip = skip;
    }

    public boolean getMySqlHintStraightJoin() {
        return this.mySqlHintStraightJoin;
    }

    public void setMySqlHintStraightJoin(boolean bl2) {
        this.mySqlHintStraightJoin = bl2;
    }

    public First getFirst() {
        return this.first;
    }

    public void setFirst(First first) {
        this.first = first;
    }

    public Distinct getDistinct() {
        return this.distinct;
    }

    public void setDistinct(Distinct distinct) {
        this.distinct = distinct;
    }

    public Expression getHaving() {
        return this.having;
    }

    public void setHaving(Expression expression) {
        this.having = expression;
    }

    public GroupByElement getGroupBy() {
        return this.groupBy;
    }

    public void setGroupByElement(GroupByElement groupByElement) {
        this.groupBy = groupByElement;
    }

    public PlainSelect addGroupByColumnReference(Expression expression) {
        this.groupBy = Optional.ofNullable(this.groupBy).orElseGet(GroupByElement::new);
        this.groupBy.addGroupByExpression(expression);
        return this;
    }

    public OracleHierarchicalExpression getOracleHierarchical() {
        return this.oracleHierarchical;
    }

    public void setOracleHierarchical(OracleHierarchicalExpression oracleHierarchicalExpression) {
        this.oracleHierarchical = oracleHierarchicalExpression;
    }

    public boolean isOracleSiblings() {
        return this.oracleSiblings;
    }

    public void setOracleSiblings(boolean bl2) {
        this.oracleSiblings = bl2;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public void setForUpdate(boolean bl2) {
        this.forUpdate = bl2;
    }

    public Table getForUpdateTable() {
        return this.forUpdateTable;
    }

    public void setForUpdateTable(Table table) {
        this.forUpdateTable = table;
    }

    public OracleHint getOracleHint() {
        return this.oracleHint;
    }

    public void setOracleHint(OracleHint oracleHint) {
        this.oracleHint = oracleHint;
    }

    public void setWait(Wait wait) {
        this.wait = wait;
    }

    public Wait getWait() {
        return this.wait;
    }

    public String getForXmlPath() {
        return this.forXmlPath;
    }

    public void setForXmlPath(String string) {
        this.forXmlPath = string;
    }

    public KSQLWindow getKsqlWindow() {
        return this.ksqlWindow;
    }

    public void setKsqlWindow(KSQLWindow kSQLWindow) {
        this.ksqlWindow = kSQLWindow;
    }

    public void setEmitChanges(boolean bl2) {
        this.emitChanges = bl2;
    }

    public boolean isEmitChanges() {
        return this.emitChanges;
    }

    public WithIsolation getWithIsolation() {
        return this.withIsolation;
    }

    public void setWithIsolation(WithIsolation withIsolation) {
        this.withIsolation = withIsolation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.useBrackets) {
            stringBuilder.append("(");
        }
        stringBuilder.append("SELECT ");
        if (this.mySqlHintStraightJoin) {
            stringBuilder.append("STRAIGHT_JOIN ");
        }
        if (this.oracleHint != null) {
            stringBuilder.append(this.oracleHint).append(" ");
        }
        if (this.skip != null) {
            stringBuilder.append(this.skip).append(" ");
        }
        if (this.first != null) {
            stringBuilder.append(this.first).append(" ");
        }
        if (this.distinct != null) {
            stringBuilder.append(this.distinct).append(" ");
        }
        if (this.top != null) {
            stringBuilder.append(this.top).append(" ");
        }
        if (this.mySqlCacheFlag != null) {
            stringBuilder.append(this.mySqlCacheFlag.name()).append(" ");
        }
        if (this.mySqlSqlCalcFoundRows) {
            stringBuilder.append("SQL_CALC_FOUND_ROWS ");
        }
        stringBuilder.append(PlainSelect.getStringList(this.selectItems));
        if (this.intoTables != null) {
            stringBuilder.append(" INTO ");
            Iterator<ASTNodeAccessImpl> iterator = this.intoTables.iterator();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next().toString());
                if (!iterator.hasNext()) continue;
                stringBuilder.append(", ");
            }
        }
        if (this.fromItem != null) {
            stringBuilder.append(" FROM ").append(this.fromItem);
            if (this.joins != null) {
                for (Join join : this.joins) {
                    if (join.isSimple()) {
                        stringBuilder.append(", ").append(join);
                        continue;
                    }
                    stringBuilder.append(" ").append(join);
                }
            }
            if (this.ksqlWindow != null) {
                stringBuilder.append(" WINDOW ").append(this.ksqlWindow.toString());
            }
            if (this.where != null) {
                stringBuilder.append(" WHERE ").append(this.where);
            }
            if (this.oracleHierarchical != null) {
                stringBuilder.append(this.oracleHierarchical.toString());
            }
            if (this.groupBy != null) {
                stringBuilder.append(" ").append(this.groupBy.toString());
            }
            if (this.having != null) {
                stringBuilder.append(" HAVING ").append(this.having);
            }
            stringBuilder.append(PlainSelect.orderByToString(this.oracleSiblings, this.orderByElements));
            if (this.emitChanges) {
                stringBuilder.append(" EMIT CHANGES");
            }
            if (this.limit != null) {
                stringBuilder.append(this.limit);
            }
            if (this.offset != null) {
                stringBuilder.append(this.offset);
            }
            if (this.fetch != null) {
                stringBuilder.append(this.fetch);
            }
            if (this.withIsolation != null) {
                stringBuilder.append(this.withIsolation);
            }
            if (this.isForUpdate()) {
                stringBuilder.append(" FOR UPDATE");
                if (this.forUpdateTable != null) {
                    stringBuilder.append(" OF ").append(this.forUpdateTable);
                }
                if (this.wait != null) {
                    stringBuilder.append(this.wait);
                }
                if (this.isNoWait()) {
                    stringBuilder.append(" NOWAIT");
                }
            }
            if (this.optimizeFor != null) {
                stringBuilder.append(this.optimizeFor);
            }
        } else {
            if (this.where != null) {
                stringBuilder.append(" WHERE ").append(this.where);
            }
            if (this.limit != null) {
                stringBuilder.append(this.limit);
            }
            if (this.offset != null) {
                stringBuilder.append(this.offset);
            }
            if (this.fetch != null) {
                stringBuilder.append(this.fetch);
            }
            if (this.withIsolation != null) {
                stringBuilder.append(this.withIsolation);
            }
        }
        if (this.forXmlPath != null) {
            stringBuilder.append(" FOR XML PATH(").append(this.forXmlPath).append(")");
        }
        if (this.useBrackets) {
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public static String orderByToString(List<OrderByElement> list) {
        return PlainSelect.orderByToString(false, list);
    }

    public static String orderByToString(boolean bl2, List<OrderByElement> list) {
        return PlainSelect.getFormatedList(list, bl2 ? "ORDER SIBLINGS BY" : "ORDER BY");
    }

    public static String getFormatedList(List<?> list, String string) {
        return PlainSelect.getFormatedList(list, string, true, false);
    }

    public static String getFormatedList(List<?> object, String string, boolean bl2, boolean bl3) {
        if (((String)(object = PlainSelect.getStringList(object, bl2, bl3))).length() > 0) {
            object = string.length() > 0 ? " " + string + " " + (String)object : " ".concat(String.valueOf(object));
        }
        return object;
    }

    public static String getStringList(List<?> list) {
        return PlainSelect.getStringList(list, true, false);
    }

    public static String getStringList(List<?> list, boolean bl2, boolean bl3) {
        return PlainSelect.appendStringListTo(new StringBuilder(), list, bl2, bl3).toString();
    }

    public static StringBuilder appendStringListTo(StringBuilder stringBuilder, List<?> list, boolean bl2, boolean bl3) {
        if (list != null) {
            String string;
            String string2 = string = bl2 ? "," : "";
            if (bl3) {
                stringBuilder.append("(");
            }
            int n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                stringBuilder.append(list.get(i2)).append(i2 < n2 - 1 ? string + " " : "");
            }
            if (bl3) {
                stringBuilder.append(")");
            }
        }
        return stringBuilder;
    }

    public PlainSelect withMySqlSqlCalcFoundRows(boolean bl2) {
        this.setMySqlSqlCalcFoundRows(bl2);
        return this;
    }

    public PlainSelect withMySqlSqlNoCache(MySqlSqlCacheFlags mySqlSqlCacheFlags) {
        this.setMySqlSqlCacheFlag(mySqlSqlCacheFlags);
        return this;
    }

    public void setMySqlSqlCalcFoundRows(boolean bl2) {
        this.mySqlSqlCalcFoundRows = bl2;
    }

    public void setMySqlSqlCacheFlag(MySqlSqlCacheFlags mySqlSqlCacheFlags) {
        this.mySqlCacheFlag = mySqlSqlCacheFlags;
    }

    public boolean getMySqlSqlCalcFoundRows() {
        return this.mySqlSqlCalcFoundRows;
    }

    public MySqlSqlCacheFlags getMySqlSqlCacheFlag() {
        return this.mySqlCacheFlag;
    }

    public void setNoWait(boolean bl2) {
        this.noWait = bl2;
    }

    public boolean isNoWait() {
        return this.noWait;
    }

    public PlainSelect withDistinct(Distinct distinct) {
        this.setDistinct(distinct);
        return this;
    }

    public PlainSelect withIntoTables(List<Table> list) {
        this.setIntoTables(list);
        return this;
    }

    public PlainSelect withWhere(Expression expression) {
        this.setWhere(expression);
        return this;
    }

    public PlainSelect withOrderByElements(List<OrderByElement> list) {
        this.setOrderByElements(list);
        return this;
    }

    public PlainSelect withLimit(Limit limit) {
        this.setLimit(limit);
        return this;
    }

    public PlainSelect withOffset(Offset offset) {
        this.setOffset(offset);
        return this;
    }

    public PlainSelect withFetch(Fetch fetch) {
        this.setFetch(fetch);
        return this;
    }

    public PlainSelect withOptimizeFor(OptimizeFor optimizeFor) {
        this.setOptimizeFor(optimizeFor);
        return this;
    }

    public PlainSelect withSkip(Skip skip) {
        this.setSkip(skip);
        return this;
    }

    public PlainSelect withMySqlHintStraightJoin(boolean bl2) {
        this.setMySqlHintStraightJoin(bl2);
        return this;
    }

    public PlainSelect withFirst(First first) {
        this.setFirst(first);
        return this;
    }

    public PlainSelect withTop(Top top) {
        this.setTop(top);
        return this;
    }

    public PlainSelect withOracleHierarchical(OracleHierarchicalExpression oracleHierarchicalExpression) {
        this.setOracleHierarchical(oracleHierarchicalExpression);
        return this;
    }

    public PlainSelect withOracleHint(OracleHint oracleHint) {
        this.setOracleHint(oracleHint);
        return this;
    }

    public PlainSelect withOracleSiblings(boolean bl2) {
        this.setOracleSiblings(bl2);
        return this;
    }

    public PlainSelect withForUpdate(boolean bl2) {
        this.setForUpdate(bl2);
        return this;
    }

    public PlainSelect withForUpdateTable(Table table) {
        this.setForUpdateTable(table);
        return this;
    }

    public PlainSelect withUseBrackets(boolean bl2) {
        this.setUseBrackets(bl2);
        return this;
    }

    public PlainSelect withForXmlPath(String string) {
        this.setForXmlPath(string);
        return this;
    }

    public PlainSelect withKsqlWindow(KSQLWindow kSQLWindow) {
        this.setKsqlWindow(kSQLWindow);
        return this;
    }

    public PlainSelect withNoWait(boolean bl2) {
        this.setNoWait(bl2);
        return this;
    }

    public PlainSelect withHaving(Expression expression) {
        this.setHaving(expression);
        return this;
    }

    public PlainSelect withWait(Wait wait) {
        this.setWait(wait);
        return this;
    }

    public PlainSelect addSelectItems(Collection<? extends SelectItem> collection) {
        List list = Optional.ofNullable(this.getSelectItems()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withSelectItems(list);
    }

    public PlainSelect addIntoTables(Table ... tableArray) {
        List list = Optional.ofNullable(this.getIntoTables()).orElseGet(ArrayList::new);
        Collections.addAll(list, tableArray);
        return this.withIntoTables(list);
    }

    public PlainSelect addIntoTables(Collection<? extends Table> collection) {
        List list = Optional.ofNullable(this.getIntoTables()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withIntoTables(list);
    }

    public PlainSelect addJoins(Collection<? extends Join> collection) {
        List list = Optional.ofNullable(this.getJoins()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withJoins(list);
    }

    public PlainSelect addOrderByElements(OrderByElement ... orderByElementArray) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        Collections.addAll(list, orderByElementArray);
        return this.withOrderByElements(list);
    }

    public PlainSelect addOrderByElements(Collection<? extends OrderByElement> collection) {
        List list = Optional.ofNullable(this.getOrderByElements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withOrderByElements(list);
    }

    public <E extends FromItem> E getFromItem(Class<E> clazz) {
        return (E)((FromItem)clazz.cast(this.getFromItem()));
    }

    public <E extends Expression> E getWhere(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getWhere()));
    }

    public <E extends Expression> E getHaving(Class<E> clazz) {
        return (E)((Expression)clazz.cast(this.getHaving()));
    }
}

