/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.command.helpers.ChecksAutoUpdateArgument;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.CommandExecutionException;

public class ChecksDeleteCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "delete"};
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;

    public List<Class<?>> requiredDependencies() {
        return Collections.singletonList(ChecksAutoUpdateArgument.class);
    }

    public final void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        String checksSettingsFile = (String)commandScope.getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksDeleteCommandStep.checkFileArgExistence(checksSettingsFile, "checks settings");
        String autoUpdate = (String)commandScope.getDependency(ChecksAutoUpdateArgument.class);
        CheckSettingsConfigHelper helper = new CheckSettingsConfigHelper(checksSettingsFile, autoUpdate);
        CheckSettingsConfig csc = helper.read(ChecksDeleteCommandStep.listAllRules());
        this.throwExceptionIfPackageFile(csc);
        if (csc == null) {
            resultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        String checkName = (String)commandScope.getConfiguredValue(CHECK_NAME_ARG).getValue();
        String DEFAULT_CHECK_DELETE_EXCEPTION_MESSAGE = "cannot be deleted because it is a default check. Copies of default checks can be deleted.\nIf you don't want this check to run, try running 'liquibase checks disable '" + checkName + "' instead.";
        Scope.getCurrentScope().getUI().sendMessage("Deleting check with short name " + checkName);
        DynamicRule configuredRule = csc.getDynamicConfigurableRuleByShortName(checkName, DEFAULT_CHECK_DELETE_EXCEPTION_MESSAGE);
        if (configuredRule == null) {
            throw new CommandExecutionException("Check '" + checkName + "' does not exist." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks.");
        }
        if (!configuredRule.isCopy()) {
            throw new CommandExecutionException("Check '" + checkName + "' " + DEFAULT_CHECK_DELETE_EXCEPTION_MESSAGE);
        }
        if (configuredRule.getParameters().isEmpty()) {
            throw new CommandExecutionException("Check '" + checkName + "' does not have customization options." + System.lineSeparator() + "Run 'liquibase checks show' to see a list of all available checks and customization options for checks.");
        }
        Scope.getCurrentScope().getUI().sendMessage("Current Customization Settings");
        Scope.getCurrentScope().getUI().sendMessage("Severity = " + (Object)((Object)configuredRule.getSeverity()));
        for (DynamicRuleParameter dynamicRuleParameter : configuredRule.getParameters()) {
            DynamicRuleParameterEnum dynamicRuleParameterEnum = dynamicRuleParameter.getParameterAsEnum();
            String parameterName = dynamicRuleParameterEnum.name();
            Object parameterValue = dynamicRuleParameter.getValue();
            Scope.getCurrentScope().getUI().sendMessage("Parameter name = " + parameterName);
            Scope.getCurrentScope().getUI().sendMessage("Parameter value = " + (parameterValue == null ? "" : parameterValue.toString()));
        }
        String shouldDeleteCheck = (String)Scope.getCurrentScope().getUI().prompt(System.lineSeparator() + "Are you sure you want to delete " + checkName + " ? (Y/N)", (Object)"N", (input, type) -> {
            if (input == null || !input.equalsIgnoreCase("y") && !input.equalsIgnoreCase("n")) {
                throw new IllegalArgumentException();
            }
            return input;
        }, String.class);
        if (shouldDeleteCheck != null && shouldDeleteCheck.equalsIgnoreCase("n")) {
            Scope.getCurrentScope().getUI().sendMessage("No changes have been made to check configuration.");
            resultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        csc.getRules().remove(configuredRule);
        helper.write(csc);
        Scope.getCurrentScope().getUI().sendMessage("Check " + checkName + " deleted");
        Scope.getCurrentScope().getUI().sendMessage("Review the table below to confirm your changes.");
        ChecksShowCommandStep.writeTableToOutput(resultsBuilder, csc, false);
        csc.outputWarningMessage();
        resultsBuilder.addResult("statusCode", (Object)0);
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Delete a check from the list of checks in this configuration");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    static {
        CommandBuilder builder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHECK_NAME_ARG = builder.argument("checkName", String.class).required().description("Name of check to delete").build();
        CHECKS_SETTINGS_FILE_ARG = builder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
    }
}

