/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.api;

import com.datical.liquibase.ext.command.checks.ChecksOutput;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;

public enum SeverityEnum {
    BLOCKER(Integer.MAX_VALUE, 4),
    CRITICAL(300, 3),
    MAJOR(200, 2),
    MINOR(100, 1),
    INFO(Integer.MIN_VALUE, 0);

    private final int value;
    private final int exitValue;

    private SeverityEnum(int value, int exitValue) {
        this.value = value;
        this.exitValue = exitValue;
    }

    public int getValue() {
        return this.value;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public static SeverityEnum fromYamlFile(Object val) {
        String stringVal = String.valueOf(val);
        try {
            return SeverityEnum.valueOf(stringVal);
        }
        catch (IllegalArgumentException e) {
            Optional<SeverityEnum> severityEnumOpt = Arrays.stream(SeverityEnum.values()).filter(se -> String.valueOf(se.getValue()).equals(stringVal) || String.valueOf(se.getExitValue()).equals(stringVal)).findFirst();
            if (severityEnumOpt.isPresent()) {
                return severityEnumOpt.get();
            }
            throw new IllegalArgumentException("Cannot convert severity value of '" + val + "'.");
        }
    }

    public boolean shouldOutputToChecksRunConsole(LinkedHashSet<ChecksOutput> checksOutputs) {
        if (checksOutputs.contains((Object)ChecksOutput.all) || checksOutputs.contains((Object)ChecksOutput.issues)) {
            return true;
        }
        if (checksOutputs.stream().anyMatch(ChecksOutput.SEVERITY_RELATED_KEYS::contains)) {
            return checksOutputs.contains((Object)ChecksOutput.valueOf("issues" + this.exitValue));
        }
        return false;
    }

    public static SeverityEnum fromExitValue(int exitValue) {
        Optional<SeverityEnum> optSeverity = Arrays.stream(SeverityEnum.values()).filter(se -> se.getExitValue() == exitValue).findFirst();
        return optSeverity.orElse(null);
    }
}

