/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.storedlogic.function.Function;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionStatement;
import java.util.ArrayList;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.parser.LiquibaseSqlParser;
import liquibase.parser.SqlParserFactory;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.sqlgenerator.core.CreateProcedureGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringClauses;

public class CreateFunctionGenerator
extends AbstractSqlGenerator<CreateFunctionStatement> {
    public int getPriority() {
        return 6;
    }

    public ValidationErrors validate(CreateFunctionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("functionName", (Object)statement.getFunctionName());
        validationErrors.checkRequiredField("functionBody", (Object)statement.getFunctionBody());
        validationErrors.checkDisallowedField("catalogName", (Object)statement.getCatalogName(), database, new Class[]{MSSQLDatabase.class});
        return validationErrors;
    }

    public Sql[] generateSql(CreateFunctionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        String endDelimiter = ";";
        if (database instanceof OracleDatabase) {
            endDelimiter = "\n/";
        } else if (database instanceof AbstractDb2Database) {
            endDelimiter = "";
        }
        String schemaName = statement.getSchemaName();
        if (schemaName == null && database instanceof PostgresDatabase) {
            schemaName = database.getDefaultSchemaName();
        }
        String body = CreateProcedureGenerator.addSchemaToText((String)CreateProcedureGenerator.removeTrailingDelimiter((String)statement.getFunctionBody(), (String)endDelimiter), (String)schemaName, (String)"FUNCTION", (Database)database);
        ArrayList<UnparsedSql> sql = new ArrayList<UnparsedSql>();
        if (statement.getReplaceIfExists() != null && statement.getReplaceIfExists().booleanValue()) {
            if (database instanceof MSSQLDatabase) {
                String fullyQualifiedName = statement.getFunctionName();
                fullyQualifiedName = statement.getSchemaName() == null ? "dbo." + fullyQualifiedName : statement.getSchemaName() + "." + fullyQualifiedName;
                SqlParserFactory sqlParserFactory = (SqlParserFactory)Scope.getCurrentScope().getSingleton(SqlParserFactory.class);
                LiquibaseSqlParser sqlParser = sqlParserFactory.getSqlParser();
                StringClauses createVersionSql = sqlParser.parse(body, true, true);
                StringClauses alterVersionSql = sqlParser.parse(body, true, true);
                StringClauses.ClauseIterator createClauseIterator = createVersionSql.getClauseIterator();
                StringClauses.ClauseIterator alterClauseIterator = alterVersionSql.getClauseIterator();
                Object next = "START";
                while (next != null && !next.toString().equalsIgnoreCase("create") && !next.toString().equalsIgnoreCase("alter") && createClauseIterator.hasNext()) {
                    next = createClauseIterator.nextNonWhitespace();
                    alterClauseIterator.nextNonWhitespace();
                }
                createClauseIterator.replace((Object)"CREATE");
                alterClauseIterator.replace((Object)"ALTER");
                body = "if object_id('" + fullyQualifiedName + "') is null exec ('" + createVersionSql.toString().replace("'", "''") + "') else exec ('" + alterVersionSql.toString().replace("'", "''") + "')";
            } else {
                String fullyQualifiedName = database.escapeObjectName(statement.getFunctionName(), Function.class);
                sql.add(new UnparsedSql("DROP FUNCTION IF EXISTS " + fullyQualifiedName, new DatabaseObject[0]));
            }
        }
        sql.add(new UnparsedSql(body, endDelimiter, new DatabaseObject[0]));
        CreateProcedureGenerator.surroundWithSchemaSets(sql, (String)statement.getSchemaName(), (Database)database);
        return sql.toArray(new Sql[sql.size()]);
    }
}

