/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.postgres;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.StringUtil;

public class PostgresFunctionSnapshotGenerator
extends AbstractStoredDatabaseLogicSnapshotGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        return -1;
    }

    public PostgresFunctionSnapshotGenerator() {
        super(Function.class, new Class[]{Schema.class});
    }

    @Override
    protected String getObjectType(Database database) {
        return "FUNCTION";
    }

    protected StoredDatabaseLogic<Function> createReturnObject() {
        return new Function();
    }

    @Override
    public String getAddToSql(Schema schema, Database database) {
        boolean hasProcKindAttr;
        try {
            hasProcKindAttr = database.getDatabaseMajorVersion() > 10;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return "select   pp.proname AS OBJECT_NAME,  pg_get_function_arguments(pp.oid) AS OBJECT_ARG,   CASE pg_ag.aggtranstype is null     WHEN true THEN pg_get_functiondef(pp.oid)    ELSE format(E'CREATE AGGREGATE %s.%s(%s) (\\n%s\\n);',      pn.nspname, pp.proname, pg_get_function_arguments(pp.oid),      array_to_string(        ARRAY[         format(E'\\tSFUNC = %s', aggtransfn::regproc)         , format(E'\\tSTYPE = %s', format_type(aggtranstype, NULL))         , CASE aggfinalfn WHEN '-'::regproc THEN NULL ELSE format(E'\\tFINALFUNC = %s',aggfinalfn::text) END         , CASE aggsortop WHEN 0 THEN NULL ELSE format(E'\\tSORTOP = %s', oprname) END         , CASE WHEN agginitval IS NULL THEN NULL ELSE format(E'\\tINITCOND = \\'%s\\'', agginitval) END          ]          , E',\\n'       )    )    END   AS OBJECT_BODY from pg_proc pp join pg_namespace pn on (pp.pronamespace = pn.oid) join pg_language pl on (pp.prolang = pl.oid) left join pg_aggregate pg_ag ON pg_ag.aggfnoid = pp.oid left join pg_operator pg_op ON pg_ag.aggsortop = pg_op.oid where   pn.nspname NOT LIKE 'pg_%'   and pn.nspname = '" + schema.getName() + "' " + (hasProcKindAttr ? " and pp.prokind in ('f', 'a') " : "");
    }

    @Override
    public String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database database) {
        Function function = (Function)storedDatabaseLogic;
        String all = this.getAddToSql(function.getSchema(), database);
        return String.format("%s and pp.proname = '%s' ", all, function.getName());
    }

    @Override
    public void addTo(DatabaseObject databaseObject, DatabaseSnapshot databaseSnapshot) throws DatabaseException {
        if (!(databaseObject instanceof Schema)) {
            return;
        }
        Schema schema = (Schema)databaseObject;
        Database database = databaseSnapshot.getDatabase();
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List<Map<String, ?>> queryForListResult = this.queryForList(databaseSnapshot, schema, executor);
        List<StoredDatabaseLogic> functions = this.toObjects(schema, queryForListResult);
        for (StoredDatabaseLogic function : functions) {
            schema.addDatabaseObject((DatabaseObject)function);
        }
    }

    @Override
    public StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogicExample) throws DatabaseException {
        if (StringUtil.isNotEmpty((String)storedDatabaseLogicExample.getBody())) {
            return storedDatabaseLogicExample;
        }
        String snapshotObjectSql = this.getSnapshotObjectSql(storedDatabaseLogicExample, database);
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", database);
        List queryForList = executor.queryForList((SqlStatement)new RawSqlStatement(snapshotObjectSql));
        List<Map<String, ?>> listOfMapsResultSet = this.castToListOfMaps(queryForList);
        List<StoredDatabaseLogic> functions = this.toObjects(storedDatabaseLogicExample.getSchema(), listOfMapsResultSet);
        if (functions.size() == 1) {
            return functions.get(0);
        }
        for (StoredDatabaseLogic function : functions) {
            if (!function.getName().equals(storedDatabaseLogicExample.getName())) continue;
            return function;
        }
        return null;
    }

    private List<StoredDatabaseLogic> toObjects(Schema schema, List<Map<String, ?>> rows) {
        ArrayList<StoredDatabaseLogic> objects = new ArrayList<StoredDatabaseLogic>();
        for (Map<String, ?> row : rows) {
            String objectName = (String)row.get("OBJECT_NAME");
            String body = (String)row.get("OBJECT_BODY");
            String args = (String)row.get("OBJECT_ARG");
            String id = String.format("%s(%s)", objectName, StringUtil.trimToEmpty((String)args));
            Function object = ((Function)((Function)((Function)((Function)this.createReturnObject().setSchema(schema)).setName(id)).setBody(body)).setValid(true)).setFunctionName(objectName);
            objects.add(object);
        }
        return objects;
    }
}

