/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.Merge;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeDelete;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeInsert;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeOperation;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeOperationVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.merge.MergeUpdate;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.SelectDeParser;

public class MergeDeParser
extends AbstractDeParser<Merge>
implements MergeOperationVisitor {
    private final ExpressionDeParser expressionDeParser;
    private final SelectDeParser selectDeParser;

    public MergeDeParser(ExpressionDeParser expressionDeParser, SelectDeParser selectDeParser, StringBuilder buffer) {
        super(buffer);
        this.expressionDeParser = expressionDeParser;
        this.selectDeParser = selectDeParser;
    }

    @Override
    void deParse(Merge merge) {
        List<WithItem> withItemsList = merge.getWithItemsList();
        if (withItemsList != null && !withItemsList.isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<WithItem> iter = withItemsList.iterator();
            while (iter.hasNext()) {
                iter.next().accept(this.expressionDeParser);
                if (iter.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("MERGE ");
        if (merge.getOracleHint() != null) {
            this.buffer.append(merge.getOracleHint()).append(" ");
        }
        this.buffer.append("INTO ");
        merge.getTable().accept(this.selectDeParser);
        this.buffer.append(" USING ");
        merge.getFromItem().accept(this.selectDeParser);
        this.buffer.append(" ON ");
        merge.getOnCondition().accept(this.expressionDeParser);
        List<MergeOperation> operations = merge.getOperations();
        if (operations != null && !operations.isEmpty()) {
            operations.forEach(operation -> operation.accept(this));
        }
        if (merge.getOutputClause() != null) {
            merge.getOutputClause().appendTo(this.buffer);
        }
    }

    @Override
    public void visit(MergeDelete mergeDelete) {
        this.buffer.append(" WHEN MATCHED");
        if (mergeDelete.getAndPredicate() != null) {
            this.buffer.append(" AND ");
            mergeDelete.getAndPredicate().accept(this.expressionDeParser);
        }
        this.buffer.append(" THEN DELETE");
    }

    @Override
    public void visit(MergeUpdate mergeUpdate) {
        this.buffer.append(" WHEN MATCHED");
        if (mergeUpdate.getAndPredicate() != null) {
            this.buffer.append(" AND ");
            mergeUpdate.getAndPredicate().accept(this.expressionDeParser);
        }
        this.buffer.append(" THEN UPDATE SET ");
        MergeDeParser.deparseUpdateSets(mergeUpdate.getUpdateSets(), this.buffer, this.expressionDeParser);
        if (mergeUpdate.getWhereCondition() != null) {
            this.buffer.append(" WHERE ");
            mergeUpdate.getWhereCondition().accept(this.expressionDeParser);
        }
        if (mergeUpdate.getDeleteWhereCondition() != null) {
            this.buffer.append(" DELETE WHERE ");
            mergeUpdate.getDeleteWhereCondition().accept(this.expressionDeParser);
        }
    }

    @Override
    public void visit(MergeInsert mergeInsert) {
        this.buffer.append(" WHEN NOT MATCHED");
        if (mergeInsert.getAndPredicate() != null) {
            this.buffer.append(" AND ");
            mergeInsert.getAndPredicate().accept(this.expressionDeParser);
        }
        this.buffer.append(" THEN INSERT ");
        if (mergeInsert.getColumns() != null) {
            mergeInsert.getColumns().accept(this.expressionDeParser);
        }
        this.buffer.append(" VALUES ");
        mergeInsert.getValues().accept(this.expressionDeParser);
        if (mergeInsert.getWhereCondition() != null) {
            this.buffer.append(" WHERE ");
            mergeInsert.getWhereCondition().accept(this.expressionDeParser);
        }
    }
}

