/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import java.util.ArrayList;
import java.util.List;
import liquibase.change.AbstractChange;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeWithColumns;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.DropIndexChange;
import liquibase.database.Database;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CreateIndexStatement;

@DatabaseChange(name="createIndex", description="Creates an index on an existing column or set of columns.", priority=1, appliesTo={"index"})
public class CreateIndexChange
extends AbstractChange
implements ChangeWithColumns<AddColumnConfig> {
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String indexName;
    private Boolean unique;
    private String tablespace;
    private List<AddColumnConfig> columns = new ArrayList<AddColumnConfig>();
    private String associatedWith;

    @DatabaseChangeProperty(mustEqualExisting="index", description="Name of the index to create")
    public String getIndexName() {
        return this.indexName;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    @DatabaseChangeProperty(mustEqualExisting="index.schema")
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @DatabaseChangeProperty(mustEqualExisting="index.table", description="Name of the table to add the index to", exampleValue="person")
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Override
    @DatabaseChangeProperty(mustEqualExisting="index.column", description="Column(s) to add to the index", requiredForDatabase={"all"})
    public List<AddColumnConfig> getColumns() {
        if (this.columns == null) {
            return new ArrayList<AddColumnConfig>();
        }
        return this.columns;
    }

    @Override
    public void setColumns(List<AddColumnConfig> columns) {
        this.columns = columns;
    }

    @Override
    public void addColumn(AddColumnConfig column) {
        this.columns.add(column);
    }

    @DatabaseChangeProperty(description="Tablepace to create the index in.")
    public String getTablespace() {
        return this.tablespace;
    }

    public void setTablespace(String tablespace) {
        this.tablespace = tablespace;
    }

    @Override
    public SqlStatement[] generateStatements(Database database) {
        ArrayList<String> columns = new ArrayList<String>();
        for (AddColumnConfig column : this.getColumns()) {
            columns.add(column.getName());
        }
        return new SqlStatement[]{new CreateIndexStatement(this.getIndexName(), this.getCatalogName(), this.getSchemaName(), this.getTableName(), this.isUnique(), this.getAssociatedWith(), columns.toArray(new String[this.getColumns().size()])).setTablespace(this.getTablespace())};
    }

    @Override
    protected Change[] createInverses() {
        DropIndexChange inverse = new DropIndexChange();
        inverse.setSchemaName(this.getSchemaName());
        inverse.setTableName(this.getTableName());
        inverse.setIndexName(this.getIndexName());
        return new Change[]{inverse};
    }

    @Override
    public String getConfirmationMessage() {
        return "Index " + this.getIndexName() + " created";
    }

    public void setUnique(Boolean isUnique) {
        this.unique = isUnique;
    }

    @DatabaseChangeProperty(description="Unique values index", since="1.8")
    public Boolean isUnique() {
        return this.unique;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getAssociatedWith() {
        return this.associatedWith;
    }

    public void setAssociatedWith(String associatedWith) {
        this.associatedWith = associatedWith;
    }

    @DatabaseChangeProperty(since="3.0")
    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    @Override
    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/dbchangelog";
    }
}

