/*
 * Decompiled with CFR 0.152.
 */
package liquibase.structure.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.util.StringUtils;

public class Schema
extends AbstractDatabaseObject {
    @Override
    public DatabaseObject[] getContainingObjects() {
        return null;
    }

    public Schema() {
        this.setAttribute("objects", new HashMap());
    }

    public Schema(String catalog, String schemaName) {
        catalog = StringUtils.trimToNull(catalog);
        schemaName = StringUtils.trimToNull(schemaName);
        this.setAttribute("name", schemaName);
        this.setAttribute("catalog", new Catalog(catalog));
        this.setAttribute("objects", new HashMap());
    }

    public Schema(Catalog catalog, String name) {
        this(catalog.getName(), name);
    }

    @Override
    public String getName() {
        return this.getAttribute("name", String.class);
    }

    public Schema setName(String name) {
        this.setAttribute("name", name);
        return this;
    }

    @Override
    public Schema getSchema() {
        return this;
    }

    public Catalog getCatalog() {
        return this.getAttribute("catalog", Catalog.class);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        if (this.getCatalog() != null ? !this.getCatalog().equals(schema.getCatalog()) : schema.getCatalog() != null) {
            return false;
        }
        return !(this.getName() != null ? !this.getName().equals(schema.getName()) : schema.getName() != null);
    }

    public int hashCode() {
        int result = this.getCatalog() != null ? this.getCatalog().hashCode() : 0;
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        return result;
    }

    public String getCatalogName() {
        if (this.getCatalog() == null) {
            return null;
        }
        return this.getCatalog().getName();
    }

    @Override
    public String toString() {
        String catalogName = this.getCatalogName();
        if (catalogName == null) {
            return this.getName();
        }
        return catalogName + "." + this.getName();
    }

    public CatalogAndSchema toCatalogAndSchema() {
        return new CatalogAndSchema(this.getCatalogName(), this.getName());
    }

    protected Map<Class<? extends DatabaseObject>, Set<DatabaseObject>> getObjects() {
        return this.getAttribute("objects", Map.class);
    }

    public <DatabaseObjectType extends DatabaseObject> List<DatabaseObjectType> getDatabaseObjects(Class<DatabaseObjectType> type) {
        Set<DatabaseObject> databaseObjects = this.getObjects().get(type);
        if (databaseObjects == null) {
            return new ArrayList();
        }
        return new ArrayList<DatabaseObject>(databaseObjects);
    }

    public void addDatabaseObject(DatabaseObject databaseObject) {
        if (databaseObject == null) {
            return;
        }
        Set<DatabaseObject> objects = this.getObjects().get(databaseObject.getClass());
        if (objects == null) {
            objects = new HashSet<DatabaseObject>();
            this.getObjects().put(databaseObject.getClass(), objects);
        }
        objects.add(databaseObject);
    }
}

