/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change;

import java.io.IOException;
import java.io.InputStream;
import java.text.Normalizer;
import liquibase.util.MD5Util;
import liquibase.util.StringUtils;

public final class CheckSum {
    public static final int CURRENT_CHECKSUM_ALGORITHM_VERSION = 8;
    private int version;
    private String storedCheckSum;

    private CheckSum(String checksum, int version) {
        this.storedCheckSum = checksum;
        this.version = version;
    }

    public static CheckSum parse(String checksumValue) {
        int CHECKSUM_OFFSET_IN_STRING = 2;
        if (checksumValue == null) {
            return null;
        }
        if (checksumValue.matches("^\\d:.*")) {
            return new CheckSum(checksumValue.substring(2), Integer.parseInt(checksumValue.substring(0, 1)));
        }
        return new CheckSum(checksumValue, 1);
    }

    public static int getCurrentVersion() {
        return 8;
    }

    public static CheckSum compute(String valueToChecksum) {
        return new CheckSum(MD5Util.computeMD5(Normalizer.normalize(StringUtils.standardizeLineEndings(valueToChecksum).replaceAll("\\uFFFD", ""), Normalizer.Form.NFC)), CheckSum.getCurrentVersion());
    }

    public static CheckSum compute(final InputStream stream, boolean standardizeLineEndings) {
        InputStream newStream = stream;
        if (standardizeLineEndings) {
            newStream = new InputStream(){

                @Override
                public int read() throws IOException {
                    int read = stream.read();
                    if (read == 13) {
                        return this.read();
                    }
                    return read;
                }
            };
        }
        return new CheckSum(MD5Util.computeMD5(newStream), CheckSum.getCurrentVersion());
    }

    public String toString() {
        return this.version + ":" + this.storedCheckSum;
    }

    public int getVersion() {
        return this.version;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof CheckSum && this.toString().equals(obj.toString());
    }
}

