/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksShowCommandStep;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;

public class ChecksBulksetCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "bulkSet"};
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<Boolean> CHECKS_DISABLE_ARG;
    public static final CommandArgumentDefinition<Boolean> CHECKS_ENABLE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SEVERITY_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;

    @Override
    public final void run(CommandResultsBuilder object) {
        Object object2 = ((CommandResultsBuilder)object).getCommandScope();
        boolean bl2 = ((CommandScope)object2).getConfiguredValue(FORCE_ARG).getProvidedValue().getValue() != null;
        boolean bl3 = ((CommandScope)object2).getConfiguredValue(CHECKS_ENABLE_ARG).getProvidedValue().getValue() != null;
        boolean bl4 = ((CommandScope)object2).getConfiguredValue(CHECKS_DISABLE_ARG).getProvidedValue().getValue() != null;
        Object object3 = ((CommandScope)object2).getConfiguredValue(CHECKS_SEVERITY_ARG).getValue();
        boolean[] blArray = new boolean[3];
        blArray[0] = bl3;
        blArray[1] = bl4;
        boolean bl5 = blArray[2] = object3 != null;
        if (this.moreThanOne(blArray)) {
            throw new IllegalArgumentException("Specify only one of enable, disable, and severity arguments");
        }
        String string2 = ((CommandScope)object2).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksBulksetCommandStep.checkFileArgExistence(string2, "checks settings", false);
        object2 = ((CommandScope)object2).getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
        object2 = new CheckSettingsConfigHelper(string2, (String)object2);
        Object object4 = ChecksBulksetCommandStep.listAllRules();
        object4 = ((CheckSettingsConfigHelper)object2).read((List<AbstractLiquibaseRule>)object4);
        if (object4 == null) {
            return;
        }
        SeverityEnum severityEnum = null;
        if (object3 != null && (severityEnum = this.determineSeverityEnum((String)object3)) == null) {
            throw new IllegalArgumentException("Invalid severity argument '" + object3 + ";");
        }
        if (!bl2) {
            String string3;
            if (bl3) {
                string3 = "IMPORTANT: Are you sure you want to enable all checks? (Y/N)";
            } else if (bl4) {
                string3 = "IMPORTANT: Are you sure you want to disable all checks? (Y/N)";
            } else {
                if (severityEnum == null) {
                    throw new IllegalArgumentException("Invalid severity argument '" + object3 + ";");
                }
                string3 = "IMPORTANT: Are you sure you want to set all the checks to severity <'" + object3 + "'> (" + severityEnum.getExitValue() + ")>? (Y/N):";
            }
            if (Scope.getCurrentScope().getUI().prompt(string3, "N", (string, clazz) -> {
                if (string == null || !string.equalsIgnoreCase("y") && !string.equalsIgnoreCase("n") && !string.equalsIgnoreCase("yes") && !string.equalsIgnoreCase("no")) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class).toLowerCase().charAt(0) == 'n') {
                object = "No checks configuration changes were made";
                Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object);
                Scope.getCurrentScope().getUI().sendMessage((String)object);
                return;
            }
        }
        Object object5 = new AtomicBoolean();
        object3 = severityEnum;
        ((CheckSettingsConfig)object4).getRules().forEach(arg_0 -> ChecksBulksetCommandStep.lambda$run$7((SeverityEnum)((Object)object3), (AtomicBoolean)object5, bl3, bl4, arg_0));
        if (!((AtomicBoolean)object5).get()) {
            object5 = "No checks were modified";
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object5);
            Scope.getCurrentScope().getUI().sendMessage((String)object5);
            return;
        }
        ((CheckSettingsConfigHelper)object2).write((CheckSettingsConfig)object4);
        if (bl3) {
            Scope.getCurrentScope().getUI().sendMessage("\n\nAll qualifying checks have been enabled\n");
        } else if (bl4) {
            Scope.getCurrentScope().getUI().sendMessage("\n\nAll qualifying checks have been disabled\n");
        } else if (severityEnum != null) {
            Scope.getCurrentScope().getUI().sendMessage("\n\nAll qualifying checks have been set to severity '" + severityEnum.name() + "'.\n");
        }
        ChecksShowCommandStep.writeTableToOutput((CommandResultsBuilder)object, string2, false);
        ((CheckSettingsConfig)object4).outputWarningMessage();
        ((CommandResultsBuilder)object).addResult("statusCode", (Object)0);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Set the properties of all qualifying checks with one command");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private SeverityEnum determineSeverityEnum(String string) {
        SeverityEnum severityEnum = ChecksBulksetCommandStep.convertToExitCode(string);
        if (severityEnum == null) {
            severityEnum = ChecksBulksetCommandStep.convertToSeverityEnum(string);
        }
        return severityEnum;
    }

    private static String createExitCodeOptionsString() {
        List<SeverityEnum> list = Arrays.asList(SeverityEnum.values());
        Collections.reverse(list);
        StringBuilder stringBuilder = new StringBuilder();
        list.forEach(severityEnum -> {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", '").append(severityEnum.getExitValue()).append("'");
                return;
            }
            stringBuilder.append("'").append(severityEnum.getExitValue()).append("'");
        });
        return stringBuilder.toString();
    }

    private static String createSeverityEnumOptionsString() {
        List<SeverityEnum> list = Arrays.asList(SeverityEnum.values());
        Collections.reverse(list);
        StringBuilder stringBuilder = new StringBuilder();
        list.forEach(severityEnum -> {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", '").append(severityEnum.name()).append("'");
                return;
            }
            stringBuilder.append("'").append(severityEnum.name()).append("'");
        });
        return stringBuilder.toString();
    }

    private static boolean isInteger(String string) {
        try {
            Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return true;
    }

    private static SeverityEnum convertToExitCode(String string) {
        int n2;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        List list = Arrays.stream(SeverityEnum.values()).filter(severityEnum -> n2 == severityEnum.getExitValue()).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (SeverityEnum)((Object)list.get(0));
    }

    private static SeverityEnum convertToSeverityEnum(String list) {
        list = Arrays.stream(SeverityEnum.values()).filter(arg_0 -> ChecksBulksetCommandStep.lambda$convertToSeverityEnum$11((String)((Object)list), arg_0)).collect(Collectors.toList());
        if (list.isEmpty()) {
            return null;
        }
        return (SeverityEnum)((Object)list.get(0));
    }

    private boolean moreThanOne(boolean ... blArray) {
        int n2 = 0;
        for (boolean bl2 : blArray) {
            n2 += bl2 ? 1 : 0;
        }
        return n2 > 1;
    }

    private static /* synthetic */ boolean lambda$convertToSeverityEnum$11(String string, SeverityEnum severityEnum) {
        return string.equalsIgnoreCase(severityEnum.name());
    }

    private static /* synthetic */ void lambda$run$7(SeverityEnum severityEnum, AtomicBoolean atomicBoolean, boolean bl2, boolean bl3, AbstractConfigurableRule abstractConfigurableRule) {
        if (severityEnum == null && abstractConfigurableRule instanceof DynamicRule && !((DynamicRule)abstractConfigurableRule).getParameters().stream().allMatch(dynamicRuleParameter -> dynamicRuleParameter.getValue() != null)) {
            return;
        }
        atomicBoolean.set(true);
        if (bl2) {
            abstractConfigurableRule.setEnabled(true);
            return;
        }
        if (bl3) {
            abstractConfigurableRule.setEnabled(false);
            return;
        }
        if (severityEnum != null) {
            abstractConfigurableRule.setSeverity(severityEnum);
        }
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_DISABLE_ARG = commandBuilder.argument("disable", Boolean.class).description("Disable all qualifying checks in the checks settings file").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("true")) {
                return Boolean.valueOf((String)object);
            }
            object = "\nWARNING:  The input '" + (String)object + "' is not valid.  Options: 'true'.";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_ENABLE_ARG = commandBuilder.argument("enable", Boolean.class).description("Enable all qualifying checks in the checks settings file").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("true")) {
                return Boolean.valueOf((String)object);
            }
            object = "\nWARNING:  The input '" + (String)object + "' is not valid.  Options: 'true'.";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_SEVERITY_ARG = commandBuilder.argument("severity", String.class).description("Set the severity of all checks to the value specified").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (ChecksBulksetCommandStep.convertToExitCode((String)(object = (String)object)) == null && ChecksBulksetCommandStep.convertToSeverityEnum((String)object) == null) {
                object = ChecksBulksetCommandStep.isInteger((String)object) ? "\nWARNING:  Severity value '" + (String)object + "' is not valid.  Options: " + ChecksBulksetCommandStep.createExitCodeOptionsString() : "\nWARNING:  Severity value '" + (String)object + "' is not valid.  Options: " + ChecksBulksetCommandStep.createSeverityEnumOptionsString();
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).description("Do not ask for confirmation when running this command").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("true")) {
                return Boolean.valueOf((String)object);
            }
            object = "\nWARNING:  The input '" + (String)object + "' is not valid. Options: 'true'.";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
    }
}

