/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.Constraint;
import com.datical.liquibase.ext.checks.config.ConstraintOperatorEnum;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RegexGetter;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringEnumListGetter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import liquibase.changelog.ChangeSet;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;
import liquibase.util.StringUtil;

public class ConstraintMustExist
extends AbstractLiquibaseDynamicForecastRule {
    public ConstraintMustExist() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.DATABASE);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    private List<Constraint> getConstraintParam(DynamicRule dynamicRule) {
        return StringEnumListGetter.split((String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.CONSTRAINT), Constraint.class, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        if (databaseObject instanceof Table) {
            Iterator iterator = databaseObject.getName();
            String string = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.TABLE_NAME);
            ConstraintOperatorEnum constraintOperatorEnum = dynamicRule.getEnumParameterValue(DynamicRuleParameterEnum.CONSTRAINT_OPERATOR, ConstraintOperatorEnum.class);
            String string2 = (String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.COLUMN_NAME);
            Boolean bl2 = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
            try {
                bl2 = this.getCaseSensitiveParam(dynamicRule, constraintOperatorEnum);
            }
            catch (Exception exception) {
                this.putResultUnsuccessful(databaseObject, "Rule is using a " + (Object)((Object)ConstraintOperatorEnum.REGEXP) + " operator, but also has a value for the " + (Object)((Object)DynamicRuleParameterEnum.CASE_SENSITIVE) + " param.", dynamicRule);
            }
            if (StringUtil.isEmpty(string) || constraintOperatorEnum.matches(string, (String)((Object)iterator), bl2)) {
                iterator = this.getConstraintParam(dynamicRule);
                boolean bl3 = true;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Constraint constraint = (Constraint)((Object)iterator.next());
                    Set<String> set = constraint.getColumnNames((Table)databaseObject);
                    boolean bl4 = false;
                    if (set != null) {
                        block3: for (String string3 : string2.split(",")) {
                            for (String string4 : set) {
                                if (!constraintOperatorEnum.matches(string3, string4, bl2)) continue;
                                bl4 = true;
                                continue block3;
                            }
                        }
                    }
                    if (bl4) continue;
                    this.addFailureRuleIteration(databaseObject, this.getFailureMessage((String)dynamicRule.getParameterValue(DynamicRuleParameterEnum.MESSAGE), DatabaseObjectUtils.buildFullyQualifiedName(databaseObject), constraint), dynamicRule);
                    bl3 = false;
                }
                if (bl3) {
                    this.putResultSuccessful(databaseObject, true, dynamicRule);
                }
            }
        }
        return true;
    }

    private String getFailureMessage(String string, String string2, Constraint constraint) {
        return string.replace("<" + (Object)((Object)DynamicRuleParameterEnum.TABLE_NAME) + ">", string2).replace("<" + (Object)((Object)DynamicRuleParameterEnum.CONSTRAINT) + ">", constraint.toString());
    }

    private Boolean getCaseSensitiveParam(DynamicRule dynamicRule, ConstraintOperatorEnum constraintOperatorEnum) {
        Boolean bl2 = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        if (constraintOperatorEnum != ConstraintOperatorEnum.REGEXP) {
            bl2 = (Boolean)dynamicRule.getParameterValue(DynamicRuleParameterEnum.CASE_SENSITIVE);
        } else if (dynamicRule.getParameter(DynamicRuleParameterEnum.CASE_SENSITIVE) != null) {
            throw new Exception("Rule is using a " + (Object)((Object)ConstraintOperatorEnum.REGEXP) + " operator, but also has a value for the " + (Object)((Object)DynamicRuleParameterEnum.CASE_SENSITIVE) + " param.");
        }
        return bl2;
    }

    @Override
    public String getDescription() {
        return "Check for and alert when specified table does not contain the required constraint(s).";
    }

    @Override
    public String getShortName() {
        return "ConstraintMustExist";
    }

    @Override
    public int getPriority() {
        return 570;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.CONSTRAINT_OPERATOR), new RuleParameter<String>(DynamicRuleParameterEnum.TABLE_NAME, ConstraintMustExist::validateSearchString, ConstraintMustExist::shouldPromptForNames, null, true), new RuleParameter<String>(DynamicRuleParameterEnum.COLUMN_NAME, ConstraintMustExist::validateSearchString, ConstraintMustExist::shouldPromptForNames), new RuleParameter(DynamicRuleParameterEnum.CONSTRAINT), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE, null, object -> {
            object = ((DynamicRuleParameter)(object = object.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.CONSTRAINT_OPERATOR).findFirst().get())).getValue() instanceof String ? ConstraintOperatorEnum.valueOf((String)((DynamicRuleParameter)object).getValue()) : ((DynamicRuleParameter)object).getValue();
            return object != ConstraintOperatorEnum.REGEXP;
        }), new RuleParameter(DynamicRuleParameterEnum.MESSAGE, null, null, "The specified table '<" + (Object)((Object)DynamicRuleParameterEnum.TABLE_NAME) + ">' does not contain the required '<" + (Object)((Object)DynamicRuleParameterEnum.CONSTRAINT) + ">' constraint.", false));
    }

    private static Boolean shouldPromptForNames(List<DynamicRuleParameter> object) {
        if (!((Optional)(object = object.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.CONSTRAINT_OPERATOR).findFirst())).isPresent()) {
            return Boolean.TRUE;
        }
        object = ((DynamicRuleParameter)(object = (DynamicRuleParameter)((Optional)object).get())).getValue() instanceof String ? ConstraintOperatorEnum.valueOf((String)((DynamicRuleParameter)object).getValue()) : ((DynamicRuleParameter)object).getValue();
        return object != ConstraintOperatorEnum.ALL;
    }

    private static Boolean validateSearchString(String string, List<DynamicRuleParameter> object) {
        if (!((Optional)(object = object.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.CONSTRAINT_OPERATOR).findFirst())).isPresent()) {
            return Boolean.TRUE;
        }
        if (((DynamicRuleParameter)((Optional)object).get()).getValue() == ConstraintOperatorEnum.REGEXP) {
            if (StringUtil.isNotEmpty(string)) {
                return new RegexGetter().validate(string);
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }
}

