/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.JSqlParserCache;
import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.RuleIteration$FailureReason;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Table;

public class TableColumnCountWarning
extends AbstractLiquibaseDynamicForecastRule {
    public TableColumnCountWarning() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public String getName() {
        return "Check Table Column Count";
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Arrays.asList(ScopeEnum.CHANGELOG, ScopeEnum.DATABASE);
    }

    @Override
    public List<String> getTags() {
        return Collections.emptyList();
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public String getShortName() {
        return "TableColumnLimit";
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        for (Change jSQLParserException : changeSet.getChanges()) {
            Integer n2 = (Integer)dynamicRule.getParameters().get(0).getValue();
            if (jSQLParserException instanceof CreateTableChange) {
                if (!this.doTableColumnCountCheck((CreateTableChange)jSQLParserException, (int)n2)) continue;
                this.addErrorMessage(changeSet, n2, dynamicRule);
                continue;
            }
            if (!(jSQLParserException instanceof AbstractSQLChange)) continue;
            try {
                Statement statement = JSqlParserCache.parseSql(this.getSql((AbstractSQLChange)jSQLParserException), true);
                if (!(statement instanceof CreateTable) || !this.doTableColumnCountCheck((CreateTable)statement, (int)n2)) continue;
                this.addErrorMessage(changeSet, n2, dynamicRule);
            }
            catch (JSQLParserException jSQLParserException2) {
                Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to parse SQL", jSQLParserException2);
                this.addFailureRuleIteration(changeSet, "Some or all of the SQL could not be parsed by this check. Please review the changeset or SQL directly to make sure it is valid.", RuleIteration$FailureReason.SQL_PARSING, dynamicRule);
            }
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        Integer n2 = (Integer)dynamicRule.getParameters().get(0).getValue();
        if (databaseObject instanceof Table && this.doTableColumnCountCheck((Table)databaseObject, (int)n2)) {
            this.addErrorMessage(databaseObject, n2, dynamicRule);
        }
        return this.returnAtEndOfRule(databaseObject, dynamicRule);
    }

    private void addErrorMessage(ChangeSet changeSet, Integer n2, DynamicRule dynamicRule) {
        String string = this.determinePlurality(n2);
        this.addFailureRuleIteration(changeSet, String.format("Table must not have more than %d %s.", n2, string), dynamicRule);
    }

    private void addErrorMessage(DatabaseObject databaseObject, Integer n2, DynamicRule dynamicRule) {
        String string = this.determinePlurality(n2);
        this.addFailureRuleIteration(databaseObject, String.format("Table %s must not have more than %d %s.", databaseObject.getName(), n2, string), dynamicRule);
    }

    private String determinePlurality(Integer n2) {
        if (n2 == 1) {
            return "column";
        }
        return "columns";
    }

    private boolean doTableColumnCountCheck(CreateTableChange createTableChange, int n2) {
        return createTableChange.getColumns().size() > n2;
    }

    private boolean doTableColumnCountCheck(Table table, int n2) {
        return table.getColumns().size() > n2;
    }

    private boolean doTableColumnCountCheck(CreateTable createTable, int n2) {
        return createTable.getColumnDefinitions().size() > n2;
    }

    @Override
    public String getDescription() {
        return "Ensures that no table has more than a threshold number of columns.";
    }

    @Override
    public int getPriority() {
        return 70;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Collections.singletonList(new RuleParameter(DynamicRuleParameterEnum.MAX_COLUMNS));
    }
}

