/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.InMemoryChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.output.FormattedChangelogChecksResultModel;
import com.datical.liquibase.ext.checks.output.FormattedChecksOutputModel;
import com.datical.liquibase.ext.checks.output.FormattedChecksOutputSerializer;
import com.datical.liquibase.ext.checks.output.FormattedChecksReportResultModel;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksResultModel;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep$1;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper;
import com.datical.liquibase.ext.command.checks.ChecksRunJsonOutputHelper;
import com.datical.liquibase.ext.command.checks.EngineResults;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.config.LiquibaseLabsConfiguration;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.ChangesetQualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.DatabaseQualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.database.Database;
import liquibase.database.core.H2Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.ChangeLogParseException;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;
import liquibase.exception.MissingRequiredArgumentException;
import liquibase.license.LicenseService;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.license.pro.LicenseTier;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class ChecksRunCommandStep
extends AbstractChecksCommandStep {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    public static final String[] COMMAND_NAME = new String[]{"checks", "run"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SCOPE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_AUTO_UPDATE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_OUTPUT_FORMAT_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_INTEGRATION_ARG;
    public static final CommandArgumentDefinition<String> CHECK_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> SCHEMAS_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;
    public static final CommandArgumentDefinition<Boolean> VERBOSE_ARG;
    public static final CommandArgumentDefinition<Boolean> CACHE_CHANGELOG_FILE_CONTENTS;
    public static final CommandArgumentDefinition<String> LABELS_ARG;
    public static final CommandArgumentDefinition<String> CONTEXTS_ARG;

    @Override
    public void validate(CommandScope object) {
        String string = ((CommandScope)object).getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
        String string2 = ((CommandScope)object).getConfiguredValue(URL_ARG).getValue();
        if (string == null && string2 == null) {
            throw new CommandValidationException("changelogFile, url", "one is required for 'checks run'", new MissingRequiredArgumentException("--changelog-file, --url"));
        }
        if (((String)(object = ((CommandScope)object).getConfiguredValue(CHECKS_SCOPE_ARG).getValue())).toUpperCase().contains(ScopeEnum.CHANGELOG.toString()) && string == null) {
            throw new CommandValidationException(CHECKS_SCOPE_ARG.getName(), "you must supply a changelogFile argument for changelog checks", new MissingRequiredArgumentException(CHECKS_SCOPE_ARG.getName()));
        }
        if (((String)object).toUpperCase().contains(ScopeEnum.DATABASE.toString()) && string2 == null) {
            throw new CommandValidationException(CHECKS_SCOPE_ARG.getName(), "you must supply a URL argument for database checks", new MissingRequiredArgumentException(CHECKS_SCOPE_ARG.getName()));
        }
    }

    @Override
    public boolean commandRequiresProLicense() {
        return false;
    }

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(2);
        Object object = commandResultsBuilder.getCommandScope();
        hashMap.put(CACHE_CHANGELOG_FILE_CONTENTS.getName(), ((CommandScope)object).getConfiguredValue(CACHE_CHANGELOG_FILE_CONTENTS).getValue());
        if (this.isMavenIntegration(commandResultsBuilder)) {
            object = new InMemoryChecksFileAccessor();
            hashMap.put("fileAccessor", object);
        }
        Scope.child(hashMap, () -> this.doRun(commandResultsBuilder));
    }

    private void doRun(CommandResultsBuilder commandResultsBuilder) {
        EngineResults<Object> engineResults;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        boolean bl2;
        LazyDatabaseSnapshot lazyDatabaseSnapshot;
        String string;
        String string2;
        Object object5;
        Object object6;
        Object object7;
        block27: {
            Object object8;
            boolean bl3;
            block26: {
                object7 = commandResultsBuilder.getCommandScope();
                object6 = ((CommandScope)object7).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
                ChecksRunCommandStep.checkFileArgExistence((String)object6, "checks settings", false);
                object5 = ((CommandScope)object7).getConfiguredValue(CHECKS_AUTO_UPDATE_ARG).getValue();
                object5 = new CheckSettingsConfigHelper((String)object6, (String)object5);
                string2 = ((CommandScope)object7).getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
                ChecksRunCommandStep.checkFileArgExistence(string2, "changelog", true);
                string = null;
                lazyDatabaseSnapshot = null;
                try {
                    String string3 = ((CommandScope)object7).getConfiguredValue(CHECKS_SCOPE_ARG).getValue();
                    bl2 = string3.toUpperCase().contains(ScopeEnum.DATABASE.toString());
                    bl3 = string3.toUpperCase().contains(ScopeEnum.CHANGELOG.toString());
                    if (bl2) {
                        lazyDatabaseSnapshot = new LazyDatabaseSnapshot((CommandScope)object7);
                        string = lazyDatabaseSnapshot.getUrl();
                        this.sendMessageToUi("Executing Quality Checks against database " + JdbcConnection.sanitizeUrl(string) + System.lineSeparator());
                        commandResultsBuilder.addResult("statusCode", (Object)0);
                    }
                    object8 = null;
                    if (string2 == null || !bl3) break block26;
                    this.sendMessageToUi("Executing Quality Checks against " + string2 + System.lineSeparator());
                    if (LicenseServiceUtils.isProLicenseValid()) {
                        this.sendMessageToUi("WARNING: Checks executed against H2 generated SQL, which may not contain certain objects." + System.lineSeparator());
                    }
                    object4 = Scope.getCurrentScope().getResourceAccessor();
                    object3 = ChangeLogParserFactory.getInstance().getParser(string2, (ResourceAccessor)object4);
                    try {
                        object8 = object3.parse(string2, new ChangeLogParameters(), (ResourceAccessor)object4);
                    }
                    catch (ChangeLogParseException changeLogParseException) {
                        String string4 = String.format("%nThe changelog file %s cannot be found or is not a valid changelog: %s%nCorrect this issue and try to run checks again.", string2, changeLogParseException.getMessage());
                        Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe(string4);
                        Scope.getCurrentScope().getUI().sendMessage(string4);
                        if (lazyDatabaseSnapshot != null) {
                            lazyDatabaseSnapshot.close();
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    if (lazyDatabaseSnapshot != null) {
                        lazyDatabaseSnapshot.close();
                    }
                    throw throwable;
                }
            }
            object4 = ((CommandScope)object7).getConfiguredValue(CHECK_NAME_ARG).getValue();
            object3 = ChecksRunCommandStep.listAllRules();
            try {
                object5 = ((CheckSettingsConfigHelper)object5).read((List<AbstractLiquibaseRule>)object3);
            }
            catch (Exception exception) {
                object6 = String.format("%nUnable to read checks settings file '%s': %s%nCorrect this issue and try to run checks again.", object6, exception.getMessage());
                Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object6);
                Scope.getCurrentScope().getUI().sendMessage((String)object6);
                if (lazyDatabaseSnapshot != null) {
                    lazyDatabaseSnapshot.close();
                }
                return;
            }
            object2 = this.determineRulesToRun((CheckSettingsConfig)object5, (String)object4);
            this.printLicensingMessages((List<AbstractLiquibaseRule>)object3, (List<AbstractConfigurableRule>)object2, (String)object4, bl3, bl2);
            object6 = new EngineResults();
            if (object8 != null) {
                H2Database h2Database = new H2Database();
                object6 = new Contexts(((CommandScope)object7).getArgumentValue(CONTEXTS_ARG));
                object4 = new LabelExpression(((CommandScope)object7).getArgumentValue(LABELS_ARG));
                object8 = new ChangeLogIterator((DatabaseChangeLog)object8, new ContextChangeSetFilter((Contexts)object6), new LabelChangeSetFilter((LabelExpression)object4));
                object = new ListVisitor();
                ((ChangeLogIterator)object8).run((ChangeSetVisitor)object, new RuntimeEnvironment(h2Database, (Contexts)object6, (LabelExpression)object4));
                object6 = this.runChecks((List<AbstractLiquibaseRule>)object3, ((ListVisitor)object).getSeenChangeSets(), h2Database, (List<AbstractConfigurableRule>)object2);
            }
            engineResults = new EngineResults();
            if (lazyDatabaseSnapshot != null) {
                engineResults = this.runDatabaseChecks((List<AbstractLiquibaseRule>)object3, lazyDatabaseSnapshot, (List<AbstractConfigurableRule>)object2);
                if (lazyDatabaseSnapshot.isAttempted()) {
                    commandResultsBuilder.addResult("snapshot", lazyDatabaseSnapshot.getSnapshot());
                }
            }
            if (!((EngineResults)object6).getExecutedRules().isEmpty() || !engineResults.getExecutedRules().isEmpty() || !engineResults.getSkippedBecauseOfLicenceRules().isEmpty() || !LicenseServiceUtils.isProLicenseValid()) break block27;
            object6 = "\nWarning:  No checks were executed\nChangesets Validated:  None\nChecks run against each changeset:  None\n\n";
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object6);
            this.sendMessageToUi((String)object6);
            if (lazyDatabaseSnapshot != null) {
                lazyDatabaseSnapshot.close();
            }
            return;
        }
        object4 = ((CommandScope)object7).getArgumentValue(CHECKS_OUTPUT_FORMAT_ARG);
        boolean bl4 = ((CommandScope)object7).getConfiguredValue(VERBOSE_ARG).getValue();
        if (this.isJsonOutput((String)object4)) {
            object = new StringBuilder();
            object7 = ((CommandScope)object7).getConfiguredValue(CHECKS_INTEGRATION_ARG).getValue();
            FormattedChecksOutputModel formattedChecksOutputModel = new FormattedChecksOutputModel();
            new FormattedChecksOutputModel().checksRun = new Date().toString();
            object2 = new FormattedChecksReportResultModel();
            formattedChecksOutputModel.checksReport.add((FormattedChecksReportResultModel)object2);
            SeverityEnum severityEnum = SeverityEnum.INFO;
            SeverityEnum severityEnum2 = SeverityEnum.INFO;
            if (string2 != null) {
                object6 = ChecksRunJsonOutputHelper.createChangelogJsonOutput(((EngineResults)object6).getResults(), ((EngineResults)object6).getExecutedRules(), string2, (String)object7, (CheckSettingsConfig)object5, ((EngineResults)object6).getSkippedBecauseOfLicenceRules(), (List<AbstractLiquibaseRule>)object3);
                severityEnum = ((FormattedChangelogChecksResultModel)object6).maxSeverity;
                ((FormattedChecksReportResultModel)object2).changelogChecks.add((FormattedChangelogChecksResultModel)object6);
            }
            if (lazyDatabaseSnapshot != null && lazyDatabaseSnapshot.isAttempted() || !engineResults.getSkippedBecauseOfLicenceRules().isEmpty()) {
                object7 = ChecksRunJsonOutputHelper.createDatabaseJsonOutput(engineResults, string, lazyDatabaseSnapshot, bl4, (String)object7, (CheckSettingsConfig)object5);
                severityEnum2 = ((FormattedDatabaseChecksResultModel)object7).maxSeverity;
                ((FormattedChecksReportResultModel)object2).databaseChecks.add((FormattedDatabaseChecksResultModel)object7);
            }
            object7 = new FormattedChecksOutputSerializer().serialize(formattedChecksOutputModel, true).replaceAll("!!com.datical.liquibase.[^\\s]+ (.*)", "$1");
            ((StringBuilder)object).append((String)object7);
            object6 = severityEnum.getValue() > severityEnum2.getValue() ? severityEnum : severityEnum2;
            commandResultsBuilder.getOutputStream().write(((StringBuilder)object).toString().getBytes(StandardCharsets.UTF_8));
        } else {
            object6 = ChecksRunConsoleOutputHelper.outputChecksResults(commandResultsBuilder, (EngineResults<ChangeSet>)object6, engineResults, lazyDatabaseSnapshot, string, bl4, (List<AbstractLiquibaseRule>)object3, bl2);
        }
        if (object5 != null && !this.isJsonOutput((String)object4)) {
            this.sendMessage(commandResultsBuilder, ((CheckSettingsConfig)object5).getUnrecognizedRulesWarningMessage());
        }
        commandResultsBuilder.getOutputStream().flush();
        int n2 = ((SeverityEnum)((Object)object6)).getExitValue();
        if (n2 != 0) {
            commandResultsBuilder.addResult("statusCode", (Object)n2);
            throw commandResultsBuilder.commandFailed("Checks run command exited with an error code of ".concat(String.valueOf(n2)), n2, true);
        }
        if (object5 != null) {
            ((CheckSettingsConfig)object5).outputWarningMessage();
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
        if (lazyDatabaseSnapshot != null) {
            lazyDatabaseSnapshot.close();
            return;
        }
    }

    private List<AbstractConfigurableRule> determineRulesToRun(CheckSettingsConfig checkSettingsConfig, String iterator) {
        if (StringUtil.isEmpty((String)((Object)iterator))) {
            return checkSettingsConfig.getRules();
        }
        iterator = Arrays.stream(((String)((Object)iterator)).split(",")).map(String::trim).collect(Collectors.toList());
        ArrayList<AbstractConfigurableRule> arrayList = new ArrayList<AbstractConfigurableRule>(iterator.size());
        ArrayList<String> arrayList2 = new ArrayList<String>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            AbstractConfigurableRule abstractConfigurableRule = checkSettingsConfig.getRuleByShortName(string);
            if (abstractConfigurableRule == null) {
                arrayList2.add(string);
                continue;
            }
            arrayList.add(abstractConfigurableRule);
        }
        if (!arrayList2.isEmpty()) {
            throw new CommandExecutionException("One or more specified checks not found: '" + StringUtil.join(arrayList2, "', '") + "'. Please check your arguments and try again.");
        }
        return arrayList;
    }

    private void printLicensingMessages(List<AbstractLiquibaseRule> list, List<AbstractConfigurableRule> list2, String string, boolean bl2, boolean bl3) {
        LicenseService licenseService = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService();
        int n2 = licenseService.daysTilExpiration();
        boolean bl4 = LicenseServiceUtils.isProLicenseValid();
        boolean bl5 = LiquibaseLabsConfiguration.isLabsLicenseValid();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
        List<String> list3 = list2.stream().filter(abstractConfigurableRule -> {
            if (!((Optional)(list = abstractConfigurableRule.findParentRule(list))).isPresent()) {
                return false;
            }
            if (bl2 && !((AbstractLiquibaseRule)((Optional)((Object)list)).get()).getScope().contains((Object)ScopeEnum.CHANGELOG)) {
                return false;
            }
            if (bl3 && !((AbstractLiquibaseRule)((Optional)((Object)list)).get()).getScope().contains((Object)ScopeEnum.DATABASE)) {
                return false;
            }
            if (bl5) {
                return true;
            }
            return ((AbstractLiquibaseRule)((Optional)((Object)list)).get()).getScope().contains((Object)ScopeEnum.CHANGELOG);
        }).map(abstractConfigurableRule -> abstractConfigurableRule.getShortName(list)).collect(Collectors.toList());
        boolean bl6 = list2.stream().anyMatch(abstractConfigurableRule -> bl5 && abstractConfigurableRule.findParentRule(list).isPresent() && abstractConfigurableRule.findParentRule(list).get().getScope().contains((Object)ScopeEnum.DATABASE) && !bl3);
        boolean bl7 = StringUtil.isEmpty(string);
        if (n2 > 0) {
            if (bl5 && bl2 && bl3) {
                if (bl7) {
                    this.sendMessageToUi("Executing all changelog and database checks because a valid license key was found!" + System.lineSeparator());
                } else if (!list3.isEmpty()) {
                    this.sendMessageToUi("Executing specified changelog and database checks: '" + StringUtil.join(list3, "', '") + "'");
                }
            } else if ((bl4 || bl5) && bl2) {
                if (bl7) {
                    this.sendMessageToUi("Executing all changelog checks because a valid license key was found!" + System.lineSeparator());
                } else if (!list3.isEmpty()) {
                    this.sendMessageToUi("Executing specified changelog checks: '" + StringUtil.join(list3, "', '") + "'");
                }
            } else if (bl5 && bl3) {
                if (bl7) {
                    this.sendMessageToUi("Executing all database checks because a valid license key was found!" + System.lineSeparator());
                } else if (!list3.isEmpty()) {
                    this.sendMessageToUi("Executing specified database checks: '" + StringUtil.join(list3, "', '") + "'");
                }
            }
            if (bl6) {
                this.sendMessageToUi("WARNING: No database checks were run. Make sure the checks-scope property includes \"database\" to run database checks. In the CLI set --checks-scope=\"changelog,database\" or set an environment variable LIQUIBASE_COMMAND_CHECKS_SCOPE=database. Learn more at http://docs.liquibase.com/quality-checks" + System.lineSeparator());
            }
            if (n2 <= 7) {
                this.sendMessageToUi("WARNING: Liquibase license key will expire on " + simpleDateFormat.format(licenseService.getExpirationDate()) + ". You will lose access access to unlimited changelog and database checks providing quality assurance and compliance.\nContact Support or Sales, or buy online at https://liquibase.com/pricing");
            }
            if (!bl5 && bl4 && bl3) {
                this.sendMessageToUi("No valid " + LicenseTier.LABS.getSubject() + " license key detected!" + System.lineSeparator() + "Unlock unlimited changelog checks with Pro license Key." + System.lineSeparator() + "Add unlimited database checks with a Labs license key." + System.lineSeparator() + "Free trial key at https://liquibase.com/trial" + System.lineSeparator());
            }
            if (!bl4 && !bl5) {
                this.sendMessageToUi("No valid Liquibase license key detected!" + System.lineSeparator() + "Unlock unlimited changelog checks with Pro license Key." + System.lineSeparator() + "Add unlimited database checks with a Labs license key." + System.lineSeparator() + "Free trial key at https://liquibase.com/trial" + System.lineSeparator());
                return;
            }
        } else {
            this.sendMessageToUi("WARNING: Liquibase license key expired on " + simpleDateFormat.format(licenseService.getExpirationDate()) + ". To regain access to unlimited changelog and database checks providing quality assurance and compliance, contact Support or Sales, or buy online at https://liquibase.com/pricing" + System.lineSeparator());
        }
    }

    private boolean isJsonOutput(String string) {
        return string.equalsIgnoreCase(ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.JSON.name());
    }

    private static boolean validateOutputFormat(String string) {
        ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT[] checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray = ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.values();
        int n2 = checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!checksRunCommandStep$CHECKS_RUN_OUTPUT_FORMATArray[i2].toString().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void sendMessageToUi(String string) {
        Scope.getCurrentScope().getUI().sendMessage(string);
    }

    private void sendMessage(CommandResultsBuilder commandResultsBuilder, String string) {
        commandResultsBuilder.getOutputStream().write(string.getBytes());
    }

    private static boolean validChecksScope(String string2) {
        return Arrays.stream(string2.split(",")).allMatch(string -> Arrays.stream(ScopeEnum.values()).anyMatch(scopeEnum -> string.trim().equalsIgnoreCase(scopeEnum.toString())));
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Check the changelog or database for issues");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private EngineResults<ChangeSet> runChecks(List<AbstractLiquibaseRule> list, List<ChangeSet> list2, Database database, List<AbstractConfigurableRule> list3) {
        if (list3 != null) {
            return this.runCheck(list, list2, database, list3);
        }
        return new EngineResults<ChangeSet>();
    }

    private EngineResults<DatabaseObject> runDatabaseChecks(List<AbstractLiquibaseRule> list, LazyDatabaseSnapshot lazyDatabaseSnapshot, List<AbstractConfigurableRule> list2) {
        if (list2 != null) {
            return this.runDatabaseCheck(list, lazyDatabaseSnapshot, list2);
        }
        return new EngineResults<DatabaseObject>();
    }

    private EngineResults<DatabaseObject> runDatabaseCheck(List<AbstractLiquibaseRule> iterator, LazyDatabaseSnapshot object, List<AbstractConfigurableRule> list) {
        Object object2 = new Facts();
        ((Facts)object2).put(FactEnum.DATABASE_SNAPSHOT.toString(), object);
        iterator = new Rules(iterator.toArray());
        object = new DatabaseQualityChecksRulesEngine(list);
        ((QualityChecksRulesEngine)object).fire((Rules)((Object)iterator), (Facts)object2);
        iterator = ((QualityChecksRulesEngine)object).getResults();
        list = ((QualityChecksRulesEngine)object).getSkippedRules();
        object2 = new LinkedHashMap(iterator.size());
        for (Map.Entry entry : iterator.entrySet()) {
            ((HashMap)object2).put(entry.getKey(), new LiquibaseQualityCheckResult((List)entry.getValue(), null, ((QualityChecksRulesEngine)object).getExecutedRules(), null));
        }
        return new EngineResults<DatabaseObject>((List<RuleCombination>)list, (LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult>)object2);
    }

    private EngineResults<ChangeSet> runCheck(List<AbstractLiquibaseRule> list, List<ChangeSet> object2, Database list2, List<AbstractConfigurableRule> list3) {
        Facts facts = new Facts();
        facts.put(FactEnum.CHANGESETS.toString(), object2);
        facts.put(FactEnum.DATABASE.toString(), list2);
        list2 = new Rules(list.toArray());
        ChangesetQualityChecksRulesEngine changesetQualityChecksRulesEngine = new ChangesetQualityChecksRulesEngine(list3);
        changesetQualityChecksRulesEngine.registerRuleListener(new ChecksRunCommandStep$1(this));
        changesetQualityChecksRulesEngine.fire((Rules)list2, facts);
        list2 = changesetQualityChecksRulesEngine.getSkippedRules();
        object2 = new LinkedHashMap(object2.size());
        for (Map.Entry entry : changesetQualityChecksRulesEngine.getResults().entrySet()) {
            List<LiquibaseRuleResult> list4 = (List<LiquibaseRuleResult>)entry.getValue();
            Object object3 = new AtomicBoolean(false);
            object3 = list4.stream().filter(arg_0 -> ChecksRunCommandStep.lambda$runCheck$11((AtomicBoolean)object3, arg_0)).collect(Collectors.toList());
            List<String> list5 = list4.stream().filter(LiquibaseRuleResult::hasSqlParseFailures).skip(1L).map(liquibaseRuleResult -> this.getSkippedRuleName(liquibaseRuleResult.getRule(), liquibaseRuleResult.getDynamicRule())).collect(Collectors.toList());
            list4 = list4.stream().filter(LiquibaseRuleResult::hasInvalidChangelogFileTypeFailures).filter(object -> {
                object = ((LiquibaseRuleResult)object).getRuleShortName(false);
                return list3.stream().filter(arg_0 -> ChecksRunCommandStep.lambda$null$13(list, (String)object, arg_0)).findFirst().map(AbstractConfigurableRule::isEnabled).orElse(Boolean.FALSE);
            }).collect(Collectors.toList());
            List<RuleCombination> list6 = changesetQualityChecksRulesEngine.getExecutedRules().stream().filter(ruleCombination -> !list5.contains(this.getSkippedRuleName((AbstractLiquibaseRule)ruleCombination.rule, ruleCombination.configurableRule))).collect(Collectors.toList());
            object2.put(entry.getKey(), new LiquibaseQualityCheckResult((List<LiquibaseRuleResult>)object3, list5, list6, list4));
        }
        return new EngineResults<ChangeSet>((List<RuleCombination>)list2, object2);
    }

    private String getSkippedRuleName(AbstractLiquibaseRule abstractLiquibaseRule, AbstractConfigurableRule abstractConfigurableRule) {
        if (abstractConfigurableRule instanceof DynamicRule) {
            return ((DynamicRule)abstractConfigurableRule).getShortName();
        }
        if (abstractLiquibaseRule.getShortName() != null) {
            return abstractLiquibaseRule.getShortName();
        }
        return abstractLiquibaseRule.getName();
    }

    private static /* synthetic */ boolean lambda$null$13(List list, String string, AbstractConfigurableRule abstractConfigurableRule) {
        return abstractConfigurableRule.getShortName(list).equals(string);
    }

    private static /* synthetic */ boolean lambda$runCheck$11(AtomicBoolean atomicBoolean, LiquibaseRuleResult liquibaseRuleResult) {
        if (liquibaseRuleResult.hasSqlParseFailures()) {
            return !atomicBoolean.getAndSet(true);
        }
        return true;
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Relative or fully qualified path to a Liquibase changelog file.  One of --changelog-file or --url is required.").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_SCOPE_ARG = commandBuilder.argument("checksScope", String.class).defaultValue(ScopeEnum.CHANGELOG.toString().toLowerCase()).setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!ChecksRunCommandStep.validChecksScope((String)(object = (String)object))) {
                object = "\nWARNING:  Check scope value '" + (String)object + "' is not valid.  Valid check scope values include: " + StringUtil.join((Object[])ScopeEnum.values(), ", ", scopeEnum -> scopeEnum.toString().toLowerCase());
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).description("The Liquibase component to run checks against, which can be a comma separated list").build();
        CHECKS_AUTO_UPDATE_ARG = commandBuilder.argument("autoUpdate", String.class).description("Allows automatic backup and updating of liquibase.checks.conf file when new quality checks are available. Options: [on|off]").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("on") || ((String)object).equalsIgnoreCase("off")) {
                return object;
            }
            object = "\nWARNING:  The autoUpdate value '" + (String)object + "' is not valid.  Valid values include: 'on' or 'off'";
            throw new IllegalArgumentException((String)object);
        }).build();
        CHECKS_OUTPUT_FORMAT_ARG = commandBuilder.argument("format", String.class).defaultValue(ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.TXT.name()).description("Option to create JSON output").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!ChecksRunCommandStep.validateOutputFormat((String)(object = String.valueOf(object)))) {
                object = "\nWARNING:  The format value '" + (String)object + "' is not valid.  Valid values include: 'json' or 'txt'";
                throw new IllegalArgumentException((String)object);
            }
            if (((String)object).equalsIgnoreCase("json")) {
                if (!LicenseServiceUtils.isProLicenseValid()) {
                    object = "checks run --format=".concat(String.valueOf(object));
                    object = String.format(coreBundle.getString("no.pro.license.found"), object);
                    throw new IllegalArgumentException((String)object);
                }
                return ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.JSON.name();
            }
            return ChecksRunCommandStep$CHECKS_RUN_OUTPUT_FORMAT.TXT.name();
        }).build();
        CHECKS_INTEGRATION_ARG = commandBuilder.argument("checksIntegration", String.class).hidden().defaultValue("cli").description("Name of the integration that is executing checks run").build();
        CHECK_NAME_ARG = commandBuilder.argument("checkName", String.class).description("Comma-separated list of one or more enabled checks to run. If not specified, all enabled checks will run. Example: --check-name=shortname1,shortname2,shortname3").build();
        URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL.  One of --changelog-file or --url is required.").build();
        SCHEMAS_ARG = commandBuilder.argument("schemas", String.class).description("The schemas to check when checks-scope contains 'database'").build();
        DEFAULT_SCHEMA_NAME_ARG = commandBuilder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = commandBuilder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = commandBuilder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = commandBuilder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").build();
        PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        VERBOSE_ARG = commandBuilder.argument("verbose", Boolean.class).defaultValue(Boolean.FALSE).setValueHandler(object -> {
            if (object == null) {
                return Boolean.TRUE;
            }
            if (object instanceof Boolean) {
                return (Boolean)object;
            }
            if (((String)(object = (String)object)).equalsIgnoreCase("true") || ((String)object).equalsIgnoreCase("false")) {
                return Boolean.valueOf((String)object);
            }
            object = "\nWARNING:  The input '" + (String)object + "' is not valid.  Options: 'true' or 'false'.";
            throw new IllegalArgumentException((String)object);
        }).description("Verbose flag with optional values of 'True' or 'False'. The default is 'False'.").build();
        CACHE_CHANGELOG_FILE_CONTENTS = commandBuilder.argument("cacheChangelogFileContents", Boolean.class).description("If true, sqlFile change type contents will be cached in memory to improve performance, at the cost of higher memory usage. To reduce memory usage, set this to false.").defaultValue(Boolean.TRUE).build();
        LABELS_ARG = commandBuilder.argument("labels", String.class).description("Changeset labels to match").build();
        CONTEXTS_ARG = commandBuilder.argument("contexts", String.class).description("Changeset contexts to match").build();
    }
}

