/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.snapshot.DatabaseSnapshotHelper;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import java.io.Closeable;
import java.util.ResourceBundle;
import java.util.Set;
import liquibase.CatalogAndSchema;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.DatabaseException;
import liquibase.integration.commandline.CommandLineUtils;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;
import liquibase.resource.ResourceAccessor;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.EmptyDatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.DatabaseObjectFactory;

public class LazyDatabaseSnapshot
implements Closeable {
    private final String url;
    private final String username;
    private final String password;
    private final String defaultSchemaName;
    private final String defaultCatalogName;
    private final String schemas;
    private final String driver;
    private final String driverPropertiesFile;
    private DatabaseSnapshot snapshot = null;
    private boolean attempted = false;
    private Database database = null;
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    private CommandExecutionException exception;

    public LazyDatabaseSnapshot(CommandScope commandScope) {
        this.url = commandScope.getArgumentValue(ChecksRunCommandStep.URL_ARG);
        this.username = commandScope.getArgumentValue(ChecksRunCommandStep.USERNAME_ARG);
        this.password = commandScope.getArgumentValue(ChecksRunCommandStep.PASSWORD_ARG);
        this.defaultSchemaName = commandScope.getArgumentValue(ChecksRunCommandStep.DEFAULT_SCHEMA_NAME_ARG);
        this.defaultCatalogName = commandScope.getArgumentValue(ChecksRunCommandStep.DEFAULT_CATALOG_NAME_ARG);
        this.driver = commandScope.getArgumentValue(ChecksRunCommandStep.DRIVER_ARG);
        this.driverPropertiesFile = commandScope.getArgumentValue(ChecksRunCommandStep.DRIVER_PROPERTIES_FILE_ARG);
        this.schemas = commandScope.getArgumentValue(ChecksRunCommandStep.SCHEMAS_ARG);
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public String getDefaultCatalogName() {
        return this.defaultCatalogName;
    }

    public String getSchemas() {
        return this.schemas;
    }

    public DatabaseSnapshot getSnapshot() {
        if (this.snapshot == null && !this.attempted) {
            this.attempted = true;
            try {
                LazyDatabaseSnapshot lazyDatabaseSnapshot = this;
                lazyDatabaseSnapshot.createDatabaseObject(lazyDatabaseSnapshot.url, this.username, this.password, this.defaultSchemaName, this.defaultCatalogName, this.driver, this.driverPropertiesFile);
                this.snapshot = DatabaseSnapshotHelper.takeSnapshot(this.url, this.database, this.schemas);
                return this.snapshot;
            }
            catch (DatabaseException databaseException) {
                DatabaseException databaseException2 = databaseException;
                String string = databaseException.getMessage();
                String string2 = "' cannot be accessed. Database-scoped checks cannot be completed.\nPlease check all database properties and credentials and try again.";
                if (this.database == null) {
                    if (string != null && string.contains("Cannot parse snapshot")) {
                        string = "The snapshot specified in the URL property '" + this.url + string2;
                    }
                } else {
                    string = this.database.getConnection() instanceof OfflineConnection ? "The snapshot specified in the URL property '" + this.url + string2 : "The database target specified in the URL property '" + JdbcConnection.sanitizeUrl(this.url) + string2;
                }
                this.exception = new CommandExecutionException(string, databaseException2);
                throw this.exception;
            }
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.snapshot;
    }

    public Database getDatabase() {
        if (this.attempted) {
            return this.database;
        }
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isAttempted() {
        return this.attempted;
    }

    private void createDatabaseObject(String string, String string2, String string3, String string4, String string5, String string6, String string7) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        String string8 = null;
        Object object = LiquibaseCommandLineConfiguration.DATABASE_CLASS.getCurrentValue();
        if (object != null) {
            string8 = ((Class)object).getCanonicalName();
        }
        object = null;
        Object object2 = LiquibaseCommandLineConfiguration.PROPERTY_PROVIDER_CLASS.getCurrentValue();
        if (object2 != null) {
            object = ((Class)object2).getName();
        }
        object2 = GlobalConfiguration.LIQUIBASE_CATALOG_NAME.getCurrentValue();
        String string9 = GlobalConfiguration.LIQUIBASE_SCHEMA_NAME.getCurrentValue();
        String string10 = GlobalConfiguration.LIQUIBASE_TABLESPACE_NAME.getCurrentValue();
        String string11 = GlobalConfiguration.DATABASECHANGELOGLOCK_TABLE_NAME.getCurrentValue();
        String string12 = GlobalConfiguration.DATABASECHANGELOG_TABLE_NAME.getCurrentValue();
        this.database = CommandLineUtils.createDatabaseObject(resourceAccessor, string, string2, string3, string6, string5, string4, false, false, string8, string7, (String)object, (String)object2, string9, string12, string11);
        this.database.setLiquibaseTablespaceName(string10);
    }

    public DiffResult createDiffResult() {
        DatabaseSnapshot databaseSnapshot = this.getSnapshot();
        Object object = CompareControl.computeSchemas((String)this.getSchemas(), (String)this.getSchemas(), null, (String)this.getDefaultCatalogName(), (String)this.getDefaultSchemaName(), (String)this.getDefaultCatalogName(), (String)this.getDefaultSchemaName(), (Database)this.getDatabase()).finalTargetSchemas;
        CompareControl.SchemaComparison[] schemaComparisonArray = new CompareControl.SchemaComparison[CompareControl.computeSchemas((String)this.getSchemas(), (String)this.getSchemas(), null, (String)this.getDefaultCatalogName(), (String)this.getDefaultSchemaName(), (String)this.getDefaultCatalogName(), (String)this.getDefaultSchemaName(), (Database)this.getDatabase()).finalTargetSchemas.length];
        int n2 = 0;
        int n3 = ((CatalogAndSchema[])object).length;
        for (int i2 = 0; i2 < n3; ++i2) {
            CatalogAndSchema catalogAndSchema;
            CatalogAndSchema catalogAndSchema2 = catalogAndSchema = object[i2];
            schemaComparisonArray[n2] = new CompareControl.SchemaComparison(catalogAndSchema2, catalogAndSchema2);
            ++n2;
        }
        object = DatabaseObjectFactory.getInstance().getStandardTypes();
        CompareControl compareControl = new CompareControl(schemaComparisonArray, (Set<Class<? extends DatabaseObject>>)object);
        return DiffGeneratorFactory.getInstance().compare(databaseSnapshot, new EmptyDatabaseSnapshot(this.getDatabase()), compareControl);
    }

    @Override
    public void close() {
        try {
            if (this.database != null) {
                this.database.rollback();
                this.database.close();
            }
            return;
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(this.getClass()).warning(coreBundle.getString("problem.closing.connection"), exception);
            return;
        }
    }
}

