/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic;

import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator$1;
import com.datical.liquibase.ext.storedlogic.AbstractStoredDatabaseLogicSnapshotGenerator$2;
import com.datical.liquibase.ext.storedlogic.databasepackage.PackageBodySnapshotGenerator;
import com.datical.liquibase.ext.storedlogic.databasepackage.PackageSnapshotGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.database.AbstractJdbcDatabase;
import liquibase.database.Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.Db2zDatabase;
import liquibase.database.core.EnterpriseDBDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.datatype.DataTypeFactory;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.license.LicenseServiceUtils;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.jvm.JdbcSnapshotGenerator;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.AbstractDatabaseObject;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Catalog;
import liquibase.structure.core.DataType;
import liquibase.structure.core.Schema;
import liquibase.structure.core.StoredDatabaseLogic;
import liquibase.util.StringUtil;

public abstract class AbstractStoredDatabaseLogicSnapshotGenerator
extends JdbcSnapshotGenerator {
    protected static final String OBJECT_NAME_FIELD = "OBJECT_NAME";
    protected static final String STATUS_FIELD = "STATUS";
    protected static final String OBJECT_BODY_FIELD = "OBJECT_BODY";
    protected static final String OBJECT_ARG_FIELD = "OBJECT_ARG";
    protected static final String ORDER_FIELD = "ORDER";
    protected static final String TYPE_FIELD = "TYPE";
    protected static final String PARAMETER_NAME = "PARAMETER_NAME";
    protected static final String DATA_TYPE = "DATA_TYPE";
    protected static final String DTD_IDENTIFIER = "DTD_IDENTIFIER";
    protected static final String PARAMETER_MODE = "PARAMETER_MODE";
    protected static final String NUMERIC_PRECISION = "NUMERIC_PRECISION";
    protected static final String NUMERIC_SCALE = "NUMERIC_SCALE";
    protected static final String CHAR_LENGTH = "CHAR_LENGTH";
    public static final String USES_QUOTED_IDENTIFIER = "usesQuotedIdentifier";
    private Class<? extends DatabaseObject> localDefaultFor;

    public AbstractStoredDatabaseLogicSnapshotGenerator(Class<? extends DatabaseObject> clazz, Class<? extends DatabaseObject>[] classArray) {
        super(clazz, classArray);
        this.localDefaultFor = clazz;
    }

    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof DB2Database || database instanceof Db2zDatabase || database instanceof SnowflakeDatabase || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            if (!LicenseServiceUtils.isProLicenseValid()) {
                return -1;
            }
            return super.getPriority(clazz, database);
        }
        return -1;
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject databaseObject, DatabaseSnapshot object) {
        if (!this.shouldInclude((StoredDatabaseLogic)databaseObject, (Database)(object = ((DatabaseSnapshot)object).getDatabase()))) {
            return null;
        }
        if (databaseObject.getAttribute("liquibaseComplete", Boolean.FALSE).booleanValue()) {
            databaseObject.setAttribute("liquibaseComplete", null);
            return databaseObject;
        }
        databaseObject = (StoredDatabaseLogic)databaseObject;
        return this.performSnapshotAndBuildStoredObject((Database)object, (StoredDatabaseLogic<?>)databaseObject);
    }

    /*
     * WARNING - void declaration
     */
    protected StoredDatabaseLogic performSnapshotAndBuildStoredObject(Database database, StoredDatabaseLogic<?> storedDatabaseLogic) {
        List<Map<String, ?>> list = this.getSnapshotObjectSql(storedDatabaseLogic, database);
        list = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database).queryForList(new RawSqlStatement((String)((Object)list)));
        list = this.castToListOfMaps(list);
        StringBuilder stringBuilder = new StringBuilder();
        String string = null;
        Boolean bl2 = null;
        for (Map<String, ?> map : list) {
            void object;
            String string2;
            String string3;
            if (string == null) {
                string = (String)map.get(OBJECT_NAME_FIELD);
            }
            if (bl2 == null) {
                bl2 = "VALID".equals(map.get(STATUS_FIELD));
            }
            if ((string3 = (String)map.get(OBJECT_BODY_FIELD)) == null && (string2 = this.getCLRBody(storedDatabaseLogic, database)) == null) {
                return null;
            }
            stringBuilder.append(object.replaceFirst("\\r?\\n$", "")).append("\n");
        }
        stringBuilder = new StringBuilder(StringUtil.trimToEmpty(StringUtil.trimToEmpty(stringBuilder.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"))));
        if (database instanceof MSSQLDatabase && !StringUtil.stripComments((stringBuilder = new StringBuilder(StringUtil.trimToEmpty(stringBuilder.toString()))).toString()).trim().toUpperCase().startsWith("CREATE")) {
            stringBuilder.insert(0, "CREATE ");
        }
        if (database instanceof OracleDatabase) {
            stringBuilder.insert(0, "CREATE OR REPLACE ");
        }
        storedDatabaseLogic = ((StoredDatabaseLogic)((StoredDatabaseLogic)((StoredDatabaseLogic)this.createReturnObject().setSchema(storedDatabaseLogic.getSchema())).setName(string)).setValid(bl2)).setBody(stringBuilder.toString());
        if (!list.isEmpty() && database instanceof MSSQLDatabase) {
            storedDatabaseLogic.setAttribute(USES_QUOTED_IDENTIFIER, list.get(0).get("USES_QUOTED_IDENTIFIER"));
        }
        return storedDatabaseLogic;
    }

    protected boolean shouldInclude(StoredDatabaseLogic storedDatabaseLogic, Database database) {
        return !storedDatabaseLogic.getName().equalsIgnoreCase("datical_compress");
    }

    protected String getCLRBody(StoredDatabaseLogic<?> object, Database database) {
        Map<String, ?> map;
        Object object2 = Scope.getCurrentScope().getLog(this.getClass());
        String string = ((StoredDatabaseLogic)((Object)object)).getName();
        if (((StoredDatabaseLogic)((Object)object)).getSchema() != null) {
            string = ((StoredDatabaseLogic)((Object)object)).getSchema().getName() + "." + string;
        }
        List<Map<String, ?>> list = null;
        Object object3 = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database).queryForList(new RawSqlStatement("SELECT sp.name AS [sp_name], schema_name(sp.schema_id) as schema_name, sp.type as object_type, case when amsp.object_id is null then N'''' else asmblsp.name end AS [AssemblyName], case when amsp.object_id is null then N'''' else amsp.assembly_class end AS [ClassName], case when amsp.object_id is null then N'''' else amsp.assembly_method end AS [MethodName], param.name AS [name], param.parameter_id AS [param_id], sp.object_id AS [object_id], usrt.name AS [data_type], sparam.name AS [data_type_schema], ISNULL(baset.name, N'''') AS [system_type], CAST(CASE WHEN baset.name IN (N'nchar', N'nvarchar') AND param.max_length <> -1 THEN param.max_length/2 ELSE param.max_length END AS int) AS [length], CAST(param.precision AS int) AS [numeric_precision], CAST(param.scale AS int) AS [numeric_scale], param.is_output as [is_output] FROM sys.all_objects AS sp LEFT OUTER JOIN sys.all_parameters AS param ON param.object_id=sp.object_id LEFT OUTER JOIN sys.assembly_modules AS amsp ON amsp.object_id = sp.object_id LEFT OUTER JOIN sys.assemblies AS asmblsp ON asmblsp.assembly_id = amsp.assembly_id LEFT OUTER JOIN sys.procedures AS spp ON spp.object_id = sp.object_id LEFT OUTER JOIN sys.types AS usrt ON usrt.user_type_id = param.user_type_id LEFT OUTER JOIN sys.schemas AS sparam ON sparam.schema_id = usrt.schema_id LEFT OUTER JOIN sys.types AS baset ON (baset.user_type_id = param.system_type_id and baset.user_type_id = baset.system_type_id) WHERE sp.object_id=object_id('" + string + "')"));
        if (object3.size() > 0) {
            Object object4;
            Object object5;
            map = object3.get(0);
            string = "CREATE ";
            String object62 = ((String)map.get("OBJECT_TYPE")).trim();
            if (object62.equals("AF") || object62.equals("FS") || object62.equals("FT") || object62.equals("IF")) {
                string = string + "FUNCTION ";
                if (object62.equals("FT")) {
                    object2 = "SELECT COLUMN_NAME, IS_NULLABLE, DATA_TYPE, CHARACTER_MAXIMUM_LENGTH, NUMERIC_PRECISION FROM INFORMATION_SCHEMA.ROUTINE_COLUMNS WHERE TABLE_NAME = '" + database.escapeStringForDatabase(((StoredDatabaseLogic)((Object)object)).getName()) + "'";
                    if (((StoredDatabaseLogic)((Object)object)).getSchema() != null && ((StoredDatabaseLogic)((Object)object)).getSchema().getName() != null) {
                        object2 = (String)object2 + " AND TABLE_SCHEMA='" + database.escapeStringForDatabase(((StoredDatabaseLogic)((Object)object)).getSchema().getName()) + "'";
                    }
                    list = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database).queryForList(new RawSqlStatement((String)object2));
                }
            } else if (object62.equals("PC")) {
                string = string + "PROCEDURE ";
            } else {
                if (object62.equals("P")) {
                    object2.warning("Cannot read encrypted procedure body for '" + ((StoredDatabaseLogic)((Object)object)).getName() + "'");
                    return null;
                }
                object2.warning("Unknown CLR procedure type: ".concat(String.valueOf(object62)));
                return null;
            }
            string = string + this.alwaysQuoteDatabaseObject(null, (String)map.get("SCHEMA_NAME"), (String)map.get("SP_NAME"), StoredDatabaseLogic.class, database) + " (";
            object2 = null;
            object = new ArrayList<Map>();
            object3 = object3.iterator();
            while (object3.hasNext()) {
                Map map2 = (Map)object3.next();
                if (StringUtil.trimToNull((String)map2.get("NAME")) == null) {
                    object2 = map2;
                } else {
                    object.add(map2);
                }
                object5 = new DataType((String)map2.get(DATA_TYPE));
                ((DataType)object5).setColumnSize((Integer)map2.get("LENGTH"));
                ((DataType)object5).setDecimalDigits((Integer)map2.get("SCALE"));
                object4 = DataTypeFactory.getInstance().from((DataType)object5, database).toDatabaseDataType(database).toSql();
                if (((String)object4).equalsIgnoreCase("NVARCHAR(-1)")) {
                    object4 = "NVARCHAR(MAX)";
                }
                map2.put("FINAL_DATA_TYPE", object4);
            }
            string = string + StringUtil.join(object, ", ", (StringUtil.StringUtilFormatter)new AbstractStoredDatabaseLogicSnapshotGenerator$1(this));
            string = string + ")";
            if (object2 != null) {
                string = string + " RETURNS " + object2.get(DATA_TYPE);
            } else if (list != null) {
                for (Map<String, ?> map3 : list) {
                    object4 = new DataType(database.escapeDataTypeName((String)map3.get(DATA_TYPE)));
                    ((DataType)object4).setColumnSize((Integer)map3.get("CHARACTER_MAXIMUM_LENGTH"));
                    object5 = (Number)map3.get(NUMERIC_PRECISION);
                    if (object5 != null) {
                        ((DataType)object4).setDecimalDigits(((Number)object5).intValue());
                    }
                    if (((String)(object4 = DataTypeFactory.getInstance().from((DataType)object4, database).toDatabaseDataType(database).toSql())).equalsIgnoreCase("NVARCHAR(-1)")) {
                        object4 = "NVARCHAR(MAX)";
                    }
                    map3.put("FINAL_DATA_TYPE", object4);
                }
                string = string + " RETURNS TABLE (" + StringUtil.join(list, ", ", (StringUtil.StringUtilFormatter)new AbstractStoredDatabaseLogicSnapshotGenerator$2(this, database)) + ")";
            }
        } else {
            object2.severe("Omitting " + this.getObjectType(database).toLowerCase() + " '" + ((StoredDatabaseLogic)((Object)object)).getName() + "': OBJECT_BODY is null. Null OBJECT_BODY values are often due to permission issues");
            return null;
        }
        string = string + " AS EXTERNAL NAME " + this.alwaysQuoteDatabaseObject((String)map.get("ASSEMBLYNAME"), (String)map.get("CLASSNAME"), (String)map.get("METHODNAME"), StoredDatabaseLogic.class, database);
        return string;
    }

    protected List<Map<String, ?>> castToListOfMaps(Object object) {
        return (List)object;
    }

    protected String getSnapshotObjectSql(StoredDatabaseLogic<?> storedDatabaseLogic, Database database) {
        int n2 = 0;
        try {
            n2 = database.getDatabaseMajorVersion();
        }
        catch (DatabaseException databaseException) {}
        if (database instanceof OracleDatabase || n2 >= 10 && database instanceof DB2Database) {
            String string = "select OBJECT_NAME, STATUS, TEXT AS OBJECT_BODY from ALL_OBJECTS left outer join ALL_SOURCE on object_name=name and object_type=type and all_source." + (database instanceof DB2Database ? "schema" : "owner") + "=all_objects." + (database instanceof OracleDatabase ? "owner " : "object_schema ") + "where object_type='" + this.getObjectType(database) + "' and object_name='" + database.correctObjectName(storedDatabaseLogic.getName(), StoredDatabaseLogic.class) + "' and all_objects." + (database instanceof DB2Database ? "object_schema" : "owner") + "='" + database.correctObjectName(storedDatabaseLogic.getSchema().getCatalogName(), Catalog.class) + "'";
            if (database instanceof OracleDatabase) {
                string = string + " order by ALL_SOURCE.LINE";
            }
            return string;
        }
        if (database instanceof DB2Database) {
            String string = this.getObjectType(database).toLowerCase();
            if (string.equals("function")) {
                string = "F";
            } else if (string.equals("procedure")) {
                string = "P";
            } else {
                throw new UnexpectedLiquibaseException("Unknown type: ".concat(String.valueOf(string)));
            }
            return "select routinename from syscat.routines where routinetype = '" + string + "' and routineschema='" + database.correctObjectName(storedDatabaseLogic.getSchema().getCatalogName(), Catalog.class) + "'";
        }
        if (database instanceof MSSQLDatabase) {
            String string = storedDatabaseLogic.getName();
            if (storedDatabaseLogic.getSchema() != null) {
                string = storedDatabaseLogic.getSchema().getName() + "." + string;
            }
            return "select ROUTINE_CATALOG AS OBJECT_CATALOG, ROUTINE_SCHEMA AS OBJECT_SCHEMA, ROUTINE_NAME AS OBJECT_NAME, sql_modules.definition AS OBJECT_BODY, 'VALID' as STATUS, uses_quoted_identifier FROM " + database.escapeTableName(storedDatabaseLogic.getSchema().getCatalogName(), "information_schema", "routines") + " LEFT OUTER JOIN sys.sql_modules on object_id=object_id('" + string + "') where routine_type = '" + this.getObjectType(database) + "' AND ROUTINE_SCHEMA='" + storedDatabaseLogic.getSchema().getName() + "' ";
        }
        if (database instanceof EnterpriseDBDatabase) {
            return "select OBJECT_NAME, STATUS, ALL_SOURCE.TEXT AS OBJECT_BODY from ALL_OBJECTS left outer join ALL_SOURCE on object_name=name and object_type=type and all_source.owner=all_objects.owner where object_type='" + this.getObjectType(database) + "' and object_name='" + database.correctObjectName(storedDatabaseLogic.getName(), StoredDatabaseLogic.class) + "' and all_objects.schema_name ='" + database.correctObjectName(storedDatabaseLogic.getSchema().getName().toUpperCase(), Catalog.class) + "'";
        }
        throw new UnexpectedLiquibaseException("Unsupported database type: " + database.getShortName());
    }

    protected String getAddToSql(Schema schema, Database database) {
        if (database instanceof OracleDatabase) {
            return "select OBJECT_NAME, STATUS, TEXT AS OBJECT_BODY from ALL_OBJECTS left outer join ALL_SOURCE on object_name=name and object_type=type and all_source.owner=all_objects.owner where object_type='" + this.getObjectType(database) + "' and all_objects.owner='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "' order by ALL_SOURCE.LINE";
        }
        if (database instanceof DB2Database) {
            try {
                if (database.getDatabaseMajorVersion() >= 10) {
                    return "select object_name from all_objects where object_type='" + this.getObjectType(database) + "' and object_schema='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "'";
                }
            }
            catch (DatabaseException databaseException) {}
            String string = this.getObjectType(database).toLowerCase();
            if (string.equals("function")) {
                string = "F";
            } else if (string.equals("procedure")) {
                string = "P";
            } else {
                throw new UnexpectedLiquibaseException("Unknown type: ".concat(String.valueOf(string)));
            }
            return "select routinename from syscat.routines where routinetype = '" + string + "' and routine_schema='" + database.correctObjectName(schema.getCatalogName(), Catalog.class) + "'";
        }
        if (database instanceof MySQLDatabase) {
            return "select ROUTINE_NAME AS OBJECT_NAME FROM information_schema.routines where routine_type = '" + this.getObjectType(database) + "' AND ROUTINE_SCHEMA='" + schema.getCatalogName() + "' ";
        }
        if (database instanceof MSSQLDatabase) {
            return "select ROUTINE_CATALOG AS OBJECT_CATALOG, ROUTINE_SCHEMA AS OBJECT_SCHEMA, ROUTINE_NAME AS OBJECT_NAME, sql_modules.definition AS OBJECT_BODY, 'VALID' as STATUS, uses_quoted_identifier FROM " + database.escapeTableName(schema.getCatalogName(), "INFORMATION_SCHEMA", "ROUTINES") + " LEFT OUTER JOIN sys.sql_modules on object_name(object_id)=SPECIFIC_NAME AND object_schema_name(object_id)=SPECIFIC_SCHEMA where routine_type = '" + this.getObjectType(database) + "' AND ROUTINE_SCHEMA='" + schema.getName() + "'";
        }
        if (database instanceof EnterpriseDBDatabase) {
            return "select OBJECT_NAME, STATUS from ALL_OBJECTS left outer join ALL_SOURCE on object_name=name and object_type=type and all_source.owner=all_objects.owner where object_type='" + this.getObjectType(database) + "' and all_objects.schema_name='" + schema.getName().toUpperCase() + "' order by ALL_SOURCE.LINE";
        }
        throw new UnexpectedLiquibaseException("Unsupported database type: " + database.getShortName() + " for " + this.getClass().getName());
    }

    protected abstract String getObjectType(Database var1);

    protected abstract StoredDatabaseLogic<?> createReturnObject();

    @Override
    protected void addTo(DatabaseObject databaseObject, DatabaseSnapshot iterator) {
        if (databaseObject instanceof Schema) {
            databaseObject = (Schema)databaseObject;
            Database database = ((DatabaseSnapshot)((Object)iterator)).getDatabase();
            Iterator iterator2 = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
            iterator = this.queryForList((DatabaseSnapshot)((Object)iterator), (Schema)databaseObject, (Executor)((Object)iterator2));
            if (database instanceof OracleDatabase || database instanceof MSSQLDatabase) {
                iterator2 = new HashMap();
                Boolean bl2 = null;
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    Object object = (Map)iterator.next();
                    String string = (String)object.get(OBJECT_NAME_FIELD);
                    if (bl2 == null) {
                        bl2 = object.get(STATUS_FIELD).equals("VALID");
                    }
                    String string2 = (String)object.get(OBJECT_BODY_FIELD);
                    StoredDatabaseLogic storedDatabaseLogic = (StoredDatabaseLogic)iterator2.get(string);
                    if (storedDatabaseLogic == null) {
                        storedDatabaseLogic = ((StoredDatabaseLogic)((StoredDatabaseLogic)((StoredDatabaseLogic)this.createReturnObject().setSchema((Schema)databaseObject)).setName(string)).setValid(bl2)).setBody(string2);
                        if (database instanceof MSSQLDatabase) {
                            storedDatabaseLogic.setAttribute(USES_QUOTED_IDENTIFIER, object.get("USES_QUOTED_IDENTIFIER"));
                        }
                        iterator2.put(string, storedDatabaseLogic);
                        continue;
                    }
                    storedDatabaseLogic.setBody(storedDatabaseLogic.getBody() + string2.replaceFirst("\\r?\\n$", "") + "\n");
                }
                for (Object object : iterator2.values()) {
                    if (StringUtil.trimToNull(((StoredDatabaseLogic)object).getBody()) != null) {
                        if (database instanceof OracleDatabase || database instanceof EnterpriseDBDatabase) {
                            ((StoredDatabaseLogic)object).setBody("CREATE OR REPLACE " + StringUtil.trimToEmpty(StringUtil.trimToEmpty(((StoredDatabaseLogic)object).getBody().replaceAll("\r\n", "\n").replaceAll("\r", "\n"))));
                        } else if (database instanceof MSSQLDatabase && !StringUtil.stripComments(((StoredDatabaseLogic)object).getBody()).trim().toUpperCase().startsWith("CREATE")) {
                            ((StoredDatabaseLogic)object).setBody("CREATE " + StringUtil.trimToEmpty(((StoredDatabaseLogic)object).getBody()));
                        }
                        ((AbstractDatabaseObject)object).setAttribute("liquibaseComplete", Boolean.TRUE);
                    }
                    ((Schema)databaseObject).addDatabaseObject((DatabaseObject)object);
                }
                return;
            }
            iterator2 = iterator.iterator();
            while (iterator2.hasNext()) {
                Map map = (Map)iterator2.next();
                iterator = ((StoredDatabaseLogic)this.createReturnObject().setName((String)map.get(OBJECT_NAME_FIELD))).setSchema((Schema)databaseObject);
                if (database.isSystemObject((DatabaseObject)((Object)iterator))) continue;
                ((Schema)databaseObject).addDatabaseObject((DatabaseObject)((Object)iterator));
            }
        }
    }

    protected List<Map<String, ?>> queryForList(DatabaseSnapshot databaseSnapshot, Schema schema, Executor executor) {
        try {
            return executor.queryForList(new RawSqlStatement(this.getAddToSql(schema, databaseSnapshot.getDatabase())));
        }
        catch (DatabaseException databaseException) {
            if (databaseSnapshot.getDatabase() instanceof DB2Database && (this instanceof PackageSnapshotGenerator || this instanceof PackageBodySnapshotGenerator)) {
                Scope.getCurrentScope().getLog(this.getClass()).info("Error querying PACKAGE and/or PACKAGE BODY. Assuming Oracle compatibility not enabled: " + databaseException.getMessage());
                return new ArrayList();
            }
            throw databaseException;
        }
    }

    protected String alwaysQuoteDatabaseObject(String string, String string2, String string3, Class<? extends DatabaseObject> clazz, Database database) {
        if (string3 == null) {
            return null;
        }
        if (!(database instanceof AbstractJdbcDatabase)) {
            return database.escapeObjectName(string, string2, string3, clazz);
        }
        string3 = ((AbstractJdbcDatabase)database).quoteObject(string3, clazz);
        if (string2 == null) {
            return string3;
        }
        string3 = ((AbstractJdbcDatabase)database).quoteObject(string2, Schema.class) + "." + string3;
        if (string == null) {
            return string3;
        }
        return ((AbstractJdbcDatabase)database).quoteObject(string, Catalog.class) + "." + string3;
    }
}

