/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.datical.liquibase.ext.tools.PsqlRunner;
import java.util.List;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class PsqlExecutor
extends AbstractNativeToolExecutor {
    public PsqlExecutor() {
        super("psql");
    }

    @Override
    public String getName() {
        return "psql";
    }

    @Override
    public int getPriority() {
        return 101;
    }

    @Override
    public void execute(SqlStatement object, List<SqlVisitor> object2) {
        object2 = Scope.getCurrentScope().getLog(this.getClass());
        object2.info("Executing with the '" + this.getName() + "' executor");
        object = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)object, this.database);
        try {
            new PsqlRunner(this.changeSet, null).executeCommand(this.database);
            object2.info("Successfully validated psql");
            new PsqlRunner(this.changeSet, (Sql[])object).executeCommand(this.database);
            object = String.format("Success! Changeset '%s' by '%s' deployed by psql", this.changeSet.getId(), this.changeSet.getAuthor());
            object2.info((String)object);
            return;
        }
        catch (Exception exception) {
            object = String.format("%nChangeset '%s' by '%s' failed to deploy with 'psql'. Please check psql logs or use the --log-level flag for more information.", this.changeSet.getId(), this.changeSet.getAuthor());
            object2.warning((String)object);
            throw new DatabaseException(exception);
        }
    }
}

