/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.config.PsqlConfiguration;
import com.datical.liquibase.ext.config.PsqlConfiguration$ConfigurationKeys;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.tools.NativeToolFileCreator$FileTypeEnum;
import com.datical.liquibase.ext.util.NativeRunnerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.InputStreamList;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class PsqlRunner
extends ExecuteShellCommandChange {
    private ChangeSet changeSet;
    private Sql[] sqlStrings;
    private File outFile = null;
    private Boolean keepTempFile;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private String logFile;
    private static final String EXECUTABLE_NAME = "psql";

    public PsqlRunner() {
    }

    public PsqlRunner(ChangeSet changeSet, Sql[] sqlArray) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setTimeout("1800");
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    @Override
    protected List<String> createFinalCommandArray(Database object) {
        this.loadPsqlProperties();
        List<String> list = super.createFinalCommandArray((Database)object);
        try {
            this.writeSqlStrings();
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException(exception);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = PsqlConfiguration.TEMP_KEEP.getCurrentValue();
        }
        if (!this.args.isEmpty()) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        String string = this.buildConnectionString((Database)object);
        list.add("--dbname");
        list.add(string);
        list.add("-v");
        list.add("ON_ERROR_STOP=1");
        if (this.outFile != null) {
            list.add("--file");
            list.add(this.outFile.getAbsolutePath());
        } else {
            list.add("--version");
        }
        string = StringUtil.join(list, " ");
        object = String.format("%s:%s", this.getUserName(object.getConnection()), this.getPassword(object.getConnection()));
        Scope.getCurrentScope().getLog(this.getClass()).info("psql command:\n" + string.replaceAll((String)object, "*****:*****"));
        return list;
    }

    @Override
    protected void processResult(int n2, String string, String string2, Database database) {
        if (this.logFile != null && this.outFile != null) {
            try {
                if (!string2.isEmpty()) {
                    Files.write(Paths.get(this.logFile, new String[0]), string2.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
                if (!string.isEmpty()) {
                    Files.write(Paths.get(this.logFile, new String[0]), string.getBytes(), StandardOpenOption.CREATE, StandardOpenOption.APPEND);
                }
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException(iOException);
            }
        }
        if (n2 != 0 && !StringUtil.isEmpty(string2)) {
            String string3 = this.getCommandString() + " returned a code of " + n2 + "\n" + string2;
            throw new UnexpectedLiquibaseException(string3);
        }
        super.processResult(n2, string, string2, database);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void executeCommand(Database object) {
        try {
            this.finalCommandArray = this.createFinalCommandArray((Database)object);
            super.executeCommand((Database)object);
            if (this.outFile == null || !this.outFile.exists() || this.keepTempFile == null || !this.keepTempFile.booleanValue()) return;
            Scope.getCurrentScope().getLog(this.getClass()).info("Psql run script can be located at: " + this.outFile.getAbsolutePath());
            return;
        }
        catch (TimeoutException timeoutException) {
            try {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                this.processResult(0, null, null, (Database)object);
                object = timeoutException.getMessage() + System.lineSeparator() + "Error: The psql executable failed to return a response with the configured timeout. Please check liquibase.psql.timeout specified in liquibase.psql.conf file, the LIQUIBASE_PSQL_TIMEOUT environment variable, or other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html" + System.lineSeparator();
                Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
                Scope.getCurrentScope().getLog(PsqlRunner.class).warning((String)object);
                throw new LiquibaseException(timeoutException);
                catch (Exception exception) {
                    throw new LiquibaseException(exception);
                }
            }
            catch (Throwable throwable) {
                if (this.outFile == null || !this.outFile.exists() || this.keepTempFile == null || !this.keepTempFile.booleanValue()) throw throwable;
                Scope.getCurrentScope().getLog(this.getClass()).info("Psql run script can be located at: " + this.outFile.getAbsolutePath());
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPsqlProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable(EXECUTABLE_NAME));
        File file = null;
        Properties properties = new Properties();
        Object object = PsqlConfiguration.PATH.getCurrentValue();
        if (object != null) {
            file = new File((String)object);
        }
        object = PsqlConfiguration.TIMEOUT.getCurrentValue();
        String string = PsqlConfiguration.ARGS.getCurrentValue();
        this.assignPropertiesFromConfiguration();
        Object object2 = Scope.getCurrentScope().getResourceAccessor();
        InputStream inputStream = null;
        try {
            object2 = object2.openStreams(null, "liquibase.psql.conf");
            Throwable throwable = null;
            try {
                if (object2 == null || ((InputStreamList)object2).size() == 0) {
                    Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named 'liquibase.psql.conf' found.");
                } else {
                    String string2 = ((InputStreamList)object2).getURIs().get(0).getRawPath();
                    Scope.getCurrentScope().getLog(this.getClass()).info("psql configuration file located at '" + string2 + "'.");
                    inputStream = ((InputStreamList)object2).iterator().next();
                    properties.load(inputStream);
                    if (properties.containsKey("liquibase.psql.path")) {
                        file = new File(properties.getProperty("liquibase.psql.path"));
                    }
                    if (properties.containsKey("liquibase.psql.timeout")) {
                        object = this.determineTimeout(properties);
                    }
                    if (properties.containsKey("liquibase.psql.args")) {
                        string = properties.getProperty("liquibase.psql.args");
                    }
                    this.overrideWithFileProperties(properties);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((InputStreamList)object2).close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        ((InputStreamList)object2).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw new UnexpectedLiquibaseException(iOException);
            }
            catch (Throwable throwable5) {
                try {
                    if (inputStream == null) throw throwable5;
                    inputStream.close();
                    throw throwable5;
                }
                catch (Exception exception) {}
                throw throwable5;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        this.handlePsqlExecutable(file);
        this.handleTimeout((Integer)object);
        this.handleArgs(string);
        this.logProperties();
    }

    private int determineTimeout(Properties object) {
        if ((object = ((Properties)object).getProperty("liquibase.psql.timeout")) == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for property 'liquibase.psql.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com");
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'psql' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'psql' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'psql' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'psql' with a log file value of '" + this.logFile + "'");
        }
    }

    private void handleArgs(String string) {
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'psql' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim(string, " ");
        }
    }

    private void handleTimeout(Integer n2) {
        if (n2 != null) {
            NativeRunnerUtil.validateTimeout(n2);
            this.setTimeout(String.valueOf(n2));
            Scope.getCurrentScope().getLog(this.getClass()).info("Executing 'psql' with a timeout of '" + n2 + "'");
        }
    }

    private void handlePsqlExecutable(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            throw new UnexpectedLiquibaseException("The executable for the native executor 'psql' cannot be found at path '" + file.getAbsolutePath() + "' as specified in the liquibase.psql.conf file, the LIQUIBASE_PSQL_* environment variables, or other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html.");
        }
        if (!file.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'psql' executable in the liquibase.psql.conf file at " + file.getAbsolutePath() + " cannot be executed");
        }
        try {
            this.setExecutable(file.getCanonicalPath());
            Scope.getCurrentScope().getLog(this.getClass()).info("Using the 'psql' executable located at:  '" + file.getCanonicalPath() + "'");
            return;
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException);
        }
    }

    private void overrideWithFileProperties(Properties properties) {
        if (properties.containsKey("liquibase.psql.keep.temp")) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties(properties, "liquibase.psql.keep.temp");
        }
        if (properties.containsKey(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(PsqlConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(PsqlConfiguration$ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(PsqlConfiguration$ConfigurationKeys.getFullKey("logFile"));
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.tempName = PsqlConfiguration.TEMP_NAME.getCurrentValue();
        this.tempPath = PsqlConfiguration.TEMP_PATH.getCurrentValue();
        this.logFile = PsqlConfiguration.LOG_FILE.getCurrentValue();
        if (!PsqlConfiguration.TEMP_KEEP.getCurrentConfiguredValue().wasDefaultValueUsed()) {
            this.keepTempFile = PsqlConfiguration.TEMP_KEEP.getCurrentValue();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSqlStrings() {
        Object object;
        block13: {
            if (this.sqlStrings == null) return;
            if (this.sqlStrings.length == 0) {
                return;
            }
            Scope.getCurrentScope().getLog(this.getClass()).info("Creating the SQL run script");
            object = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, true, this.keepTempFile == null ? PsqlConfiguration.TEMP_KEEP.getDefaultValue().booleanValue() : this.keepTempFile.booleanValue());
            try {
                this.outFile = ((NativeToolFileCreator)object).generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.sql);
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException(iOException);
            }
            object = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
            Throwable throwable = null;
            try {
                Sql[] sqlArray = this.sqlStrings;
                int n2 = this.sqlStrings.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    String string = sqlArray[i2].toSql().replace("\r", "");
                    ((Writer)object).write(string);
                }
                ((Writer)object).write(";\n");
                if (object == null) return;
                if (throwable == null) break block13;
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable4 = throwable2;
                    throwable = throwable2;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    if (object == null) throw throwable5;
                    if (throwable == null) {
                        ((BufferedWriter)object).close();
                        throw throwable5;
                    }
                    try {
                        ((BufferedWriter)object).close();
                        throw throwable5;
                    }
                    catch (Throwable throwable6) {
                        throwable.addSuppressed(throwable6);
                        throw throwable5;
                    }
                }
            }
            try {
                ((BufferedWriter)object).close();
                return;
            }
            catch (Throwable throwable2) {
                throwable.addSuppressed(throwable2);
                return;
            }
        }
        ((BufferedWriter)object).close();
    }

    protected String buildConnectionString(Database object) {
        if (object == null) {
            return null;
        }
        object = object.getConnection();
        String string = this.getUserName((DatabaseConnection)object);
        String string2 = this.getPassword((DatabaseConnection)object);
        object = Pattern.compile(".*postgresql://(.*?):(\\d+)/([^?]+).*").matcher(object.getURL());
        if (!((Matcher)object).matches()) {
            throw new UnexpectedLiquibaseException("Could not determine proper postgres connection url.");
        }
        String string3 = ((Matcher)object).group(1);
        String string4 = ((Matcher)object).group(2);
        object = ((Matcher)object).group(3);
        return String.format("postgresql://%s:%s@%s:%s/%s", string, string2, string3, string4, object);
    }

    private String getUserName(DatabaseConnection databaseConnection) {
        String string = null;
        if (databaseConnection instanceof ProJdbcConnection) {
            string = ((ProJdbcConnection)databaseConnection).getUsername();
        }
        if (string == null) {
            string = databaseConnection.getConnectionUserName();
        }
        return StringUtil.trimToEmpty(string);
    }

    private String getPassword(DatabaseConnection databaseConnection) {
        String string = null;
        if (databaseConnection instanceof ProJdbcConnection) {
            string = ((ProJdbcConnection)databaseConnection).getPassword();
        }
        return StringUtil.trimToEmpty(string);
    }
}

