/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import liquibase.Scope;
import liquibase.database.Database;
import liquibase.database.OfflineConnection;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.statement.core.RawSqlStatement;
import liquibase.structure.core.Schema;

public class DatabaseUtils {
    public static void initializeDatabase(String defaultCatalogName, String defaultSchemaName, Database database) throws DatabaseException {
        if (!(defaultCatalogName == null && defaultSchemaName == null || database.getConnection() instanceof OfflineConnection)) {
            Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", database);
            if (database instanceof OracleDatabase) {
                String schema = defaultCatalogName;
                if (schema == null) {
                    schema = defaultSchemaName;
                }
                executor.execute(new RawSqlStatement("ALTER SESSION SET CURRENT_SCHEMA=" + database.escapeObjectName(schema, Schema.class)));
            } else if (database instanceof PostgresDatabase && defaultSchemaName != null) {
                String searchPath = executor.queryForObject(new RawSqlStatement("SHOW SEARCH_PATH"), String.class);
                if (!(searchPath.equals(defaultCatalogName) || searchPath.startsWith(defaultSchemaName + ",") || searchPath.startsWith("\"" + defaultSchemaName + "\","))) {
                    if (database instanceof CockroachDatabase) {
                        searchPath = searchPath.replaceAll("(\\$\\w+)", "'$1'");
                    }
                    executor.execute(new RawSqlStatement("SET SEARCH_PATH TO " + database.escapeObjectName(defaultSchemaName, Schema.class) + ", " + searchPath));
                }
            } else if (database instanceof AbstractDb2Database) {
                String schema = defaultCatalogName;
                if (schema == null) {
                    schema = defaultSchemaName;
                }
                executor.execute(new RawSqlStatement("SET CURRENT SCHEMA " + schema));
            } else if (database instanceof MySQLDatabase) {
                String schema = defaultCatalogName;
                if (schema == null) {
                    schema = defaultSchemaName;
                }
                executor.execute(new RawSqlStatement("USE " + schema));
            } else if (database instanceof MSSQLDatabase) {
                executor.execute(new RawSqlStatement("USE " + defaultCatalogName));
            }
        }
    }
}

