/*
 * Decompiled with CFR 0.152.
 */
package liquibase.resource;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import liquibase.resource.AbstractResourceAccessor;
import liquibase.resource.InputStreamList;
import liquibase.resource.ResourceAccessor;

public class CompositeResourceAccessor
extends AbstractResourceAccessor {
    private List<ResourceAccessor> resourceAccessors;

    public CompositeResourceAccessor(ResourceAccessor ... resourceAccessors) {
        this.resourceAccessors = new ArrayList<ResourceAccessor>();
        this.resourceAccessors.addAll(Arrays.asList(resourceAccessors));
    }

    public CompositeResourceAccessor(Collection<ResourceAccessor> resourceAccessors) {
        this.resourceAccessors = new ArrayList<ResourceAccessor>(resourceAccessors);
    }

    public CompositeResourceAccessor addResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessors.add(resourceAccessor);
        return this;
    }

    public void removeResourceAccessor(ResourceAccessor resourceAccessor) {
        this.resourceAccessors.remove(resourceAccessor);
    }

    @Override
    public InputStreamList openStreams(String relativeTo, String streamPath) throws IOException {
        InputStreamList returnList = new InputStreamList();
        for (ResourceAccessor accessor : this.resourceAccessors) {
            returnList.addAll(accessor.openStreams(relativeTo, streamPath));
        }
        return returnList;
    }

    @Override
    public SortedSet<String> list(String relativeTo, String path, boolean recursive, boolean includeFiles, boolean includeDirectories) throws IOException {
        TreeSet<String> returnSet = new TreeSet<String>();
        for (ResourceAccessor accessor : this.resourceAccessors) {
            SortedSet<String> list = accessor.list(relativeTo, path, recursive, includeFiles, includeDirectories);
            if (list == null) continue;
            returnSet.addAll(list);
        }
        return returnSet;
    }

    @Override
    public SortedSet<String> describeLocations() {
        TreeSet<String> returnSet = new TreeSet<String>();
        for (ResourceAccessor accessor : this.resourceAccessors) {
            returnSet.addAll(accessor.describeLocations());
        }
        return returnSet;
    }
}

