/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SingleChangeSetFilter;
import com.datical.liquibase.ext.command.RollbackOneChangeSetCommand$1;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandResult;
import liquibase.command.CommandValidationErrors;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubUpdater;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.Operation;
import liquibase.license.LicenseServiceFactory;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.resource.InputStreamList;
import liquibase.util.StreamUtil;

public class RollbackOneChangeSetCommand
extends AbstractSelfConfiguratingCommand {
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    private Database database;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private String changeLogFilePath;
    private Writer outputWriter;
    private Liquibase liquibase;
    private Boolean force;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private boolean ignoreClasspathPrefix;
    private String rollbackScript;
    private ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private DatabaseChangeLog changeLog;

    @Override
    public int getPriority(String string) {
        if (!Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService().licenseIsValid("Liquibase Pro")) {
            return -1;
        }
        return super.getPriority(string);
    }

    @Override
    public String getName() {
        return "rollbackOneChangeSet";
    }

    @Override
    public CommandValidationErrors validate() {
        return new CommandValidationErrors(this);
    }

    public void configure(Map object) {
        if (object.containsKey("help")) {
            if (object.containsKey("outputWriter")) {
                System.out.println("liquibase <global parameters> rollbackOneChangeSetSQL --changeSetId=<id> --changeSetAuthor=<author> --changeSetPath=<filepath> [--rollbackScript=<path/to/SQLscript>] --force\n\nrollbackOneChangeSetSQL          Displays the SQL which will be executed when the corresponding rollbackOneChangeSet command is executed, and does\n                                 not perform the actual rollback. (Liquibase Pro key required)\n\n  REQUIRED GLOBAL PARAMETERS\n    --changeLogFile          is the root changelog - liquibase will check it and any of its nested \n                                 changelogs for the definitions of the changeSets to roll back\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database passwor     */d\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    --changeSetId            is the changeset id from the changelog\n    --changeSetAuthor        is the name of the author for the changeset id\n    --changeSetPath          is the path to the changelog containing the changeset to be rolled back\n");
            } else {
                System.out.println("liquibase <global parameters> rollbackOneChangeSet --changeSetId=<id> --changeSetAuthor=<author> --changeSetPath=<filepath> [--rollbackScript=<path/to/SQLscript>] --force\n\nrollbackOneChangeset          Rolls back one specific changeset, without rolling back changesets deployed before or afterwards. (Liquibase Pro key required)\n\n  REQUIRED GLOBAL PARAMETERS\n    --changeLogFile          is the root changelog - liquibase will check it and any of its nested \n                                 changelogs for the definitions of the changeSets to roll back\n    --url                    is the JDBC database connection URL\n    --username               is the database username\n    --password               is the database password\n    --liquibaseProLicenseKey is the Liquibase Pro license key to use\n  COMMAND PARAMETERS\n    --changeSetId            is the changeset id from the changelog\n    --changeSetAuthor        is the name of the author for the changeset id\n    --changeSetPath          is the path to the changelog containing the changeset to be rolled back\n    --force                  is required to make sure you intended to run this operation\n    [--rollbackScript]       is the path to the script to use to perform tbe rollback\n                                 This option is only needed if the rollback is not already defined in\n                                 the changelog, and if it is not a rollback that is automatically\n                                 provided by liquibase.");
            }
            System.exit(0);
        }
        this.changeSetId = (String)object.get("changeSetId");
        this.changeSetAuthor = (String)object.get("changeSetAuthor");
        this.changeSetPath = (String)object.get("changeSetPath");
        this.rollbackScript = (String)object.get("rollbackScript");
        this.database = (Database)object.get("database");
        this.changeLog = (DatabaseChangeLog)object.get("changeLog");
        this.changeLogFilePath = (String)object.get("changeLogFile");
        this.changeLogParameters = (ChangeLogParameters)object.get("changeLogParameters");
        if (this.changeSetId == null || this.changeSetAuthor == null || this.changeSetPath == null) {
            throw new LiquibaseException(String.format(coreBundle.getString("id.author.path.required"), new Object[0]));
        }
        this.force = (Boolean)object.get("force");
        if (this.force == null || !this.force.booleanValue()) {
            object = "\nWARNING: Targeted rollback of this changeset may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollbackOneChangeSetSQL'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(String.format((String)object, new Object[0]));
        }
        this.liquibase = (Liquibase)object.get("liquibase");
        this.outputWriter = (Writer)object.get("outputWriter");
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run(new RollbackOneChangeSetCommand$1(this), new RuntimeEnvironment(this.database, contexts, labelExpression));
    }

    @Override
    protected CommandResult run() {
        Object object;
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        Executor executor = null;
        if (this.outputWriter != null) {
            executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
            object = new LoggingExecutor(executor, this.outputWriter, this.database);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, (Executor)object);
            Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, (Executor)object);
        } else {
            object = new LoggingExecutor(null, null, this.database);
        }
        Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("logging", this.database, (Executor)object);
        Operation operation = null;
        HubUpdater hubUpdater = new HubUpdater(new Date(), this.changeLog, this.database);
        BufferedLogService bufferedLogService = new BufferedLogService();
        SingleChangeSetFilter singleChangeSetFilter = null;
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, this.changeLog, this.contexts, this.labelExpression);
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            Object object2 = this.database.getRanChangeSetList();
            singleChangeSetFilter = new SingleChangeSetFilter(this.changeSetId, this.changeSetAuthor, this.changeSetPath, (List<RanChangeSet>)object2, this.changeLog);
            if (singleChangeSetFilter.isEmpty()) {
                String string = "rollbackOneChangeSet";
                if (this.outputWriter != null) {
                    string = "rollbackOneChangeSetSQL";
                }
                object = this.changeSetPath + "::" + this.changeSetId + "::" + this.changeSetAuthor;
                object = "\n\nWARNING:  The command '" + string + "' failed because the targeted change set\n'" + (String)object + "' cannot be located.\nAt least one supplied parameter cannot be found in combination with the other parameters.\nPlease check your details and try again.\n";
                if (singleChangeSetFilter.getMatchingIdChangeSet() != null) {
                    object = (String)object + "\nNOTE:  A change set with this ID was located.\n";
                }
                object = (String)object + "No rollback was performed.";
                throw new LiquibaseException((String)object);
            }
            object = this.getChangeSetString(singleChangeSetFilter.getMatchingChangeSet());
            this.liquibase.outputHeader("Rollback changeset '" + (String)object + "'");
            ChangeLogIterator changeLogIterator = this.createChangeLogIterator((List<RanChangeSet>)object2, singleChangeSetFilter);
            object = this.outputWriter == null ? this.liquibase.getConnection(this.changeLog) : null;
            if (object != null) {
                operation = hubUpdater.preUpdateHub("ROLLBACK", this.database, (Connection)object, this.changeLogFilePath, this.contexts, this.labelExpression, changeLogIterator);
                if (this.changeExecListener != null) {
                    throw new RuntimeException("ChangeExecListener already defined");
                }
                this.changeExecListener = new HubChangeExecListener(operation);
            }
            object2 = this.createChangeLogIterator((List<RanChangeSet>)object2, singleChangeSetFilter);
            object = new CompositeLogService(true, bufferedLogService);
            if (this.rollbackScript == null) {
                Scope.child(Scope.Attr.logService.name(), object, () -> this.lambda$run$0((ChangeLogIterator)object2));
            } else {
                object = singleChangeSetFilter.getMatchingChangeSet();
                RollbackOneChangeSetCommand rollbackOneChangeSetCommand = this;
                rollbackOneChangeSetCommand.executeRollbackScript(rollbackOneChangeSetCommand.rollbackScript, (ChangeSet)object, this.contexts, this.labelExpression);
                this.removeRunStatus((ChangeLogIterator)object2, this.contexts, this.labelExpression);
                logger.info("Executed rollback script " + this.rollbackScript);
            }
            hubUpdater.postUpdateHub(operation, bufferedLogService);
        }
        catch (LiquibaseException liquibaseException) {
            hubUpdater.postUpdateHubExceptionHandling(operation, bufferedLogService, liquibaseException.getMessage());
            object = singleChangeSetFilter != null && !singleChangeSetFilter.isEmpty() ? this.getChangeSetString(singleChangeSetFilter.getMatchingChangeSet()) : this.changeSetPath + "::" + this.changeSetId + "::" + this.changeSetAuthor;
            if (liquibaseException.getCause() instanceof RollbackImpossibleException) {
                logger.severe("\nError executing rollback:\nThe targeted changeset '" + (String)object + "' does not have a rollback defined\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", liquibaseException);
                throw new LiquibaseException("\nError executing rollback:\nThe targeted changeset '" + (String)object + "' does not have a rollback defined.\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", liquibaseException);
            }
            logger.severe("\nError executing rollback for the targeted changeset '" + (String)object + "'.");
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object + "':\n" + liquibaseException.getMessage(), liquibaseException);
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(MSG_COULD_NOT_RELEASE_LOCK, lockException);
            }
            if (executor != null) {
                Scope.getCurrentScope().getSingleton(ExecutorService.class).setExecutor("jdbc", this.database, executor);
            }
        }
        this.resetServices();
        return new CommandResult("rollbackOneChangeSet executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private String getChangeSetString(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        return changeSet.toString(false);
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, changeSetFilter, new AlreadyRanChangeSetFilter(list), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database));
    }

    protected void executeRollbackScript(String string, ChangeSet changeSet, Contexts object, LabelExpression labelExpression) {
        Object object2;
        Executor executor = Scope.getCurrentScope().getSingleton(ExecutorService.class).getExecutor("jdbc", this.database);
        try {
            object2 = Scope.getCurrentScope().getResourceAccessor().openStreams(null, string);
            if (object2 == null || ((InputStreamList)object2).isEmpty()) {
                throw new LiquibaseException("WARNING: The rollback script '" + string + "' was not located. Please check your parameters. No rollback was performed.");
            }
            if (((InputStreamList)object2).size() > 1) {
                throw new LiquibaseException("Found multiple rollbackScripts named ".concat(String.valueOf(string)));
            }
            string = StreamUtil.readStreamAsString(((InputStreamList)object2).iterator().next());
        }
        catch (IOException iOException) {
            throw new LiquibaseException("Error reading rollbackScript " + executor + ": " + iOException.getMessage());
        }
        this.changeLogParameters.setContexts((Contexts)object);
        this.changeLogParameters.setLabels(labelExpression);
        string = this.changeLogParameters.expandExpressions(string, this.changeLog);
        object2 = this.buildRawSQLChange(string);
        object = this.getChangeSetString(changeSet);
        try {
            if (this.changeExecListener != null) {
                ((HubChangeExecListener)this.changeExecListener).setRollbackScriptContents(string);
                this.changeExecListener.willRollback(changeSet, this.changeLog, this.database);
            }
            Scope.getCurrentScope().getUI().sendMessage("Rolling Back Changeset:".concat(String.valueOf(object)));
            executor.execute((Change)object2);
            if (this.changeExecListener != null) {
                this.changeExecListener.rolledBack(changeSet, this.changeLog, this.database);
            }
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(this.getClass()).severe("Error executing rollback script: " + databaseException.getMessage());
            this.changeExecListener.rollbackFailed(changeSet, this.changeLog, this.database, databaseException);
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object + "':\n" + databaseException.getMessage(), databaseException);
        }
        this.database.commit();
        if (string.length() == 0) {
            Scope.getCurrentScope().getLog(this.getClass()).info("No rollback logic defined in empty rollback script. Changesets have been removed from\nthe DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    protected RawSQLChange buildRawSQLChange(String object) {
        object = new RawSQLChange((String)object);
        ((AbstractSQLChange)object).setSplitStatements(Boolean.TRUE);
        ((AbstractSQLChange)object).setStripComments(Boolean.TRUE);
        return object;
    }

    protected void checkLiquibaseTables(boolean bl2, DatabaseChangeLog databaseChangeLog, Contexts contexts, LabelExpression labelExpression) {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database);
        changeLogHistoryService.init();
        if (bl2) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts, labelExpression);
        }
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        Scope.getCurrentScope().getSingleton(ExecutorService.class).reset();
    }

    private /* synthetic */ void lambda$run$0(ChangeLogIterator changeLogIterator) {
        changeLogIterator.run(this.createRollbackVisitor(), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression));
    }
}

