/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.license.keymgr;

import java.io.File;
import java.io.FilenameFilter;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import liquibase.Scope;
import liquibase.license.LicenseInstallResult;
import liquibase.license.LicenseService;
import liquibase.license.Location;
import liquibase.license.LocationType;
import liquibase.logging.Logger;
import liquibase.pro.license.keymgr.a;
import liquibase.pro.license.keymgr.b;
import liquibase.pro.license.keymgr.c;
import liquibase.pro.packaged.kB;
import liquibase.pro.packaged.kH;
import liquibase.pro.packaged.kJ;
import liquibase.pro.packaged.kN;
import liquibase.pro.packaged.kS;
import liquibase.pro.packaged.lL;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class DaticalTrueLicenseService
implements LicenseService {
    private static final String INVALID_LICENSE_KEY_WARN = "WARNING!  You have specified an invalid license key.  Liquibase Pro features will remain disabled!";
    private static final String EXPIRED_LICENSE_KEY_WARN = "WARNING!  Your Liquibase Pro License has expired!  Liquibase Pro features will be disabled without a valid license!";
    private static final String RENEW_MSG = "To renew Liquibase Pro please contact sales@liquibase.com or go to https://www.liquibase.org/download";
    private static final String LIQUIBASE_PRO_MSG = "Liquibase Pro %s by Datical licensed to %s until %s";
    private static final String LIQUIBASE_COMMUNITY_MSG = "Liquibase Community %s by Datical";
    private Map<String, kJ> managers = new HashMap<String, kJ>();
    private boolean hasLoggedLicenseFailure = false;
    private String buildVersion;
    private boolean licenseInstalled = false;

    public DaticalTrueLicenseService() {
        this.addManager(DaticalTrueLicenseService._string#0());
        this.buildVersion = LiquibaseUtil.getBuildVersion();
    }

    private void addManager(String string) {
        kJ kJ2 = c.a(string);
        this.managers.put(string, kJ2);
    }

    @Override
    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    @Override
    public boolean licenseIsValid(String string) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        if (!this.licenseInstalled) {
            return false;
        }
        try {
            kJ kJ2 = this.managers.get(string);
            if (kJ2 == null) {
                logger.severe("Could not create LicenseConsumerManager");
                return false;
            }
            kJ2.i();
            return true;
        }
        catch (kN kN2) {
            if (!this.hasLoggedLicenseFailure) {
                string = String.format("License with subject '%s' is not valid. %s", string, kN2.getMessage());
                Scope.getCurrentScope().getLog(this.getClass()).severe(string);
            }
            this.hasLoggedLicenseFailure = true;
            return false;
        }
    }

    @Override
    public String getLicenseInfo() {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = this.daysTilExpiration();
        if (!this.licenseIsInstalled()) {
            stringBuilder.append(String.format(LIQUIBASE_COMMUNITY_MSG, this.buildVersion));
        } else if (!this.licenseIsValid(DaticalTrueLicenseService._string#0())) {
            stringBuilder.append(EXPIRED_LICENSE_KEY_WARN).append(StreamUtil.getLineSeparator()).append(RENEW_MSG).append(StreamUtil.getLineSeparator());
        } else {
            for (String string : this.managers.keySet()) {
                kJ kJ2 = this.managers.get(string);
                try {
                    Object object = kJ2.h();
                    String string2 = DaticalTrueLicenseService.getValByAttributeTypeFromIssuerDN(((kB)object).getHolder().getName(), "CN");
                    object = ((kB)object).getNotAfter();
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy");
                    if (this.licenseIsAboutToExpire() && n2 > 0) {
                        stringBuilder.append(String.format(LIQUIBASE_PRO_MSG, this.buildVersion, string2, simpleDateFormat.format((Date)object))).append(StreamUtil.getLineSeparator()).append(String.format("WARNING!  Your license will expire in %d days!", n2)).append(StreamUtil.getLineSeparator()).append(RENEW_MSG);
                        continue;
                    }
                    stringBuilder.append(String.format(LIQUIBASE_PRO_MSG, this.buildVersion, string2, simpleDateFormat.format((Date)object)));
                }
                catch (kN kN2) {}
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean licenseIsInstalled() {
        if (!this.licenseInstalled) {
            return false;
        }
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        logger.fine("checking if license is installed");
        boolean bl2 = false;
        for (String string : this.managers.keySet()) {
            try {
                this.managers.get(string).i();
                bl2 = true;
            }
            catch (kS kS2) {
                logger.severe(kS2.getMessage());
                bl2 = true;
            }
            catch (kN kN2) {
                if (this.hasLoggedLicenseFailure) continue;
                logger.severe(String.format("License with subject '%s' is not valid. %s", string, kN2.getMessage()));
                this.hasLoggedLicenseFailure = true;
            }
        }
        return bl2;
    }

    @Override
    public void disable() {
        this.licenseInstalled = false;
    }

    @Override
    public LicenseInstallResult installLicense(Location ... locationArray) {
        this.licenseInstalled = true;
        LicenseInstallResult licenseInstallResult = new LicenseInstallResult(0);
        for (Location location : locationArray) {
            if (location.type == LocationType.BASE64_STRING) {
                licenseInstallResult.add(this.installFromBase64String(location));
                continue;
            }
            Object object = location.getPath();
            if (object != null) {
                if (((File)(object = new File((String)object))).exists() && ((File)object).isDirectory()) {
                    licenseInstallResult.add(this.installFromDirectory(location, (File)object));
                    continue;
                }
                if (!((File)object).exists()) continue;
                licenseInstallResult.add(this.installFromFile(location, (File)object));
                continue;
            }
            licenseInstallResult.add(new LicenseInstallResult(0, location + " does not specify a location for a license file."));
        }
        return licenseInstallResult;
    }

    @Override
    public boolean licenseIsAboutToExpire() {
        boolean bl2 = false;
        for (String object : this.managers.keySet()) {
            kJ bl3 = this.managers.get(object);
            try {
                kB kB2 = bl3.h();
                Date date = DaticalTrueLicenseService.addDays(new Date(), 30);
                boolean bl4 = kB2.getNotAfter().before(date);
                bl2 = bl2 || bl4;
            }
            catch (kN kN2) {}
        }
        return bl2;
    }

    @Override
    public int daysTilExpiration() {
        int n2 = Integer.MAX_VALUE;
        for (String object : this.managers.keySet()) {
            kJ n3 = this.managers.get(object);
            try {
                int n4 = DaticalTrueLicenseService.daysDifference(n3.h().getNotAfter());
                if (n4 >= n2) continue;
                n2 = n4;
            }
            catch (kN kN2) {}
        }
        return n2;
    }

    private LicenseInstallResult installFromBase64String(Location location) {
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        for (String string : this.managers.keySet()) {
            try {
                this.managers.get(string).a(new a(location.getPath()));
                logger.info("Successfully installed license from " + location + ".\n");
            }
            catch (kS kS2) {
                n2 = 1;
                if (kS2.getMessage().contains("License validity period has expired")) {
                    stringBuilder.append("WARNING!  Your Liquibase Pro License has expired!  Liquibase Pro features will be disabled without a valid license!\n");
                    stringBuilder.append(RENEW_MSG);
                    logger.severe(kS2.getMessage());
                    break;
                }
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + kS2.getMessage() + "\n");
                break;
            }
            catch (Exception exception) {
                n2 = 1;
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception.getMessage() + "\n");
                break;
            }
        }
        return new LicenseInstallResult(n2, stringBuilder.toString());
    }

    private LicenseInstallResult installFromFile(Location location, File file) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        int n2 = 0;
        StringBuilder stringBuilder = new StringBuilder();
        for (String kS2 : this.managers.keySet()) {
            try {
                kJ object = this.managers.get(kS2);
                kH kH2 = (kH)object.e();
                object.a(kH2.a(file));
                logger.info("Successfully installed license file '" + file + "' from " + location + ".\n");
            }
            catch (kS exception) {
                n2 = 1;
                if (exception.getMessage().contains("License validity period has expired")) {
                    stringBuilder.append("WARNING!  Your Liquibase Pro License has expired!  Liquibase Pro features will be disabled without a valid license!\n");
                    stringBuilder.append(RENEW_MSG);
                    logger.severe(exception.getMessage());
                    break;
                }
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception.getMessage() + "\n");
                break;
            }
            catch (Exception exception) {
                n2 = 1;
                stringBuilder.append(INVALID_LICENSE_KEY_WARN);
                logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception.getMessage() + "\n");
                break;
            }
        }
        return new LicenseInstallResult(n2, stringBuilder.toString());
    }

    private LicenseInstallResult installFromDirectory(Location location, File file) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = new b(this);
        if ((fileArray = file.listFiles((FilenameFilter)fileArray)) != null && fileArray.length == 0) {
            logger.severe("There are no '.lic' files in '" + file + "' " + location.toDisplayString());
        }
        block3: for (File file2 : fileArray) {
            for (String kS2 : this.managers.keySet()) {
                kJ exception = this.managers.get(kS2);
                kH kH2 = (kH)exception.e();
                try {
                    exception.a(kH2.a(file2));
                    logger.info("Successfully installed license file '" + file + "' from " + location + ".\n");
                }
                catch (kS kS3) {
                    n2 = 1;
                    if (kS3.getMessage().contains("License validity period has expired")) {
                        arrayList.add("WARNING!  Your Liquibase Pro License has expired!  Liquibase Pro features will be disabled without a valid license!\n");
                        arrayList.add(RENEW_MSG);
                        logger.severe(kS3.getMessage());
                        continue block3;
                    }
                    arrayList.add(INVALID_LICENSE_KEY_WARN);
                    logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + kS3.getMessage() + "\n");
                }
                catch (Exception exception2) {
                    n2 = 1;
                    arrayList.add(INVALID_LICENSE_KEY_WARN);
                    logger.severe("Could not install license from " + location + ". Please contact sales@liquibase.com\n" + exception2.getMessage() + "\n");
                    continue block3;
                }
            }
        }
        return new LicenseInstallResult(n2, arrayList);
    }

    private static Date addDays(Date date, int n2) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n2);
        return calendar.getTime();
    }

    private static int daysDifference(Date comparable) {
        LocalDate localDate = LocalDate.now();
        comparable = LocalDate.ofEpochDay(TimeUnit.MILLISECONDS.toDays(comparable.getTime()));
        return (int)ChronoUnit.DAYS.between(localDate, (Temporal)((Object)comparable));
    }

    private static String getValByAttributeTypeFromIssuerDN(String stringArray, String string) {
        for (String string2 : stringArray.split(",")) {
            String[] stringArray2;
            if (!string2.contains(string) || (stringArray2 = string2.trim().split("="))[1] == null) continue;
            return stringArray2[1].trim();
        }
        return "";
    }

    private static /* synthetic */ String _string#0() {
        return new lL(new long[]{-1586812080940484400L, 7411054641334042344L, 9004823544724420160L}).toString();
    }
}

