/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.OperatorEnum;
import com.datical.liquibase.ext.checks.config.cli.RegexGetter;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.repackaged.net.sf.jsqlparser.JSQLParserException;
import liquibase.util.StringUtil;

public abstract class AbstractObjectNamingRule
extends AbstractLiquibaseDynamicForecastRule {
    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public final boolean internalEvaluate(ChangeSet object, DynamicRule dynamicRule) {
        Object object2 = dynamicRule.getParameter(DynamicRuleParameterEnum.OPERATOR);
        Object object3 = dynamicRule.getParameter(DynamicRuleParameterEnum.SEARCH_STRING);
        DynamicRuleParameter iterator2 = dynamicRule.getParameter(DynamicRuleParameterEnum.CASE_SENSITIVE);
        object2 = OperatorEnum.valueOf((String)((DynamicRuleParameter)object2).getValue());
        object3 = (String)((DynamicRuleParameter)object3).getValue();
        Boolean bl2 = (Boolean)DynamicRuleParameterEnum.CASE_SENSITIVE.defaultValue;
        if (object2 != OperatorEnum.REGEXP) {
            bl2 = (Boolean)iterator2.getValue();
        } else if (iterator2 != null) {
            this.setResultUnsuccessful("Rule is using a " + (Object)((Object)OperatorEnum.REGEXP) + " operator, but also has a value for the " + (Object)((Object)DynamicRuleParameterEnum.CASE_SENSITIVE) + " param.", dynamicRule);
        }
        for (Change change : ((ChangeSet)((Object)object)).getChanges()) {
            Object object4 = new ArrayList();
            if (change instanceof AbstractSQLChange) {
                try {
                    object4 = this.getValue(StringUtil.stripComments(((AbstractSQLChange)change).getSql()), ((AbstractSQLChange)change).getEndDelimiter());
                }
                catch (JSQLParserException jSQLParserException) {
                    Scope.getCurrentScope().getLog(this.getClass()).severe("Failed to parse SQL", jSQLParserException);
                    return this.setResultUnsuccessful("The SQL could not be parsed by this check. Please review the changeset or SQL directly to make sure it is valid.", dynamicRule);
                }
            } else if (change instanceof AbstractChange) {
                object4 = this.getValue((AbstractChange)change);
            }
            Iterator iterator = object4.iterator();
            while (iterator.hasNext()) {
                object4 = (String)iterator.next();
                boolean bl3 = ((OperatorEnum)((Object)object2)).matches((String)object3, (String)object4, bl2);
                if (!this.operatorMatchCallback(bl3)) continue;
                AbstractObjectNamingRule abstractObjectNamingRule = this;
                return abstractObjectNamingRule.setResultUnsuccessful(abstractObjectNamingRule.getFailureMessage((OperatorEnum)((Object)object2), (String)object3), dynamicRule);
            }
        }
        return this.setResultSuccessful(true, dynamicRule);
    }

    public abstract boolean operatorMatchCallback(boolean var1);

    public abstract String getFailureMessage(OperatorEnum var1, String var2);

    public abstract List<String> getValue(AbstractChange var1);

    public abstract List<String> getValue(String var1, String var2);

    @Override
    public final List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.OPERATOR), new RuleParameter<String>(DynamicRuleParameterEnum.SEARCH_STRING, (string, list) -> {
            if (list.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst().get().getValue() == OperatorEnum.REGEXP) {
                return new RegexGetter().validate((String)string);
            }
            if (StringUtil.isEmpty(string)) {
                throw new IllegalArgumentException("The search string is empty or contains invalid characters.");
            }
            return Boolean.TRUE;
        }, null), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE, null, list -> list.stream().filter(dynamicRuleParameter -> dynamicRuleParameter.getParameterAsEnum() == DynamicRuleParameterEnum.OPERATOR).findFirst().get().getValue() != OperatorEnum.REGEXP));
    }
}

