/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.CheckSettingsConfigHelper;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.command.checks.AbstractChecksCommandStep;
import com.datical.liquibase.ext.rules.api.FactEnum;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine;
import com.datical.liquibase.ext.rules.core.QualityChecksRulesEngine$RuleCombination;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.exception.ChangeLogParseException;
import liquibase.license.LicenseServiceFactory;
import liquibase.license.LicenseServiceUtils;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StringUtil;

public class ChecksRunCommandStep
extends AbstractChecksCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"checks", "run"};
    public static final CommandArgumentDefinition<String> CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SETTINGS_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHECKS_SCOPE_ARG;
    private List<QualityChecksRulesEngine$RuleCombination> executedRules = new ArrayList<QualityChecksRulesEngine$RuleCombination>();
    private List<QualityChecksRulesEngine$RuleCombination> skippedRules = new ArrayList<QualityChecksRulesEngine$RuleCombination>();

    @Override
    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope();
        Object object2 = ((CommandScope)object).getConfiguredValue(CHECKS_SETTINGS_FILE_ARG).getValue();
        ChecksRunCommandStep.checkFileArgExistence((String)object2, "checks settings");
        Object object3 = new CheckSettingsConfigHelper((String)object2);
        object = ((CommandScope)object).getConfiguredValue(CHANGELOG_FILE_ARG).getValue();
        ChecksRunCommandStep.checkFileArgExistence((String)object, "changelog");
        this.sendMessageToUi("Executing Quality Checks against " + (String)object + System.lineSeparator());
        LinkedHashMap<ChangeSet, List<LiquibaseRuleResult>> linkedHashMap = Scope.getCurrentScope().getResourceAccessor();
        Object object4 = ChangeLogParserFactory.getInstance().getParser((String)object, (ResourceAccessor)((Object)linkedHashMap));
        try {
            linkedHashMap = object4.parse((String)object, new ChangeLogParameters(), (ResourceAccessor)((Object)linkedHashMap));
        }
        catch (ChangeLogParseException changeLogParseException) {
            object = String.format("\nThe changelog file %s cannot be found or is not a valid changelog: %s\nCorrect this issue and try to run checks again.", object, changeLogParseException.getMessage());
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object);
            Scope.getCurrentScope().getUI().sendMessage((String)object);
            return;
        }
        object4 = Scope.getCurrentScope().getSingleton(LicenseServiceFactory.class).getLicenseService();
        int n2 = object4.daysTilExpiration();
        boolean bl2 = LicenseServiceUtils.isProLicenseValid();
        if (n2 > 0) {
            if (bl2) {
                this.sendMessageToUi("Executing all checks because a valid Liquibase Pro license was found!" + System.lineSeparator());
            } else {
                this.sendMessageToUi("No valid Liquibase Pro license key detected!" + System.lineSeparator() + "Unlock unlimited checks with a free Pro license Key from https://liquibase.com/protrial" + System.lineSeparator() + "Execution limited to 5 checks." + System.lineSeparator());
            }
        } else {
            LocalDate localDate = LocalDate.now().plusDays(n2);
            this.sendMessageToUi("Pro license expired on " + localDate.format(DateTimeFormatter.ofPattern("yyyy-MMM-dd")) + "." + System.lineSeparator() + "Unlock unlimited checks with a free Pro license Key from https://liquibase.com/protrial" + System.lineSeparator() + "Execution limited to 5 checks." + System.lineSeparator());
        }
        List<AbstractLiquibaseRule> list = ChecksRunCommandStep.listAllRules();
        try {
            object3 = ((CheckSettingsConfigHelper)object3).read(list);
        }
        catch (Exception exception) {
            object2 = String.format("\nUnable to read checks settings file '%s': %s\nCorrect this issue and try to run checks again.", object2, exception.getMessage());
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object2);
            Scope.getCurrentScope().getUI().sendMessage((String)object2);
            return;
        }
        linkedHashMap = this.runChecks(list, ((DatabaseChangeLog)((Object)linkedHashMap)).getChangeSets(), (CheckSettingsConfig)object3);
        if (this.executedRules.isEmpty()) {
            object2 = "\nWarning:  No checks were executed\nChangesets Validated:  None\nChecks run against each changeset:  None\n\n";
            Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).severe((String)object2);
            Scope.getCurrentScope().getUI().sendMessage((String)object2);
            return;
        }
        object2 = SeverityEnum.INFO;
        if (!linkedHashMap.isEmpty()) {
            Object object5;
            boolean bl3 = false;
            for (Map.Entry<ChangeSet, List<LiquibaseRuleResult>> entry : linkedHashMap.entrySet()) {
                object5 = entry.getKey();
                for (Object object6 : entry.getValue()) {
                    String string;
                    if (((LiquibaseRuleResult)object6).hasRuleSucceeded()) continue;
                    if (!bl3) {
                        this.sendMessage(commandResultsBuilder, "Checks completed validation of the changelog and found the following issues:" + System.lineSeparator() + System.lineSeparator());
                        bl3 = true;
                    }
                    Object object7 = ((LiquibaseRuleResult)object6).getExecutions().get(0);
                    Object object8 = ((LiquibaseRuleResult)object6).getDynamicRule();
                    if (object8 != null) {
                        string = ((DynamicRule)object8).getShortName();
                        object8 = ((AbstractConfigurableRule)object8).getSeverity();
                    } else {
                        string = ((LiquibaseRuleResult)object6).getRule().getShortName();
                        object8 = ((LiquibaseRuleResult)object6).getRule().getSeverity();
                    }
                    if (((SeverityEnum)((Object)object8)).getValue() > ((SeverityEnum)((Object)object2)).getValue()) {
                        object2 = object8;
                    }
                    if (StringUtil.isNotEmpty(string)) {
                        string = " (" + string + ")";
                    }
                    object7 = StringUtil.wrap(StringUtil.join(((RuleIteration)object7).getMessages(), ";"), 60, 20);
                    object6 = ((LiquibaseRuleResult)object6).getRule().getName() + string + System.lineSeparator();
                    object6 = "Changeset ID:       " + ((ChangeSet)object5).getId() + System.lineSeparator() + "Changeset Filepath: " + ((ChangeSet)object5).getFilePath() + System.lineSeparator() + "Check Name:         " + (String)object6 + "Check Severity:     " + object8 + " (Return code: " + ((SeverityEnum)((Object)object8)).getExitValue() + ")" + System.lineSeparator() + "Message:            " + (String)object7;
                    this.sendMessage(commandResultsBuilder, (String)object6 + System.lineSeparator() + System.lineSeparator());
                }
            }
            StringBuilder stringBuilder = new StringBuilder(System.lineSeparator() + "Changesets Validated:");
            stringBuilder.append(System.lineSeparator());
            Iterator<Map.Entry<ChangeSet, List<LiquibaseRuleResult>>> iterator = linkedHashMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Object object6;
                object6 = iterator.next().getKey();
                stringBuilder.append("  ID: ");
                stringBuilder.append(((ChangeSet)object6).getId());
                stringBuilder.append("; Author: ");
                stringBuilder.append(((ChangeSet)object6).getAuthor());
                stringBuilder.append("; File path: ");
                stringBuilder.append(((ChangeSet)object6).getFilePath());
                stringBuilder.append(System.lineSeparator());
            }
            this.sendMessage(commandResultsBuilder, stringBuilder + System.lineSeparator());
            StringBuilder stringBuilder2 = new StringBuilder("Checks run against each changeset:");
            stringBuilder2.append(System.lineSeparator());
            ChecksRunCommandStep checksRunCommandStep = this;
            checksRunCommandStep.addRulesToStringBuilder(checksRunCommandStep.executedRules, stringBuilder2);
            this.sendMessage(commandResultsBuilder, stringBuilder2 + System.lineSeparator());
            if (!this.skippedRules.isEmpty()) {
                object5 = new StringBuilder("Checks Skipped Due to Community Limit of 5 Checks:");
                ((StringBuilder)object5).append(System.lineSeparator());
                ChecksRunCommandStep checksRunCommandStep2 = this;
                checksRunCommandStep2.addRulesToStringBuilder(checksRunCommandStep2.skippedRules, (StringBuilder)object5);
                this.sendMessage(commandResultsBuilder, object5 + System.lineSeparator());
            }
            if (n2 < 0) {
                this.sendMessageToUi(object4.getLicenseInfo());
            }
        }
        this.sendMessage(commandResultsBuilder, ((CheckSettingsConfig)object3).getUnrecognizedRulesWarningMessage());
        commandResultsBuilder.getOutputStream().flush();
        int n3 = ((SeverityEnum)((Object)object2)).getExitValue();
        if (n3 != 0) {
            commandResultsBuilder.addResult("statusCode", (Object)n3);
            throw commandResultsBuilder.commandFailed("Checks run command exited with an error code of ".concat(String.valueOf(n3)), n3);
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    private void addRulesToStringBuilder(List<QualityChecksRulesEngine$RuleCombination> object, StringBuilder stringBuilder) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                QualityChecksRulesEngine$RuleCombination qualityChecksRulesEngine$RuleCombination = (QualityChecksRulesEngine$RuleCombination)object.next();
                stringBuilder.append("  ");
                stringBuilder.append(qualityChecksRulesEngine$RuleCombination.rule.getName());
                if (qualityChecksRulesEngine$RuleCombination.configurableRule instanceof DynamicRule && ((DynamicRule)qualityChecksRulesEngine$RuleCombination.configurableRule).isCopy()) {
                    stringBuilder.append(" (Short Name: ");
                    stringBuilder.append(((DynamicRule)qualityChecksRulesEngine$RuleCombination.configurableRule).getShortName());
                    stringBuilder.append(")");
                }
                stringBuilder.append(System.lineSeparator());
            }
        }
    }

    private void sendMessageToUi(String string) {
        Scope.getCurrentScope().getUI().sendMessage(string);
    }

    private void sendMessage(CommandResultsBuilder commandResultsBuilder, String string) {
        commandResultsBuilder.getOutputStream().write(string.getBytes());
    }

    private static boolean validChecksScope(String string) {
        return "changelog".equalsIgnoreCase(string);
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Check the changelog for issues");
        commandDefinition.setGroupShortDescription(new String[]{"checks"}, "Quality Checks commands");
    }

    private LinkedHashMap<ChangeSet, List<LiquibaseRuleResult>> runChecks(List<AbstractLiquibaseRule> list, List<ChangeSet> object, CheckSettingsConfig checkSettingsConfig) {
        if (checkSettingsConfig != null) {
            LinkedHashMap<ChangeSet, List<LiquibaseRuleResult>> linkedHashMap = new LinkedHashMap<ChangeSet, List<LiquibaseRuleResult>>(object.size());
            object = object.iterator();
            while (object.hasNext()) {
                ChangeSet changeSet = (ChangeSet)object.next();
                linkedHashMap.put(changeSet, this.runCheck(list, changeSet, checkSettingsConfig));
            }
            return linkedHashMap;
        }
        return new LinkedHashMap<ChangeSet, List<LiquibaseRuleResult>>();
    }

    private List<LiquibaseRuleResult> runCheck(List<AbstractLiquibaseRule> iterable, ChangeSet object, CheckSettingsConfig checkSettingsConfig) {
        Facts facts = new Facts();
        facts.put(FactEnum.CHANGESET.toString(), object);
        iterable = new Rules(iterable.toArray());
        object = new QualityChecksRulesEngine(checkSettingsConfig);
        ((QualityChecksRulesEngine)object).fire((Rules)iterable, facts);
        this.executedRules = ((QualityChecksRulesEngine)object).getExecutedRules();
        this.skippedRules = ((QualityChecksRulesEngine)object).getSkippedRules();
        return ((QualityChecksRulesEngine)object).getResults();
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder(new String[][]{COMMAND_NAME});
        CHANGELOG_FILE_ARG = commandBuilder.argument("changelogFile", String.class).required().description("Relative or fully qualified path to a Liquibase changelog file").build();
        CHECKS_SETTINGS_FILE_ARG = commandBuilder.argument("checksSettingsFile", String.class).description("Relative or fully qualified path to a configuration file for checks execution").build();
        CHECKS_SCOPE_ARG = commandBuilder.argument("checksScope", String.class).defaultValue("changelog").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!ChecksRunCommandStep.validChecksScope((String)(object = (String)object))) {
                object = "\nWARNING:  Check scope value '" + (String)object + "' is not valid.  Valid check scope values include: changelog";
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).description("The Liquibase component to run checks against").build();
    }
}

