/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.MySQLIndexHint;
import liquibase.repackaged.net.sf.jsqlparser.expression.SQLServerHints;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.AllTableColumns;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ExceptOp;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Fetch;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.FromItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.IntersectOp;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.LateralSubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.MinusOp;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Offset;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ParenthesisFromItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Pivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PivotXml;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectExpressionItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectItemVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SetOperationList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubJoin;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.TableFunction;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnPivot;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.UnionOp;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.ValuesList;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.statement.values.ValuesStatement;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationUtil;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.metadata.NamedObject;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ExpressionValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.GroupByValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.LimitValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.ValuesStatementValidator;

public class SelectValidator
extends AbstractValidator<SelectItem>
implements FromItemVisitor,
PivotVisitor,
SelectItemVisitor,
SelectVisitor {
    @Override
    public void visit(PlainSelect plainSelect) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.select);
            this.validateFeature(validationCapability, plainSelect.getMySqlHintStraightJoin(), Feature.mySqlHintStraightJoin);
            this.validateOptionalFeature(validationCapability, plainSelect.getOracleHint(), Feature.oracleHint);
            this.validateOptionalFeature(validationCapability, plainSelect.getSkip(), Feature.skip);
            this.validateOptionalFeature(validationCapability, plainSelect.getFirst(), Feature.first);
            if (plainSelect.getDistinct() != null) {
                if (plainSelect.getDistinct().isUseUnique()) {
                    this.validateFeature(validationCapability, Feature.selectUnique);
                } else {
                    this.validateFeature(validationCapability, Feature.distinct);
                }
                this.validateOptionalFeature(validationCapability, plainSelect.getDistinct().getOnSelectItems(), Feature.distinctOn);
            }
            this.validateOptionalFeature(validationCapability, plainSelect.getTop(), Feature.top);
            this.validateFeature(validationCapability, plainSelect.getMySqlSqlNoCache(), Feature.mysqlSqlNoCache);
            this.validateFeature(validationCapability, plainSelect.getMySqlSqlCalcFoundRows(), Feature.mysqlCalcFoundRows);
            this.validateOptionalFeature(validationCapability, plainSelect.getIntoTables(), Feature.selectInto);
            this.validateOptionalFeature(validationCapability, plainSelect.getKsqlWindow(), Feature.kSqlWindow);
            this.validateFeature(validationCapability, this.isNotEmpty(plainSelect.getOrderByElements()) && plainSelect.isOracleSiblings(), Feature.oracleOrderBySiblings);
            if (plainSelect.isForUpdate()) {
                this.validateFeature(validationCapability, Feature.selectForUpdate);
                this.validateOptionalFeature(validationCapability, plainSelect.getForUpdateTable(), Feature.selectForUpdateOfTable);
                this.validateOptionalFeature(validationCapability, plainSelect.getWait(), Feature.selectForUpdateWait);
                this.validateFeature(validationCapability, plainSelect.isNoWait(), Feature.selectForUpdateNoWait);
            }
            this.validateOptionalFeature(validationCapability, plainSelect.getForXmlPath(), Feature.selectForXmlPath);
            this.validateOptionalFeature(validationCapability, plainSelect.getOptimizeFor(), Feature.optimizeFor);
        }
        this.validateOptionalList(plainSelect.getSelectItems(), () -> this, (selectItem, selectValidator) -> selectItem.accept((SelectItemVisitor)selectValidator));
        this.validateOptionalFromItem(plainSelect.getFromItem());
        this.validateOptionalFromItems(plainSelect.getIntoTables());
        this.validateOptionalJoins(plainSelect.getJoins());
        this.validateOptionalExpression(plainSelect.getWhere());
        this.validateOptionalExpression(plainSelect.getOracleHierarchical());
        if (plainSelect.getGroupBy() != null) {
            plainSelect.getGroupBy().accept(this.getValidator(GroupByValidator.class));
        }
        this.validateOptionalExpression(plainSelect.getHaving());
        this.validateOptionalOrderByElements(plainSelect.getOrderByElements());
        if (plainSelect.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(plainSelect.getLimit());
        }
        if (plainSelect.getOffset() != null) {
            this.validateOffset(plainSelect.getOffset());
        }
        if (plainSelect.getFetch() != null) {
            this.validateFetch(plainSelect.getFetch());
        }
    }

    @Override
    public void visit(AllTableColumns allTableColumns) {
    }

    @Override
    public void visit(AllColumns allColumns) {
    }

    @Override
    public void visit(SelectExpressionItem selectExpressionItem) {
        selectExpressionItem.getExpression().accept(this.getValidator(ExpressionValidator.class));
    }

    @Override
    public void visit(SubSelect subSelect) {
        if (this.isNotEmpty(subSelect.getWithItemsList())) {
            subSelect.getWithItemsList().forEach(withItem -> withItem.accept(this));
        }
        subSelect.getSelectBody().accept(this);
        this.validateOptional(subSelect.getPivot(), pivot -> pivot.accept(this));
    }

    @Override
    public void visit(Table object) {
        this.validateNameWithAlias(NamedObject.table, ((Table)object).getFullyQualifiedName(), ValidationUtil.getAlias(((Table)object).getAlias()));
        this.validateOptional(((Table)object).getPivot(), pivot -> pivot.accept(this));
        this.validateOptional(((Table)object).getUnPivot(), unPivot -> unPivot.accept(this));
        MySQLIndexHint mySQLIndexHint = ((Table)object).getIndexHint();
        if (mySQLIndexHint != null && this.isNotEmpty(mySQLIndexHint.getIndexNames())) {
            mySQLIndexHint.getIndexNames().forEach(string -> this.validateName(NamedObject.index, (String)string));
        }
        if ((object = ((Table)object).getSqlServerHints()) != null) {
            this.validateName(NamedObject.index, ((SQLServerHints)object).getIndexName());
        }
    }

    @Override
    public void visit(Pivot pivot) {
        this.validateFeature(Feature.pivot);
        this.validateOptionalExpressions(pivot.getForColumns());
    }

    @Override
    public void visit(UnPivot unPivot) {
        this.validateFeature(Feature.unpivot);
        this.validateOptionalExpressions(unPivot.getUnPivotForClause());
        this.validateOptionalExpression(unPivot.getUnPivotClause());
    }

    @Override
    public void visit(PivotXml pivotXml) {
        this.validateFeature(Feature.pivotXml);
        this.validateOptionalExpressions(pivotXml.getForColumns());
        if (this.isNotEmpty(pivotXml.getFunctionItems())) {
            ExpressionValidator expressionValidator = this.getValidator(ExpressionValidator.class);
            pivotXml.getFunctionItems().forEach(functionItem -> functionItem.getFunction().accept(expressionValidator));
        }
        if (pivotXml.getInSelect() != null) {
            pivotXml.getInSelect().accept(this);
        }
    }

    public void validateOffset(Offset offset) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.offset);
            this.validateOptionalFeature(validationCapability, offset.getOffsetParam(), Feature.offsetParam);
        }
    }

    public void validateFetch(Fetch fetch) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.fetch);
            this.validateFeature(validationCapability, fetch.isFetchParamFirst(), Feature.fetchFirst);
            this.validateFeature(validationCapability, !fetch.isFetchParamFirst(), Feature.fetchNext);
        }
        this.validateOptionalExpression(fetch.getFetchJdbcParameter());
    }

    @Override
    public void visit(SubJoin subJoin) {
        this.validateOptionalFromItem(subJoin.getLeft());
        this.validateOptionalJoins(subJoin.getJoinList());
        this.validateOptional(subJoin.getPivot(), pivot -> pivot.accept(this));
    }

    public void validateOptionalJoins(List<Join> object) {
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                Join join = (Join)object.next();
                this.validateOptionalJoin(join);
            }
        }
    }

    public void validateOptionalJoin(Join join) {
        for (ValidationCapability object : this.getCapabilities()) {
            this.validateFeature(object, Feature.join);
            this.validateFeature(object, join.isSimple() && join.isOuter(), Feature.joinOuterSimple);
            this.validateFeature(object, join.isSimple(), Feature.joinSimple);
            this.validateFeature(object, join.isRight(), Feature.joinRight);
            this.validateFeature(object, join.isNatural(), Feature.joinNatural);
            this.validateFeature(object, join.isFull(), Feature.joinFull);
            this.validateFeature(object, join.isLeft(), Feature.joinLeft);
            this.validateFeature(object, join.isCross(), Feature.joinCross);
            this.validateFeature(object, join.isOuter(), Feature.joinOuter);
            this.validateFeature(object, join.isInner(), Feature.joinInner);
            this.validateFeature(object, join.isSemi(), Feature.joinSemi);
            this.validateFeature(object, join.isStraight(), Feature.joinStraight);
            this.validateFeature(object, join.isApply(), Feature.joinApply);
            this.validateFeature(object, join.isWindowJoin(), Feature.joinWindow);
            this.validateOptionalFeature(object, join.getUsingColumns(), Feature.joinUsingColumns);
        }
        this.validateOptionalFromItem(join.getRightItem());
        for (Expression expression : join.getOnExpressions()) {
            this.validateOptionalExpression(expression);
        }
        this.validateOptionalExpressions(join.getUsingColumns());
    }

    @Override
    public void visit(SetOperationList setOperationList) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.setOperation);
            this.validateFeature(validationCapability, setOperationList.getOperations().stream().anyMatch(setOperation -> setOperation instanceof UnionOp), Feature.setOperationUnion);
            this.validateFeature(validationCapability, setOperationList.getOperations().stream().anyMatch(setOperation -> setOperation instanceof IntersectOp), Feature.setOperationIntersect);
            this.validateFeature(validationCapability, setOperationList.getOperations().stream().anyMatch(setOperation -> setOperation instanceof ExceptOp), Feature.setOperationExcept);
            this.validateFeature(validationCapability, setOperationList.getOperations().stream().anyMatch(setOperation -> setOperation instanceof MinusOp), Feature.setOperationMinus);
        }
        if (this.isNotEmpty(setOperationList.getSelects())) {
            setOperationList.getSelects().forEach(selectBody -> selectBody.accept(this));
        }
        this.validateOptionalOrderByElements(setOperationList.getOrderByElements());
        if (setOperationList.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(setOperationList.getLimit());
        }
        if (setOperationList.getOffset() != null) {
            this.validateOffset(setOperationList.getOffset());
        }
        if (setOperationList.getFetch() != null) {
            this.validateFetch(setOperationList.getFetch());
        }
    }

    @Override
    public void visit(WithItem withItem) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.withItem);
            this.validateFeature(validationCapability, withItem.isRecursive(), Feature.withItemRecursive);
        }
        if (this.isNotEmpty(withItem.getWithItemList())) {
            withItem.getWithItemList().forEach(selectItem -> selectItem.accept(this));
        }
        withItem.getSubSelect().accept(this);
    }

    @Override
    public void visit(LateralSubSelect lateralSubSelect) {
        this.validateFeature(Feature.lateralSubSelect);
        this.validateOptional(lateralSubSelect.getPivot(), pivot -> pivot.accept(this));
        this.validateOptional(lateralSubSelect.getUnPivot(), unPivot -> unPivot.accept(this));
        this.validateOptional(lateralSubSelect.getSubSelect(), subSelect -> subSelect.accept(this));
    }

    @Override
    public void visit(ValuesList valuesList) {
        this.validateFeature(Feature.valuesList);
        this.validateOptionalMultiExpressionList(valuesList.getMultiExpressionList());
    }

    @Override
    public void visit(TableFunction tableFunction) {
        this.validateFeature(Feature.tableFunction);
        this.validateOptional(tableFunction.getPivot(), pivot -> pivot.accept(this));
        this.validateOptional(tableFunction.getUnPivot(), unPivot -> unPivot.accept(this));
    }

    @Override
    public void visit(ParenthesisFromItem parenthesisFromItem) {
        this.validateOptional(parenthesisFromItem.getFromItem(), fromItem -> fromItem.accept(this));
    }

    @Override
    public void visit(ValuesStatement valuesStatement) {
        this.getValidator(ValuesStatementValidator.class).validate(valuesStatement);
    }

    @Override
    public void validate(SelectItem selectItem) {
        selectItem.accept(this);
    }
}

