/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import liquibase.exception.LiquibaseException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class MavenUtils {
    public static final String LOG_SEPARATOR = "------------------------------------------------------------------------";

    public static ClassLoader getArtifactClassloader(MavenProject project, boolean includeArtifact, boolean includeTestOutputDirectory, Class clazz, Log log, boolean verbose) throws MalformedURLException {
        if (verbose) {
            log.info((CharSequence)"Loading artifacts into URLClassLoader");
        }
        HashSet<URI> uris = new HashSet<URI>();
        Set dependencies = project.getArtifacts();
        if (dependencies != null && !dependencies.isEmpty()) {
            Iterator it = dependencies.iterator();
            while (it.hasNext()) {
                MavenUtils.addArtifact(uris, (Artifact)it.next(), log, verbose);
            }
        } else {
            log.info((CharSequence)"there are no resolved artifacts for the Maven project.");
        }
        if (includeArtifact) {
            Artifact a = project.getArtifact();
            if (a.getFile() != null) {
                MavenUtils.addArtifact(uris, a, log, verbose);
            } else {
                MavenUtils.addFile(uris, new File(project.getBuild().getOutputDirectory()), log, verbose);
            }
        }
        if (includeTestOutputDirectory) {
            MavenUtils.addFile(uris, new File(project.getBuild().getTestOutputDirectory()), log, verbose);
        }
        if (verbose) {
            log.info((CharSequence)LOG_SEPARATOR);
        }
        ArrayList uriList = new ArrayList(uris);
        URL[] urlArray = new URL[uris.size()];
        for (int i = 0; i < uris.size(); ++i) {
            urlArray[i] = ((URI)uriList.get(i)).toURL();
        }
        return new URLClassLoader(urlArray, clazz.getClassLoader());
    }

    private static void addArtifact(Set<URI> urls, Artifact artifact, Log log, boolean verbose) throws MalformedURLException {
        File f = artifact.getFile();
        if (f == null) {
            log.warn((CharSequence)("Artifact with no actual file, '" + artifact.getGroupId() + ":" + artifact.getArtifactId() + "'"));
        } else {
            MavenUtils.addFile(urls, f, log, verbose);
        }
    }

    private static void addFile(Set<URI> urls, File f, Log log, boolean verbose) throws MalformedURLException {
        if (f != null) {
            URI fileUri = f.toURI();
            if (verbose) {
                log.info((CharSequence)("  artifact: " + fileUri));
            }
            urls.add(fileUri);
        }
    }

    public static Connection getDatabaseConnection(ClassLoader classLoader, String driver, String url, String username, String password) throws LiquibaseException {
        Driver dbDriver = null;
        try {
            dbDriver = (Driver)Class.forName(driver, true, classLoader).newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new LiquibaseException("Failed to load JDBC driver, " + driver, (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new LiquibaseException("Missing Class '" + e.getMessage() + "'. Database " + "driver may not be included in the project " + "dependencies or with wrong scope.");
        }
        Properties info = new Properties();
        info.put("user", username);
        info.put("password", password);
        try {
            Connection connection = dbDriver.connect(url, info);
            if (connection == null) {
                throw new LiquibaseException("Connection could not be created to " + url + " with driver " + dbDriver.getClass().getName() + ".  Possibly the wrong driver for the given " + "database URL");
            }
            return connection;
        }
        catch (SQLException e) {
            throw new LiquibaseException((Throwable)e);
        }
    }

    public static Field getDeclaredField(Class clazz, String fieldName) throws NoSuchFieldException {
        Field f = MavenUtils.getField(clazz, fieldName);
        if (f == null) {
            Class parent = clazz.getSuperclass();
            if (parent != null) {
                return MavenUtils.getDeclaredField(parent, fieldName);
            }
            throw new NoSuchFieldException("The field '" + fieldName + "' could not be " + "found in the class of any of its parent " + "classes.");
        }
        return f;
    }

    private static Field getField(Class clazz, String fieldName) {
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].getName().equals(fieldName)) continue;
            return fields[i];
        }
        return null;
    }
}

