/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.command.AbstractSelfConfiguratingCommand;
import liquibase.command.CommandExecutionException;
import liquibase.command.CommandFactory;
import liquibase.command.LiquibaseCommand;
import liquibase.configuration.GlobalConfiguration;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.plugins.MavenUtils;

public class LiquibaseRollbackOneUpdateSQL
extends AbstractLiquibaseChangeLogMojo {
    protected String deploymentId;
    protected String force;
    protected String outputFile;
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.commandName = "rollbackOneUpdateSQL";
        super.execute();
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        boolean hasProLicense = MavenUtils.checkProLicense(this.liquibaseProLicenseKey, this.commandName, this.getLog());
        if (!hasProLicense) {
            throw new LiquibaseException("The command 'rollbackOneUpdateSQL' requires a Liquibase Pro License, available at http://liquibase.org.");
        }
        Database database = liquibase.getDatabase();
        LiquibaseCommand liquibaseCommand = CommandFactory.getInstance().getCommand("rollbackOneUpdate");
        AbstractSelfConfiguratingCommand configuratingCommand = (AbstractSelfConfiguratingCommand)liquibaseCommand;
        Map<String, Object> argsMap = this.getCommandArgsObjectMap(liquibase);
        Writer outputWriter = null;
        try {
            outputWriter = this.createOutputWriter();
            argsMap.put("outputWriter", outputWriter);
        }
        catch (IOException ioe) {
            throw new LiquibaseException("Error executing rollbackOneChangeSetSQL.  Unable to create output writer.", (Throwable)ioe);
        }
        ChangeLogParameters clp = new ChangeLogParameters(database);
        argsMap.put("changeLogParameters", clp);
        if (this.force != null && !Boolean.parseBoolean(this.force)) {
            throw new LiquibaseException("Invalid value for --force.  You must specify 'liquibase.force=true' to use rollbackOneUpdateSQL.");
        }
        argsMap.put("force", Boolean.TRUE);
        argsMap.put("liquibase", liquibase);
        configuratingCommand.configure(argsMap);
        try {
            liquibaseCommand.execute();
        }
        catch (CommandExecutionException cee) {
            throw new LiquibaseException("Error executing rollbackOneUpdate", (Throwable)cee);
        }
        finally {
            try {
                outputWriter.flush();
                this.closeOutputWriter(outputWriter);
            }
            catch (IOException ioe) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Unable to close output file");
            }
        }
    }

    private void closeOutputWriter(Writer outputWriter) throws IOException {
        if (this.outputFile == null) {
            return;
        }
        outputWriter.close();
    }

    private Writer createOutputWriter() throws IOException {
        String charsetName = ((GlobalConfiguration)LiquibaseConfiguration.getInstance().getConfiguration(GlobalConfiguration.class)).getOutputEncoding();
        return new OutputStreamWriter(this.getOutputStream(), charsetName);
    }

    private OutputStream getOutputStream() throws IOException {
        FileOutputStream fileOut;
        if (this.outputFile == null) {
            return System.out;
        }
        try {
            fileOut = new FileOutputStream(this.outputFile, false);
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe(String.format(coreBundle.getString("could.not.create.output.file"), this.outputFile));
            throw e;
        }
        return fileOut;
    }

    private Map<String, Object> getCommandArgsObjectMap(Liquibase liquibase) throws LiquibaseException {
        Database database = liquibase.getDatabase();
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        argsMap.put("deploymentId", this.deploymentId);
        argsMap.put("force", this.force);
        argsMap.put("database", database);
        argsMap.put("changeLog", liquibase.getDatabaseChangeLog());
        argsMap.put("resourceAccessor", liquibase.getResourceAccessor());
        return argsMap;
    }
}

