/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import liquibase.GlobalConfiguration;
import liquibase.Liquibase;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.plugins.MavenUtils;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseRollbackOneChangeSetSQL
extends AbstractLiquibaseChangeLogMojo {
    @PropertyElement
    protected String changeSetId;
    @PropertyElement
    protected String changeSetAuthor;
    @PropertyElement
    protected String changeSetPath;
    @PropertyElement
    protected String rollbackScript;
    @PropertyElement
    protected String outputFile;
    private static ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "Change Set ID:     " + this.changeSetId));
        this.getLog().info((CharSequence)(indent + "Change Set Author: " + this.changeSetAuthor));
        this.getLog().info((CharSequence)(indent + "Change Set Path:   " + this.changeSetPath));
        this.getLog().info((CharSequence)(indent + "Rollback script:   " + this.rollbackScript));
    }

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.commandName = "rollbackOneChangeSetSQL";
        super.execute();
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        boolean hasProLicense = MavenUtils.checkProLicense(this.liquibaseProLicenseKey, this.commandName, this.getLog());
        if (!hasProLicense) {
            throw new LiquibaseException("The command 'rollbackOneChangeSetSQL' requires a Liquibase Pro License, available at http://www.liquibase.org/download or sales@liquibase.com.Add liquibase.pro.licenseKey as a Maven property or add liquibase.pro.licenseKey=<yourKey> into your defaults file.");
        }
        Database database = liquibase.getDatabase();
        CommandScope liquibaseCommand = new CommandScope(new String[]{"internalRollbackOneChangeSetSQL"});
        Map<String, Object> argsMap = this.getCommandArgsObjectMap(liquibase);
        ChangeLogParameters clp = new ChangeLogParameters(database);
        Writer outputWriter = null;
        try {
            outputWriter = this.createOutputWriter();
            argsMap.put("outputWriter", outputWriter);
        }
        catch (IOException ioe) {
            throw new LiquibaseException("Error executing rollbackOneChangeSet.  Unable to create output writer.", (Throwable)ioe);
        }
        argsMap.put("changeLogParameters", clp);
        argsMap.put("liquibase", liquibase);
        for (Map.Entry<String, Object> entry : argsMap.entrySet()) {
            liquibaseCommand.addArgumentValue(entry.getKey(), entry.getValue());
        }
        liquibaseCommand.execute();
    }

    private OutputStream getOutputStream() throws IOException {
        FileOutputStream fileOut;
        if (this.outputFile == null) {
            return System.out;
        }
        try {
            fileOut = new FileOutputStream(this.outputFile, false);
        }
        catch (IOException e) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe(String.format(coreBundle.getString("could.not.create.output.file"), this.outputFile));
            throw e;
        }
        return fileOut;
    }

    private void closeOutputWriter(Writer outputWriter) throws IOException {
        if (this.outputFile == null) {
            return;
        }
        outputWriter.close();
    }

    private Writer createOutputWriter() throws IOException {
        String charsetName = (String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue();
        return new OutputStreamWriter(this.getOutputStream(), charsetName);
    }

    private Map<String, Object> getCommandArgsObjectMap(Liquibase liquibase) throws LiquibaseException {
        Database database = liquibase.getDatabase();
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        argsMap.put("force", true);
        argsMap.put("changeLogFile", this.changeLogFile);
        argsMap.put("database", database);
        argsMap.put("changeLog", liquibase.getDatabaseChangeLog());
        argsMap.put("resourceAccessor", liquibase.getResourceAccessor());
        argsMap.put("changeSetId", this.changeSetId);
        argsMap.put("changeSetAuthor", this.changeSetAuthor);
        argsMap.put("changeSetPath", this.changeSetPath);
        return argsMap;
    }
}

