/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseChangeLogSyncToTagSQLMojo
extends AbstractLiquibaseChangeLogMojo {
    @PropertyElement
    protected File migrationSqlOutputFile;
    @PropertyElement
    protected String toTag;
    private Writer outputWriter;

    @Override
    protected void checkRequiredParametersAreSpecified() throws MojoFailureException {
        if (this.toTag == null || this.toTag.isEmpty()) {
            throw new MojoFailureException("\nYou must specify a changelog tag.");
        }
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        liquibase.changeLogSync(this.toTag, new Contexts(this.contexts), new LabelExpression(this.getLabelFilter()), this.outputWriter);
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "migrationSQLOutputFile: " + this.migrationSqlOutputFile));
    }

    @Override
    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        Liquibase liquibase = super.createLiquibase(db);
        try {
            if (!this.migrationSqlOutputFile.exists()) {
                this.migrationSqlOutputFile.getParentFile().mkdirs();
                if (!this.migrationSqlOutputFile.createNewFile()) {
                    throw new MojoExecutionException("Cannot create the migration SQL file; " + this.migrationSqlOutputFile.getAbsolutePath());
                }
            }
            this.outputWriter = this.getOutputWriter(this.migrationSqlOutputFile);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to create SQL output writer", (Exception)e);
        }
        this.getLog().info((CharSequence)("Output SQL Migration File: " + this.migrationSqlOutputFile.getAbsolutePath()));
        return liquibase;
    }

    @Override
    protected void cleanup(Database db) {
        super.cleanup(db);
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }
}

