/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.locationtech.geomesa.utils.geohash.BoundingBox;
import org.locationtech.geomesa.utils.geohash.BoundingBox$;
import org.locationtech.geomesa.utils.geohash.Bounds;
import org.locationtech.geomesa.utils.geohash.GeoHash;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.BitSet;
import scala.collection.immutable.BitSet$;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.StringOps$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;

public final class GeoHash$
implements LazyLogging,
Serializable {
    public static final GeoHash$ MODULE$;
    private final int MAX_PRECISION;
    private final Map<Object, String> org$locationtech$geomesa$utils$geohash$GeoHash$$boolMap;
    private GeometryFactory factory;
    private final Bounds latBounds;
    private double org$locationtech$geomesa$utils$geohash$GeoHash$$latRange;
    private final Bounds lonBounds;
    private double org$locationtech$geomesa$utils$geohash$GeoHash$$lonRange;
    private Map<Object, Object> org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map;
    private Map<Object, Object> latDeltaMap;
    private Map<Object, Object> lonDeltaMap;
    private final int[] org$locationtech$geomesa$utils$geohash$GeoHash$$bits;
    private final String base32;
    private final Map<Object, scala.collection.BitSet> org$locationtech$geomesa$utils$geohash$GeoHash$$characterMap;
    private final double lonMax;
    private final double latMax;
    private final Logger logger;
    private volatile byte bitmap$0;

    static {
        new GeoHash$();
    }

    private GeometryFactory factory$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.factory = new GeometryFactory(new PrecisionModel(), 4326);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.factory;
        }
    }

    private double org$locationtech$geomesa$utils$geohash$GeoHash$$latRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.org$locationtech$geomesa$utils$geohash$GeoHash$$latRange = this.latBounds().high() - this.latBounds().low();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.org$locationtech$geomesa$utils$geohash$GeoHash$$latRange;
        }
    }

    private double org$locationtech$geomesa$utils$geohash$GeoHash$$lonRange$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.org$locationtech$geomesa$utils$geohash$GeoHash$$lonRange = this.lonBounds().high() - this.lonBounds().low();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.org$locationtech$geomesa$utils$geohash$GeoHash$$lonRange;
        }
    }

    private Map org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int i) {
                        return new Tuple2.mcIJ.sp(i, 1L << i);
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map;
        }
    }

    private Map latDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.latDeltaMap = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int i) {
                        return new Tuple2.mcID.sp(i, GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$latRange() / (double)BoxesRunTime.unboxToLong((Object)GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2)))));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
            return this.latDeltaMap;
        }
    }

    private Map lonDeltaMap$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.lonDeltaMap = ((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), this.MAX_PRECISION()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(int i) {
                        return new Tuple2.mcID.sp(i, GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$lonRange() / (double)BoxesRunTime.unboxToLong((Object)GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map().apply((Object)BoxesRunTime.boxToInteger((int)(i / 2 + i % 2)))));
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
            return this.lonDeltaMap;
        }
    }

    private Logger logger$lzycompute() {
        GeoHash$ geoHash$ = this;
        synchronized (geoHash$) {
            if ((byte)(this.bitmap$0 & 0x40) == 0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x40);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 0x40) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public int MAX_PRECISION() {
        return this.MAX_PRECISION;
    }

    public Geometry toGeometry(GeoHash gh) {
        return gh.geom();
    }

    public Map<Object, String> org$locationtech$geomesa$utils$geohash$GeoHash$$boolMap() {
        return this.org$locationtech$geomesa$utils$geohash$GeoHash$$boolMap;
    }

    public GeometryFactory factory() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.factory$lzycompute() : this.factory;
    }

    private Bounds latBounds() {
        return this.latBounds;
    }

    public double org$locationtech$geomesa$utils$geohash$GeoHash$$latRange() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.org$locationtech$geomesa$utils$geohash$GeoHash$$latRange$lzycompute() : this.org$locationtech$geomesa$utils$geohash$GeoHash$$latRange;
    }

    private Bounds lonBounds() {
        return this.lonBounds;
    }

    public double org$locationtech$geomesa$utils$geohash$GeoHash$$lonRange() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.org$locationtech$geomesa$utils$geohash$GeoHash$$lonRange$lzycompute() : this.org$locationtech$geomesa$utils$geohash$GeoHash$$lonRange;
    }

    public Map<Object, Object> org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map$lzycompute() : this.org$locationtech$geomesa$utils$geohash$GeoHash$$powersOf2Map;
    }

    private Map<Object, Object> latDeltaMap() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.latDeltaMap$lzycompute() : this.latDeltaMap;
    }

    public double latitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    private Map<Object, Object> lonDeltaMap() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.lonDeltaMap$lzycompute() : this.lonDeltaMap;
    }

    public double longitudeDeltaForPrecision(int prec) {
        this.checkPrecision(prec);
        return BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    public int[] org$locationtech$geomesa$utils$geohash$GeoHash$$bits() {
        return this.org$locationtech$geomesa$utils$geohash$GeoHash$$bits;
    }

    public String base32() {
        return this.base32;
    }

    public Map<Object, scala.collection.BitSet> org$locationtech$geomesa$utils$geohash$GeoHash$$characterMap() {
        return this.org$locationtech$geomesa$utils$geohash$GeoHash$$characterMap;
    }

    private double lonMax() {
        return this.lonMax;
    }

    private double latMax() {
        return this.latMax;
    }

    public GeoHash fromBinaryString(String bitsString) {
        int numBits = bitsString.length();
        scala.collection.BitSet bitSet = (scala.collection.BitSet)((TraversableOnce)new StringOps(Predef$.MODULE$.augmentString(bitsString)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).foldLeft((Object)scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$), (Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final scala.collection.BitSet apply(scala.collection.BitSet bsSoFar, Tuple2<Object, Object> bitPosTuple) {
                Tuple2<Object, Object> tuple2 = bitPosTuple;
                if (tuple2 == null) return bsSoFar;
                char bitChar = tuple2._1$mcC$sp();
                int pos = tuple2._2$mcI$sp();
                if (bitChar != '1') return bsSoFar;
                return (scala.collection.BitSet)bsSoFar.$plus((Object)BoxesRunTime.boxToInteger((int)pos));
            }
        });
        return this.apply(bitSet, numBits);
    }

    public GeoHash apply(String string2) {
        return this.decode(string2, this.decode$default$2());
    }

    public GeoHash apply(String string2, int precision) {
        return this.decode(string2, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)precision)));
    }

    public GeoHash apply(Point p, int prec) {
        return this.apply(p.getX(), p.getY(), prec);
    }

    public GeoHash apply(scala.collection.BitSet bs, int prec) {
        return this.decode(this.org$locationtech$geomesa$utils$geohash$GeoHash$$toBase32(bs, prec), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)prec)));
    }

    public GeoHash apply(double lon, double lat, int prec) {
        Predef$.MODULE$.require(lon >= -180.0 && lon <= 180.0);
        Predef$.MODULE$.require(lat >= -90.0 && lat <= 90.0);
        this.checkPrecision(prec);
        double lonDelta = BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        double latDelta = BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec)));
        long lonIndex = lon == 180.0 ? (long)(this.lonMax() / lonDelta) : (long)((lon - this.lonBounds().low()) / lonDelta);
        long latIndex = lat == 90.0 ? (long)(this.latMax() / latDelta) : (long)((lat - this.latBounds().low()) / latDelta);
        return this.encode(lonIndex, latIndex, lonDelta, latDelta, prec);
    }

    public int apply$default$3() {
        return 25;
    }

    public Seq<GeoHash> covering(GeoHash ll, GeoHash ur, int prec) {
        this.checkPrecision(prec);
        BoundingBox bbox = new BoundingBox(ll.getPoint(), ur.getPoint());
        GeoHash init = BoundingBox$.MODULE$.getCoveringGeoHash(bbox, prec);
        return this.org$locationtech$geomesa$utils$geohash$GeoHash$$subsIntersecting$1(init, prec, bbox);
    }

    public int covering$default$3() {
        return 25;
    }

    public void checkPrecision(int precision) {
        Predef$.MODULE$.require(precision <= this.MAX_PRECISION(), (Function0)new Serializable(precision){
            public static final long serialVersionUID = 0L;
            private final int precision$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"GeoHash precision of ", " requested, but precisions above ", " are not supported"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.precision$2), BoxesRunTime.boxToInteger((int)GeoHash$.MODULE$.MAX_PRECISION())}));
            }
            {
                this.precision$2 = precision$2;
            }
        });
    }

    public Tuple2<Object, Object> getLatitudeLongitudeSpanCount(GeoHash g1, GeoHash g2, int precision) {
        Predef$.MODULE$.require(g1.prec() == precision, (Function0)new Serializable(g1, precision){
            public static final long serialVersionUID = 0L;
            private final GeoHash g1$1;
            private final int precision$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geohash ", " has precision ", " but precision ", " is required"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.g1$1.hash(), BoxesRunTime.boxToInteger((int)this.g1$1.prec()), BoxesRunTime.boxToInteger((int)this.precision$1)}));
            }
            {
                this.g1$1 = g1$1;
                this.precision$1 = precision$1;
            }
        });
        Predef$.MODULE$.require(g2.prec() == precision, (Function0)new Serializable(g2, precision){
            public static final long serialVersionUID = 0L;
            private final GeoHash g2$1;
            private final int precision$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Geohash ", " has precision ", " but precision ", " is required"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.g2$1.hash(), BoxesRunTime.boxToInteger((int)this.g2$1.prec()), BoxesRunTime.boxToInteger((int)this.precision$1)}));
            }
            {
                this.g2$1 = g2$1;
                this.precision$1 = precision$1;
            }
        });
        long[] lArray = this.gridIndicesForLatLong(g1);
        Option option2 = Array$.MODULE$.unapplySeq((Object)lArray);
        if (!option2.isEmpty() && option2.get() != null && ((SeqLike)option2.get()).lengthCompare(2) == 0) {
            Tuple2.mcJJ.sp sp2;
            long latIndex1 = BoxesRunTime.unboxToLong((Object)((SeqLike)option2.get()).apply(0));
            long lonIndex1 = BoxesRunTime.unboxToLong((Object)((SeqLike)option2.get()).apply(1));
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(latIndex1, lonIndex1);
            long latIndex12 = sp3._1$mcJ$sp();
            long lonIndex12 = sp3._2$mcJ$sp();
            long[] lArray2 = this.gridIndicesForLatLong(g2);
            Option option3 = Array$.MODULE$.unapplySeq((Object)lArray2);
            if (!option3.isEmpty() && option3.get() != null && ((SeqLike)option3.get()).lengthCompare(2) == 0) {
                Tuple2.mcJJ.sp sp4;
                long latIndex2 = BoxesRunTime.unboxToLong((Object)((SeqLike)option3.get()).apply(0));
                long lonIndex2 = BoxesRunTime.unboxToLong((Object)((SeqLike)option3.get()).apply(1));
                Tuple2.mcJJ.sp sp5 = sp4 = new Tuple2.mcJJ.sp(latIndex2, lonIndex2);
                long latIndex22 = sp5._1$mcJ$sp();
                long lonIndex22 = sp5._2$mcJ$sp();
                return new Tuple2.mcII.sp((int)(package$.MODULE$.abs(latIndex22 - latIndex12) + 1L), (int)(package$.MODULE$.abs(lonIndex22 - lonIndex12) + 1L));
            }
            throw new MatchError((Object)lArray2);
        }
        throw new MatchError((Object)lArray);
    }

    public long[] gridIndicesForLatLong(GeoHash gh) {
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(gh.bitset().toBitMask()).head()), gh.prec());
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long lonIndex = tuple2._1$mcJ$sp();
            long latIndex = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(lonIndex, latIndex);
            long lonIndex2 = sp3._1$mcJ$sp();
            long latIndex2 = sp3._2$mcJ$sp();
            return new long[]{latIndex2, lonIndex2};
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public long gridIndexForLatitude(GeoHash gh) {
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(gh.bitset().toBitMask()).head()), gh.prec());
        if (tuple2 != null) {
            void var2_5;
            long latIndex;
            long l;
            long latIndex2 = l = (latIndex = tuple2._2$mcJ$sp());
            return (long)var2_5;
        }
        throw new MatchError(tuple2);
    }

    /*
     * WARNING - void declaration
     */
    public long gridIndexForLongitude(GeoHash gh) {
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(gh.bitset().toBitMask()).head()), gh.prec());
        if (tuple2 != null) {
            void var2_5;
            long lonIndex;
            long l;
            long lonIndex2 = l = (lonIndex = tuple2._1$mcJ$sp());
            return (long)var2_5;
        }
        throw new MatchError(tuple2);
    }

    public GeoHash composeGeoHashFromBitIndicesAndPrec(long latIndex, long lonIndex, int prec) {
        this.checkPrecision(prec);
        return this.encode(lonIndex, latIndex, BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), prec);
    }

    public GeoHash next(GeoHash gh) {
        return this.apply(this.next(gh.bitset(), this.next$default$2()), gh.prec());
    }

    public scala.collection.BitSet next(scala.collection.BitSet bs, int precision) {
        return (scala.collection.BitSet)((Tuple2)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), precision).reverse().foldLeft((Object)new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$)), (Function2)new Serializable(bs){
            public static final long serialVersionUID = 0L;
            private final scala.collection.BitSet bs$1;

            public final Tuple2<Object, scala.collection.BitSet> apply(Tuple2<Object, scala.collection.BitSet> t, int idx) {
                Tuple2<Object, scala.collection.BitSet> tuple2 = t;
                if (tuple2 != null) {
                    boolean carry = tuple2._1$mcZ$sp();
                    scala.collection.BitSet newBS = (scala.collection.BitSet)tuple2._2();
                    Tuple2 tuple22 = carry ? (this.bs$1.apply((Object)BoxesRunTime.boxToInteger((int)idx)) ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)newBS) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)newBS.$plus((Object)BoxesRunTime.boxToInteger((int)idx)))) : (this.bs$1.apply((Object)BoxesRunTime.boxToInteger((int)idx)) ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)newBS.$plus((Object)BoxesRunTime.boxToInteger((int)idx))) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)newBS));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                this.bs$1 = bs$1;
            }
        }))._2();
    }

    public int next$default$2() {
        return 63;
    }

    public GeoHash encode(long lonIndex, long latIndex, double lonDelta, double latDelta, int prec) {
        BitSet bitSet = BitSet$.MODULE$.fromBitMaskNoCopy(new long[]{this.interleaveReverseBits(lonIndex, latIndex, prec)});
        BoundingBox bbox = this.bboxFromIndiciesDeltas(lonIndex, latIndex, lonDelta, latDelta);
        return new GeoHash(bbox.midLon(), bbox.midLat(), bbox, (scala.collection.BitSet)bitSet, prec, (Option<String>)None$.MODULE$);
    }

    private GeoHash decode(String string2, Option<Object> precisionOption) {
        scala.collection.BitSet bitSet;
        int prec = BoxesRunTime.unboxToInt((Object)precisionOption.getOrElse((Function0)new Serializable(string2){
            public static final long serialVersionUID = 0L;
            private final String string$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return 5 * this.string$1.length();
            }
            {
                this.string$1 = string$1;
            }
        }));
        this.checkPrecision(prec);
        scala.collection.immutable.IndexedSeq bitsets = (scala.collection.immutable.IndexedSeq)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(string2)).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final scala.collection.BitSet apply(Tuple2<Object, Object> x0$3) {
                Tuple2<Object, Object> tuple2 = x0$3;
                if (tuple2 != null) {
                    char c = tuple2._1$mcC$sp();
                    int i = tuple2._2$mcI$sp();
                    char c2 = c;
                    int n = i;
                    scala.collection.BitSet bitSet = GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$shift(n * 5, (scala.collection.BitSet)GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$characterMap().apply((Object)BoxesRunTime.boxToCharacter((char)c2)));
                    return bitSet;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        int n = bitsets.size();
        switch (n) {
            default: {
                bitSet = (scala.collection.BitSet)bitsets.reduce((Function2)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final scala.collection.BitSet apply(scala.collection.BitSet x$4, scala.collection.BitSet x$5) {
                        return (scala.collection.BitSet)x$4.$bar(x$5);
                    }
                });
                break;
            }
            case 1: {
                bitSet = (scala.collection.BitSet)bitsets.apply(0);
                break;
            }
            case 0: {
                bitSet = scala.collection.BitSet$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        }
        scala.collection.BitSet finalBitset = bitSet;
        Tuple2<Object, Object> tuple2 = this.extractReverseBits(BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longArrayOps(finalBitset.toBitMask()).head()), prec);
        if (tuple2 != null) {
            Tuple2.mcJJ.sp sp2;
            long lonIndex = tuple2._1$mcJ$sp();
            long latIndex = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp3 = sp2 = new Tuple2.mcJJ.sp(lonIndex, latIndex);
            long lonIndex2 = sp3._1$mcJ$sp();
            long latIndex2 = sp3._2$mcJ$sp();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(BoxesRunTime.unboxToDouble((Object)this.lonDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))), BoxesRunTime.unboxToDouble((Object)this.latDeltaMap().apply((Object)BoxesRunTime.boxToInteger((int)prec))));
            if (sp4 != null) {
                Tuple2.mcDD.sp sp5;
                double lonDelta = sp4._1$mcD$sp();
                double latDelta = sp4._2$mcD$sp();
                Tuple2.mcDD.sp sp6 = sp5 = new Tuple2.mcDD.sp(lonDelta, latDelta);
                double lonDelta2 = sp6._1$mcD$sp();
                double latDelta2 = sp6._2$mcD$sp();
                BoundingBox bbox = this.bboxFromIndiciesDeltas(lonIndex2, latIndex2, lonDelta2, latDelta2);
                return new GeoHash(bbox.midLon(), bbox.midLat(), bbox, finalBitset, prec, (Option<String>)new Some((Object)string2));
            }
            throw new MatchError((Object)sp4);
        }
        throw new MatchError(tuple2);
    }

    private Option<Object> decode$default$2() {
        return None$.MODULE$;
    }

    private BoundingBox bboxFromIndiciesDeltas(long lonIndex, long latIndex, double lonDelta, double latDelta) {
        return BoundingBox$.MODULE$.apply(new Bounds(this.lonBounds().low() + lonDelta * (double)lonIndex, this.lonBounds().low() + lonDelta * (double)(lonIndex + 1L)), new Bounds(this.latBounds().low() + latDelta * (double)latIndex, this.latBounds().low() + latDelta * (double)(latIndex + 1L)));
    }

    private long interleaveReverseBits(long first, long second, int numBits) {
        Tuple2.mcJJ.sp sp2;
        boolean even = (numBits & 1) == 0;
        Tuple2.mcJJ.sp sp3 = sp2 = even ? new Tuple2.mcJJ.sp(second, first) : new Tuple2.mcJJ.sp(first, second);
        if (sp2 != null) {
            Tuple2.mcJJ.sp sp4;
            long actualFirst = sp2._1$mcJ$sp();
            long actualSecond = sp2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp5 = sp4 = new Tuple2.mcJJ.sp(actualFirst, actualSecond);
            long actualFirst2 = sp5._1$mcJ$sp();
            long actualSecond2 = sp5._2$mcJ$sp();
            int numPairs = numBits >> 1;
            LongRef result = LongRef.create((long)0L);
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)new Serializable(actualFirst2, actualSecond2, result){
                public static final long serialVersionUID = 0L;
                private final long actualFirst$1;
                private final long actualSecond$1;
                private final LongRef result$1;

                public final void apply(int pairNum) {
                    this.apply$mcVI$sp(pairNum);
                }

                public void apply$mcVI$sp(int pairNum) {
                    this.result$1.elem = this.result$1.elem << 1 | this.actualFirst$1 >> pairNum & 1L;
                    this.result$1.elem = this.result$1.elem << 1 | this.actualSecond$1 >> pairNum & 1L;
                }
                {
                    this.actualFirst$1 = actualFirst$1;
                    this.actualSecond$1 = actualSecond$1;
                    this.result$1 = result$1;
                }
            });
            return even ? result.elem : result.elem << 1 | actualFirst2 >> numPairs & 1L;
        }
        throw new MatchError((Object)sp2);
    }

    private Tuple2<Object, Object> extractReverseBits(long value2, int numBits) {
        int numPairs = numBits >> 1;
        LongRef first = LongRef.create((long)0L);
        LongRef second = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numPairs).foreach$mVc$sp((Function1)new Serializable(value2, first, second){
            public static final long serialVersionUID = 0L;
            private final long value$1;
            private final LongRef first$1;
            private final LongRef second$1;

            public final void apply(int pairNum) {
                this.apply$mcVI$sp(pairNum);
            }

            public void apply$mcVI$sp(int pairNum) {
                this.first$1.elem = this.first$1.elem << 1 | this.value$1 >> pairNum * 2 & 1L;
                this.second$1.elem = this.second$1.elem << 1 | this.value$1 >> pairNum * 2 + 1 & 1L;
            }
            {
                this.value$1 = value$1;
                this.first$1 = first$1;
                this.second$1 = second$1;
            }
        });
        return new Tuple2.mcJJ.sp((numBits & 1) == 1 ? first.elem << 1 | value2 >> numBits - 1 & 1L : first.elem, second.elem);
    }

    public scala.collection.BitSet org$locationtech$geomesa$utils$geohash$GeoHash$$shift(int n, scala.collection.BitSet bs) {
        return (scala.collection.BitSet)bs.map((Function1)new Serializable(n){
            public static final long serialVersionUID = 0L;
            private final int n$1;

            public final int apply(int x$9) {
                return this.apply$mcII$sp(x$9);
            }

            public int apply$mcII$sp(int x$9) {
                return x$9 + this.n$1;
            }
            {
                this.n$1 = n$1;
            }
        }, scala.collection.BitSet$.MODULE$.canBuildFrom());
    }

    public scala.collection.BitSet org$locationtech$geomesa$utils$geohash$GeoHash$$bitSetFromBase32Character(long charIndex) {
        return scala.collection.BitSet$.MODULE$.apply((Seq)((TraversableLike)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(this.toPaddedBinaryString(charIndex, 5))).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$4) {
                Tuple2<Object, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    char c = tuple2._1$mcC$sp();
                    boolean bl = c == '1';
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Object, Object> x$10) {
                return x$10._2$mcI$sp();
            }
        }, IndexedSeq$.MODULE$.canBuildFrom()));
    }

    private String toPaddedBinaryString(long i, int length2) {
        return String.format(new StringBuilder().append((Object)"%").append((Object)BoxesRunTime.boxToInteger((int)length2)).append((Object)"s").toString(), RichLong$.MODULE$.toBinaryString$extension(Predef$.MODULE$.longWrapper(i))).replace(' ', '0');
    }

    public String org$locationtech$geomesa$utils$geohash$GeoHash$$toBase32(scala.collection.BitSet bitset, int prec) {
        int n;
        int numLeftoverBits;
        int n2 = numLeftoverBits = prec % 5;
        switch (n2) {
            default: {
                n = 5 - numLeftoverBits;
                break;
            }
            case 0: {
                n = 0;
            }
        }
        int precision = prec + n;
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), precision).grouped(5).map((Function1)new Serializable(bitset){
            public static final long serialVersionUID = 0L;
            private final scala.collection.BitSet bitset$1;

            public final char apply(scala.collection.immutable.IndexedSeq<Object> i) {
                return GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$ch((IndexedSeq<Object>)i, this.bitset$1);
            }
            {
                this.bitset$1 = bitset$1;
            }
        }).mkString();
    }

    public char org$locationtech$geomesa$utils$geohash$GeoHash$$ch(IndexedSeq<Object> v, scala.collection.BitSet bitset) {
        return StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.base32()), BoxesRunTime.unboxToInt((Object)v.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(bitset){
            public static final long serialVersionUID = 0L;
            private final scala.collection.BitSet bitset$2;

            public final int apply(int cur, int i) {
                return this.apply$mcIII$sp(cur, i);
            }

            public int apply$mcIII$sp(int cur, int i) {
                return cur + (this.bitset$2.apply((Object)BoxesRunTime.boxToInteger((int)i)) ? GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$bits()[i % GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$bits().length] : 0);
            }
            {
                this.bitset$2 = bitset$2;
            }
        })));
    }

    public GeoHash apply(double x, double y, BoundingBox bbox, scala.collection.BitSet bitset, int prec, Option<String> optHash) {
        return new GeoHash(x, y, bbox, bitset, prec, optHash);
    }

    public Option<Tuple6<Object, Object, BoundingBox, scala.collection.BitSet, Object, Option<String>>> unapply(GeoHash x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple6((Object)BoxesRunTime.boxToDouble((double)x$0.x()), (Object)BoxesRunTime.boxToDouble((double)x$0.y()), (Object)x$0.bbox(), (Object)x$0.bitset(), (Object)BoxesRunTime.boxToInteger((int)x$0.prec()), x$0.org$locationtech$geomesa$utils$geohash$GeoHash$$optHash()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public final Seq org$locationtech$geomesa$utils$geohash$GeoHash$$subsIntersecting$1(GeoHash hash2, int prec$1, BoundingBox bbox$1) {
        List list;
        if (hash2.prec() == prec$1) {
            list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new GeoHash[]{hash2}));
        } else {
            Seq<GeoHash> subs = BoundingBox$.MODULE$.generateSubGeoHashes(hash2);
            list = (Seq)subs.flatMap((Function1)new Serializable(prec$1, bbox$1){
                public static final long serialVersionUID = 0L;
                private final int prec$1;
                private final BoundingBox bbox$1;

                public final Seq<GeoHash> apply(GeoHash x0$2) {
                    GeoHash geoHash = x0$2;
                    Nil$ nil$ = this.bbox$1.intersects(geoHash.bbox()) ? GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$subsIntersecting$1(geoHash, this.prec$1, this.bbox$1) : Nil$.MODULE$;
                    return nil$;
                }
                {
                    this.prec$1 = prec$1;
                    this.bbox$1 = bbox$1;
                }
            }, Seq$.MODULE$.canBuildFrom());
        }
        return list;
    }

    private GeoHash$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        this.MAX_PRECISION = 63;
        this.org$locationtech$geomesa$utils$geohash$GeoHash$$boolMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)false)), (Object)"0"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToBoolean((boolean)true)), (Object)"1")}));
        this.latBounds = new Bounds(-90.0, 90.0);
        this.lonBounds = new Bounds(-180.0, 180.0);
        this.org$locationtech$geomesa$utils$geohash$GeoHash$$bits = new int[]{16, 8, 4, 2, 1};
        this.base32 = "0123456789bcdefghjkmnpqrstuvwxyz";
        this.org$locationtech$geomesa$utils$geohash$GeoHash$$characterMap = ((TraversableOnce)((TraversableLike)new StringOps(Predef$.MODULE$.augmentString(this.base32())).zipWithIndex(Predef$.MODULE$.fallbackStringCanBuildFrom())).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, scala.collection.BitSet> apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    char c = tuple2._1$mcC$sp();
                    int i = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToCharacter((char)c)), (Object)GeoHash$.MODULE$.org$locationtech$geomesa$utils$geohash$GeoHash$$bitSetFromBase32Character(i));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.lonMax = (double)360 - package$.MODULE$.pow(0.5, 32.0);
        this.latMax = (double)180 - package$.MODULE$.pow(0.5, 32.0);
    }
}

