/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geohash;

import org.locationtech.geomesa.utils.geohash.GeoHashIterator$;
import org.locationtech.geomesa.utils.geohash.RadialGeoHashIterator;
import org.locationtech.geomesa.utils.geohash.VincentyModel$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Point;

public final class RadialGeoHashIterator$ {
    public static final RadialGeoHashIterator$ MODULE$;

    static {
        new RadialGeoHashIterator$();
    }

    public RadialGeoHashIterator apply(double lat, double lon, double radius, int precision) {
        return this.apply(GeoHashIterator$.MODULE$.geometryFactory().createPoint(new Coordinate(lat, lon)), radius, precision);
    }

    public RadialGeoHashIterator apply(Point center, double radius, int precision) {
        double latPrecision = GeoHashIterator$.MODULE$.getDimensionPrecisionInMeters(center.getY(), true, precision >> 1);
        double lonPrecision = GeoHashIterator$.MODULE$.getDimensionPrecisionInMeters(center.getY(), false, 1 + precision >> 1);
        double effectiveRadius = Math.hypot(radius + 0.6 * latPrecision, radius + 0.6 * lonPrecision);
        Point ptLL = VincentyModel$.MODULE$.moveWithBearingAndDistance(center, -135.0, effectiveRadius);
        Point ptUR = VincentyModel$.MODULE$.moveWithBearingAndDistance(center, 45.0, effectiveRadius);
        return new RadialGeoHashIterator(center, ptLL.getY(), ptLL.getX(), ptUR.getY(), ptUR.getX(), radius, precision);
    }

    public double apply$default$3() {
        return 0.0;
    }

    public double $lessinit$greater$default$6() {
        return 0.0;
    }

    private RadialGeoHashIterator$() {
        MODULE$ = this;
    }
}

