/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.geomesa.utils.geotools;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;
import org.locationtech.geomesa.utils.collection.CloseableIterator;
import org.locationtech.geomesa.utils.conf.ArgResolver;
import org.locationtech.geomesa.utils.conf.ArgResolver$ArgTypes$;
import org.locationtech.geomesa.utils.conf.ArgResolver$class;
import org.locationtech.geomesa.utils.geotools.ConfigSftParsing$;
import org.locationtech.geomesa.utils.geotools.SftArgResolver$;
import org.locationtech.geomesa.utils.geotools.SftArgs;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypeLoader$;
import org.locationtech.geomesa.utils.geotools.SimpleFeatureTypes$;
import org.locationtech.geomesa.utils.io.PathUtils$;
import org.locationtech.geomesa.utils.io.WithClose$;
import org.locationtech.geomesa.utils.io.fs.FileSystemDelegate;
import org.opengis.feature.simple.SimpleFeatureType;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import scala.util.control.NonFatal$;

public final class SftArgResolver$
implements ArgResolver<SimpleFeatureType, SftArgs> {
    public static final SftArgResolver$ MODULE$;
    private final Seq<String> confStrings;
    private final String specStrReg;
    private final String fileNameReg;
    private final String specStrRegError;
    private final Seq<Function1<SftArgs, Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType>>> parseMethodList;
    private final ConfigParseOptions parseOpts;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new SftArgResolver$();
    }

    @Override
    public ConfigParseOptions parseOpts() {
        return this.parseOpts;
    }

    @Override
    public void org$locationtech$geomesa$utils$conf$ArgResolver$_setter_$parseOpts_$eq(ConfigParseOptions x$1) {
        this.parseOpts = x$1;
    }

    @Override
    public Either getArg(Object args) {
        return ArgResolver$class.getArg(this, args);
    }

    private Logger logger$lzycompute() {
        SftArgResolver$ sftArgResolver$ = this;
        synchronized (sftArgResolver$) {
            if (!this.bitmap$0) {
                this.logger = LazyLogging.class.logger((LazyLogging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    private Seq<String> confStrings() {
        return this.confStrings;
    }

    private String specStrReg() {
        return this.specStrReg;
    }

    private String fileNameReg() {
        return this.fileNameReg;
    }

    private String specStrRegError() {
        return this.specStrRegError;
    }

    @Override
    public Enumeration.Value argType(SftArgs args) {
        return this.confStrings().exists((Function1)new Serializable(args){
            public static final long serialVersionUID = 0L;
            private final SftArgs args$1;

            public final boolean apply(CharSequence x$1) {
                return this.args$1.spec().contains(x$1);
            }
            {
                this.args$1 = args$1;
            }
        }) ? ArgResolver$ArgTypes$.MODULE$.CONFSTR() : (args.spec().matches(this.specStrReg()) ? ArgResolver$ArgTypes$.MODULE$.SPECSTR() : (args.spec().matches(this.fileNameReg()) || args.spec().contains("/") ? ArgResolver$ArgTypes$.MODULE$.PATH() : (args.spec().matches(this.specStrRegError()) ? ArgResolver$ArgTypes$.MODULE$.SPECSTR() : ArgResolver$ArgTypes$.MODULE$.NAME())));
    }

    @Override
    public Seq<Function1<SftArgs, Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType>>> parseMethodList() {
        return this.parseMethodList;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> getLoadedSft(SftArgs args) {
        Option option2;
        block4: {
            Right right;
            block3: {
                block2: {
                    option2 = SimpleFeatureTypeLoader$.MODULE$.sfts().find((Function1)new Serializable(args){
                        public static final long serialVersionUID = 0L;
                        private final SftArgs args$2;

                        public final boolean apply(SimpleFeatureType x$1) {
                            String string2 = x$1.getTypeName();
                            String string3 = this.args$2.spec();
                            return !(string2 != null ? !string2.equals(string3) : string3 != null);
                        }
                        {
                            this.args$2 = args$2;
                        }
                    }).map((Function1)new Serializable(args){
                        public static final long serialVersionUID = 0L;
                        private final SftArgs args$2;

                        /*
                         * Enabled aggressive block sorting
                         */
                        public final SimpleFeatureType apply(SimpleFeatureType sft) {
                            SimpleFeatureType simpleFeatureType;
                            block3: {
                                block2: {
                                    if (this.args$2.featureName() == null) break block2;
                                    String string2 = this.args$2.featureName();
                                    String string3 = sft.getTypeName();
                                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block3;
                                }
                                simpleFeatureType = sft;
                                return simpleFeatureType;
                            }
                            simpleFeatureType = SimpleFeatureTypes$.MODULE$.renameSft(sft, this.args$2.featureName());
                            return simpleFeatureType;
                        }
                        {
                            this.args$2 = args$2;
                        }
                    });
                    if (!(option2 instanceof Some)) break block2;
                    Some some = (Some)option2;
                    SimpleFeatureType sft = (SimpleFeatureType)some.x();
                    right = package$.MODULE$.Right().apply((Object)sft);
                    break block3;
                }
                if (!None$.MODULE$.equals(option2)) break block4;
                right = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to get loaded SFT using ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.spec()})), (Object)new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " was not found in the loaded SFTs."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.spec()}))), (Object)ArgResolver$ArgTypes$.MODULE$.NAME()));
            }
            return right;
        }
        throw new MatchError((Object)option2);
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseSpecString(SftArgs args) {
        Right right;
        try {
            String name2 = (String)Option$.MODULE$.apply((Object)args.featureName()).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new RuntimeException("Feature name was not provided.");
                }
            });
            right = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.createType(name2, args.spec()));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            Left left = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse sft spec from string ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.spec()})), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.SPECSTR()));
            right = left;
        }
        return right;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseSpecStringFile(SftArgs args) {
        Right right;
        try {
            String name2 = (String)Option$.MODULE$.apply((Object)args.featureName()).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new RuntimeException("Feature name was not provided.");
                }
            });
            String file = (String)Option$.MODULE$.apply((Object)args.spec()).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Nothing$ apply() {
                    throw new RuntimeException("No input file specified.");
                }
            });
            String spec2 = FileUtils.readFileToString((File)new File(file), (Charset)StandardCharsets.UTF_8);
            right = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.createType(name2, spec2));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            Left left = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse sft spec from file ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.spec()})), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH()));
            right = left;
        }
        return right;
    }

    public Either<Throwable, SimpleFeatureType> parseConf(Reader input, String name2) {
        Left left;
        block15: {
            try {
                Option option2;
                block18: {
                    Right right;
                    block17: {
                        BoxedUnit boxedUnit;
                        Seq<SimpleFeatureType> sfts2;
                        block16: {
                            sfts2 = ConfigSftParsing$.MODULE$.parseConf(ConfigFactory.parseReader((Reader)input, (ConfigParseOptions)this.parseOpts()).resolve());
                            if (sfts2.isEmpty()) {
                                throw new RuntimeException("No feature types parsed from config string");
                            }
                            if (name2 == null) {
                                BoxedUnit boxedUnit2;
                                if (sfts2.lengthCompare(1) > 0) {
                                    if (this.logger().underlying().isWarnEnabled()) {
                                        this.logger().underlying().warn("Found more than one SFT conf in input arg");
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    } else {
                                        boxedUnit2 = BoxedUnit.UNIT;
                                    }
                                } else {
                                    boxedUnit2 = BoxedUnit.UNIT;
                                }
                                left = package$.MODULE$.Right().apply(sfts2.head());
                                break block15;
                            }
                            option2 = sfts2.find((Function1)new Serializable(name2){
                                public static final long serialVersionUID = 0L;
                                private final String name$1;

                                public final boolean apply(SimpleFeatureType x$2) {
                                    String string2 = x$2.getTypeName();
                                    String string3 = this.name$1;
                                    return !(string2 != null ? !string2.equals(string3) : string3 != null);
                                }
                                {
                                    this.name$1 = name$1;
                                }
                            });
                            if (!(option2 instanceof Some)) break block16;
                            Some some = (Some)option2;
                            SimpleFeatureType sft = (SimpleFeatureType)some.x();
                            right = package$.MODULE$.Right().apply((Object)sft);
                            break block17;
                        }
                        if (!None$.MODULE$.equals(option2)) break block18;
                        if (sfts2.lengthCompare(1) > 0) {
                            if (this.logger().underlying().isWarnEnabled()) {
                                this.logger().underlying().warn("Found more than one SFT conf in input arg");
                                boxedUnit = BoxedUnit.UNIT;
                            } else {
                                boxedUnit = BoxedUnit.UNIT;
                            }
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        right = package$.MODULE$.Right().apply((Object)SimpleFeatureTypes$.MODULE$.renameSft((SimpleFeatureType)sfts2.head(), name2));
                    }
                    left = right;
                    break block15;
                }
                throw new MatchError((Object)option2);
            }
            catch (Throwable throwable) {
                Left left2;
                Throwable throwable2 = throwable;
                Option option3 = NonFatal$.MODULE$.unapply(throwable2);
                if (option3.isEmpty()) {
                    throw throwable;
                }
                Throwable e = (Throwable)option3.get();
                left = left2 = package$.MODULE$.Left().apply((Object)e);
            }
        }
        return left;
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseConfStr(SftArgs args) {
        return this.parseConf(new StringReader(args.spec()), args.featureName()).left().map((Function1)new Serializable(args){
            public static final long serialVersionUID = 0L;
            private final SftArgs args$3;

            public final Tuple3<String, Throwable, Enumeration.Value> apply(Throwable e) {
                return new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse sft spec from string '", "' as conf."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args$3.spec()})), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.CONFSTR());
            }
            {
                this.args$3 = args$3;
            }
        });
    }

    public Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> parseConfFile(SftArgs args) {
        Either either;
        try {
            FileSystemDelegate.FileHandle handle = (FileSystemDelegate.FileHandle)PathUtils$.MODULE$.interpretPath(args.spec()).headOption().getOrElse((Function0)new Serializable(args){
                public static final long serialVersionUID = 0L;
                private final SftArgs args$4;

                public final Nothing$ apply() {
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read file at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args$4.spec()})));
                }
                {
                    this.args$4 = args$4;
                }
            });
            either = (Either)WithClose$.MODULE$.apply(handle.open(), new Serializable(args){
                public static final long serialVersionUID = 0L;
                public final SftArgs args$4;

                public final Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> apply(CloseableIterator<Tuple2<Option<String>, InputStream>> streams) {
                    if (streams.hasNext()) {
                        InputStreamReader reader2 = new InputStreamReader((InputStream)((Tuple2)streams.next())._2(), StandardCharsets.UTF_8);
                        return SftArgResolver$.MODULE$.parseConf(reader2, this.args$4.featureName()).left().map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.parseConfFile.1 $outer;

                            public final Tuple3<String, Throwable, Enumeration.Value> apply(Throwable e) {
                                return new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to parse sft spec from file '", "'."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.args$4.spec()})), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH());
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    throw new RuntimeException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not read file at ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.args$4.spec()})));
                }
                {
                    this.args$4 = args$4;
                }
            });
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option2 = NonFatal$.MODULE$.unapply(throwable2);
            if (option2.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option2.get();
            Left left = package$.MODULE$.Left().apply((Object)new Tuple3((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to load '", "' as file."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{args.spec()})), (Object)e, (Object)ArgResolver$ArgTypes$.MODULE$.PATH()));
            either = left;
        }
        return either;
    }

    private SftArgResolver$() {
        MODULE$ = this;
        LazyLogging.class.$init$((LazyLogging)this);
        ArgResolver$class.$init$(this);
        this.confStrings = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"geomesa{", "geomesa {", "geomesa.sfts"}));
        this.specStrReg = "^[a-zA-Z0-9]+[:][String|Integer|Double|Point|Date|Map|List].*";
        this.fileNameReg = "([^.]*)\\.([^.]*)";
        this.specStrRegError = "^[a-zA-Z0-9]+[:][a-zA-Z0-9]+.*";
        this.parseMethodList = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Function1[]{new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> apply(SftArgs args) {
                return SftArgResolver$.MODULE$.getLoadedSft(args);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> apply(SftArgs args) {
                return SftArgResolver$.MODULE$.parseSpecString(args);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> apply(SftArgs args) {
                return SftArgResolver$.MODULE$.parseConfStr(args);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> apply(SftArgs args) {
                return SftArgResolver$.MODULE$.parseSpecStringFile(args);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Either<Tuple3<String, Throwable, Enumeration.Value>, SimpleFeatureType> apply(SftArgs args) {
                return SftArgResolver$.MODULE$.parseConfFile(args);
            }
        }}));
    }
}

